/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.access_helpers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.legacy.structure_gel.StructureGelMod;
import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.jigsaw.FeatureJigsawPiece;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.jigsaw.ListJigsawPiece;
import net.minecraft.world.gen.feature.jigsaw.SingleJigsawPiece;
import net.minecraft.world.gen.feature.structure.Structure;

public class JigsawAccessHelper {
    public static void addIllagerStructures(Structure<?> ... structures) {
        Feature.field_214488_aQ = (List)Streams.concat((Stream[])new Stream[]{Feature.field_214488_aQ.stream(), Arrays.asList(structures).stream()}).collect(ImmutableList.toImmutableList());
    }

    public static void removePool(ResourceLocation pool) {
        if (JigsawManager.field_214891_a.field_214934_a.containsKey(pool)) {
            JigsawManager.field_214891_a.field_214934_a.remove(pool);
        } else {
            StructureGelMod.LOGGER.warn(String.format("Could not remove the pool %s as it does not exist.", pool));
        }
    }

    public static void addToPool(ResourceLocation pool, List<Pair<JigsawPiece, Integer>> pieces) {
        if (JigsawManager.field_214891_a.func_214933_a(pool) == JigsawPattern.field_214950_b) {
            StructureGelMod.LOGGER.warn(String.format("Could not add to %s because it has not been created yet.", pool));
            return;
        }
        for (Pair<JigsawPiece, Integer> pair : pieces) {
            Integer integer = 0;
            while (integer < (Integer)pair.getSecond()) {
                JigsawManager.field_214891_a.func_214933_a((ResourceLocation)pool).field_214953_e.add(pair.getFirst());
                integer = integer + 1;
            }
        }
    }

    public static void removeFromPool(ResourceLocation pool, ResourceLocation pieceName) {
        if (JigsawManager.field_214891_a.func_214933_a(pool) == JigsawPattern.field_214950_b) {
            StructureGelMod.LOGGER.warn(String.format("Could not remove from %s because it has not been created yet.", pool));
            return;
        }
        JigsawManager.field_214891_a.func_214933_a((ResourceLocation)pool).field_214953_e.removeIf(piece -> {
            if (piece instanceof SingleJigsawPiece) {
                return ((SingleJigsawPiece)piece).field_214861_a.equals((Object)pieceName);
            }
            if (piece instanceof ListJigsawPiece) {
                return JigsawAccessHelper.removeFromListJigsaw((ListJigsawPiece)piece, pieceName);
            }
            return false;
        });
    }

    public static void removeFromPool(ResourceLocation pool, Feature<?> feature) {
        if (JigsawManager.field_214891_a.func_214933_a(pool) == JigsawPattern.field_214950_b) {
            StructureGelMod.LOGGER.warn(String.format("Could not remove from %s because it has not been created yet.", pool));
            return;
        }
        JigsawManager.field_214891_a.func_214933_a((ResourceLocation)pool).field_214953_e.removeIf(piece -> {
            if (piece instanceof FeatureJigsawPiece) {
                return ((FeatureJigsawPiece)piece).field_214870_a.field_222737_a == feature;
            }
            if (piece instanceof ListJigsawPiece) {
                return JigsawAccessHelper.removeFromListJigsaw((ListJigsawPiece)piece, feature);
            }
            return false;
        });
    }

    public static boolean removeFromListJigsaw(ListJigsawPiece listJigsawPiece, ResourceLocation pieceName) {
        listJigsawPiece.field_214867_a.removeIf(piece -> {
            if (piece instanceof SingleJigsawPiece) {
                return ((SingleJigsawPiece)piece).field_214861_a.equals((Object)pieceName);
            }
            if (piece instanceof ListJigsawPiece) {
                JigsawAccessHelper.removeFromListJigsaw((ListJigsawPiece)piece, pieceName);
                return ((ListJigsawPiece)piece).field_214867_a.isEmpty();
            }
            return false;
        });
        return listJigsawPiece.field_214867_a.isEmpty();
    }

    public static boolean removeFromListJigsaw(ListJigsawPiece listJigsawPiece, Feature<?> feature) {
        listJigsawPiece.field_214867_a.removeIf(piece -> {
            if (piece instanceof FeatureJigsawPiece) {
                return ((FeatureJigsawPiece)piece).field_214870_a.field_222737_a == feature;
            }
            if (piece instanceof ListJigsawPiece) {
                JigsawAccessHelper.removeFromListJigsaw((ListJigsawPiece)piece, feature);
                return ((ListJigsawPiece)piece).field_214867_a.isEmpty();
            }
            return false;
        });
        return listJigsawPiece.field_214867_a.isEmpty();
    }

    public static Map<ResourceLocation, JigsawPattern> getJigsawPatternRegistry() {
        return JigsawManager.field_214891_a.field_214934_a;
    }

    public static ResourceLocation getSingleJigsawPieceLocation(SingleJigsawPiece piece) {
        return piece.field_214861_a;
    }

    public static List<JigsawPiece> getListJigsawPiecePieces(ListJigsawPiece piece) {
        return piece.field_214867_a;
    }

    public static ConfiguredFeature<?, ?> getFeatureJigsawPieceFeatures(FeatureJigsawPiece piece) {
        return piece.field_214870_a;
    }
}

