/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.rpghud.settings;

import net.minecraft.util.math.MathHelper;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElementType;
import net.spellcraftgaming.rpghud.settings.Setting;

public class SettingDouble
extends Setting {
    public final double defaultValue;
    public double value;
    public final double minValue;
    public final double maxValue;
    public final double step;

    public SettingDouble(String ID, double defaultValue, double minValue, double maxValue, double step) {
        super(ID);
        this.defaultValue = defaultValue;
        this.value = defaultValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.step = step;
    }

    public SettingDouble(String ID, HudElementType type, double defaultValue, double minValue, double maxValue, double step) {
        super(ID, type);
        this.defaultValue = defaultValue;
        this.value = defaultValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.step = step;
    }

    @Override
    public void increment() {
        this.value = this.value < this.maxValue ? (this.value += this.step) : this.minValue;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void resetValue() {
        this.value = this.defaultValue;
    }

    @Override
    public Setting setValue(Object o) {
        if (o instanceof Double) {
            this.value = (Double)o;
        }
        return this;
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public static double normalizeValue(SettingDouble setting, double value) {
        return MathHelper.func_151237_a((double)((SettingDouble.snapToStepClamp(setting, value) - setting.minValue) / (setting.maxValue - setting.minValue)), (double)0.0, (double)1.0);
    }

    public static double denormalizeValue(SettingDouble setting, double value) {
        return SettingDouble.snapToStepClamp(setting, setting.minValue + (setting.maxValue - setting.minValue) * MathHelper.func_151237_a((double)value, (double)0.0, (double)1.0));
    }

    public static double snapToStepClamp(SettingDouble setting, double value) {
        value = SettingDouble.snapToStep(setting, value);
        return MathHelper.func_151237_a((double)value, (double)setting.minValue, (double)setting.maxValue);
    }

    public static double snapToStep(SettingDouble setting, double value) {
        if (setting.step > 0.0) {
            value = setting.step * (double)Math.round(value / setting.step);
        }
        return value;
    }
}

