/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.rpghud.main;

import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.spellcraftgaming.rpghud.event.ClientEventHandler;
import net.spellcraftgaming.rpghud.gui.hud.Hud;
import net.spellcraftgaming.rpghud.gui.hud.HudDefault;
import net.spellcraftgaming.rpghud.gui.hud.HudExtendedWidget;
import net.spellcraftgaming.rpghud.gui.hud.HudFullTexture;
import net.spellcraftgaming.rpghud.gui.hud.HudHotbarWidget;
import net.spellcraftgaming.rpghud.gui.hud.HudModern;
import net.spellcraftgaming.rpghud.gui.hud.HudVanilla;
import net.spellcraftgaming.rpghud.settings.Settings;

@Mod(value="rpg-hud")
public class ModRPGHud {
    public static ModRPGHud instance;
    public static boolean[] renderDetailsAgain;
    public Settings settings;
    public Map<String, Hud> huds = new LinkedHashMap<String, Hud>();

    public ModRPGHud() {
        instance = this;
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
    }

    private void setup(FMLCommonSetupEvent event) {
        this.settings = new Settings();
        this.registerHud(new HudVanilla(Minecraft.func_71410_x(), "vanilla", "Vanilla"));
        this.registerHud(new HudDefault(Minecraft.func_71410_x(), "default", "Default"));
        this.registerHud(new HudExtendedWidget(Minecraft.func_71410_x(), "extended", "Extended Widget"));
        this.registerHud(new HudFullTexture(Minecraft.func_71410_x(), "texture", "Full Texture"));
        this.registerHud(new HudHotbarWidget(Minecraft.func_71410_x(), "hotbar", "Hotbar Widget"));
        this.registerHud(new HudModern(Minecraft.func_71410_x(), "modern", "Modern Style"));
        if (!this.isHudKeyValid(this.settings.getStringValue("hud_type"))) {
            this.settings.setSetting("hud_type", "vanilla");
        }
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        ClientEventHandler.init();
    }

    public void registerHud(Hud hud) {
        this.huds.put(hud.getHudKey(), hud);
    }

    public Hud getActiveHud() {
        return this.huds.get(this.settings.getStringValue("hud_type"));
    }

    public Hud getVanillaHud() {
        return this.huds.get("vanilla");
    }

    public boolean isHudKeyValid(String key) {
        return this.huds.containsKey(key);
    }

    static {
        renderDetailsAgain = new boolean[]{false, false, false};
    }
}

