/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.rpghud.gui.override;

import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiOverlayDebug;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceFluidMode;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.GameType;
import net.minecraft.world.border.WorldBorder;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.spellcraftgaming.rpghud.gui.hud.HudHotbarWidget;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElementType;
import net.spellcraftgaming.rpghud.main.ModRPGHud;

public class GuiIngameRPGHud
extends GuiIngameForge {
    private FontRenderer fontrenderer = null;
    private RenderGameOverlayEvent eventParent;
    private GuiOverlayDebugForge debugOverlay;
    private ModRPGHud rpgHud;

    public GuiIngameRPGHud(Minecraft mc) {
        super(mc);
        this.debugOverlay = new GuiOverlayDebugForge(mc);
        this.rpgHud = ModRPGHud.instance;
    }

    public void func_175180_a(float partialTicks) {
        ScoreObjective scoreobjective1;
        int slot;
        this.field_194811_H = this.field_73839_d.field_195558_d.func_198107_o();
        this.field_194812_I = this.field_73839_d.field_195558_d.func_198087_p();
        this.eventParent = new RenderGameOverlayEvent(partialTicks, this.field_73839_d.field_195558_d);
        right_height = 39;
        left_height = 39;
        if (this.pre(RenderGameOverlayEvent.ElementType.ALL)) {
            return;
        }
        this.fontrenderer = this.field_73839_d.field_71466_p;
        GlStateManager.func_179147_l();
        if (renderVignette && Minecraft.func_71375_t()) {
            this.func_212303_b(this.field_73839_d.func_175606_aa());
        } else {
            GlStateManager.func_179126_j();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        }
        if (renderHelmet) {
            this.renderHelmet(partialTicks);
        }
        if (renderPortal && !this.field_73839_d.field_71439_g.func_70644_a(MobEffects.field_76431_k)) {
            this.func_194805_e(partialTicks);
        }
        this.drawElement(HudElementType.WIDGET, partialTicks);
        this.drawElement(HudElementType.HOTBAR, partialTicks);
        if (!this.field_73839_d.field_71474_y.field_74319_N) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_73735_i = -90.0f;
            this.field_73842_c.setSeed(this.field_73837_f * 312871);
            this.drawElement(HudElementType.CROSSHAIR, partialTicks);
            if (renderBossHealth) {
                this.renderBossHealth();
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.field_73839_d.func_175606_aa() instanceof EntityPlayer) {
                this.drawElement(HudElementType.HEALTH, partialTicks);
                this.drawElement(HudElementType.ARMOR, partialTicks);
                this.drawElement(HudElementType.FOOD, partialTicks);
                this.drawElement(HudElementType.HEALTH_MOUNT, partialTicks);
                this.drawElement(HudElementType.AIR, partialTicks);
                this.drawElement(HudElementType.CLOCK, partialTicks);
                this.drawElement(HudElementType.DETAILS, partialTicks);
                this.drawElement(HudElementType.COMPASS, partialTicks);
                this.drawElement(HudElementType.ENTITY_INSPECT, partialTicks);
            }
            this.drawElement(HudElementType.EXPERIENCE, partialTicks);
            this.drawElement(HudElementType.LEVEL, partialTicks);
            this.drawElement(HudElementType.JUMP_BAR, partialTicks);
            if (this.field_73839_d.field_71474_y.field_92117_D && this.field_73839_d.field_71442_b.func_178889_l() != GameType.SPECTATOR) {
                this.func_194801_c();
            } else if (this.field_73839_d.field_71439_g.func_175149_v()) {
                this.field_175197_u.func_195623_a();
            }
        }
        this.renderSleepFade(this.field_194811_H, this.field_194812_I);
        this.renderHUDText(this.field_194811_H, this.field_194812_I);
        this.renderFPSGraph();
        this.func_194809_b();
        if (!this.field_73839_d.field_71474_y.field_74319_N) {
            this.drawElement(HudElementType.RECORD_OVERLAY, partialTicks);
            this.renderSubtitles();
            this.renderTitle(this.field_194811_H, this.field_194812_I, partialTicks);
        }
        Scoreboard scoreboard = this.field_73839_d.field_71441_e.func_96441_U();
        ScoreObjective objective = null;
        ScorePlayerTeam scoreplayerteam = scoreboard.func_96509_i(this.field_73839_d.field_71439_g.func_195047_I_());
        if (scoreplayerteam != null && (slot = scoreplayerteam.func_178775_l().func_175746_b()) >= 0) {
            objective = scoreboard.func_96539_a(3 + slot);
        }
        ScoreObjective scoreObjective = scoreobjective1 = objective != null ? objective : scoreboard.func_96539_a(1);
        if (renderObjective && scoreobjective1 != null) {
            this.func_194802_a(scoreobjective1);
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179118_c();
        this.renderChat(this.field_194811_H, this.field_194812_I);
        this.renderPlayerList(this.field_194811_H, this.field_194812_I);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179141_d();
        this.post(RenderGameOverlayEvent.ElementType.ALL);
    }

    protected void func_194809_b() {
        if (this.pre(RenderGameOverlayEvent.ElementType.POTION_ICONS)) {
            return;
        }
        Collection collection = this.field_73839_d.field_71439_g.func_70651_bq();
        if (!collection.isEmpty()) {
            this.field_73839_d.func_110434_K().func_110577_a(GuiContainer.field_147001_a);
            GlStateManager.func_179147_l();
            int i = 0;
            int j = 0;
            for (PotionEffect potioneffect : Ordering.natural().reverse().sortedCopy((Iterable)collection)) {
                Potion potion = potioneffect.func_188419_a();
                if (!potion.shouldRenderHUD(potioneffect)) continue;
                this.field_73839_d.func_110434_K().func_110577_a(GuiContainer.field_147001_a);
                if (!potioneffect.func_205348_f()) continue;
                int k = this.field_194811_H;
                int l = 1;
                if (this.field_73839_d.func_71355_q()) {
                    l += 15;
                }
                int i1 = potion.func_76392_e();
                if (potion.func_188408_i()) {
                    k -= 25 * ++i;
                } else {
                    k -= 25 * ++j;
                    l += 26;
                }
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                float f = 1.0f;
                if (potioneffect.func_82720_e()) {
                    this.func_73729_b(k, l, 165, 166, 24, 24);
                } else {
                    this.func_73729_b(k, l, 141, 166, 24, 24);
                    if (potioneffect.func_76459_b() <= 200) {
                        int j1 = 10 - potioneffect.func_76459_b() / 20;
                        f = MathHelper.func_76131_a((float)((float)potioneffect.func_76459_b() / 10.0f / 5.0f * 0.5f), (float)0.0f, (float)0.5f) + MathHelper.func_76134_b((float)((float)potioneffect.func_76459_b() * (float)Math.PI / 5.0f)) * MathHelper.func_76131_a((float)((float)j1 / 10.0f * 0.25f), (float)0.0f, (float)0.25f);
                    }
                }
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)f);
                int l1 = i1 % 12;
                int k1 = i1 / 12;
                if (potion.func_76400_d()) {
                    this.func_73729_b(k + 3, l + 3, l1 * 18, 198 + k1 * 18, 18, 18);
                }
                potion.renderHUDEffect(potioneffect, (Gui)this, k, l, this.field_73735_i, f);
            }
        }
        this.post(RenderGameOverlayEvent.ElementType.POTION_ICONS);
    }

    protected void renderSubtitles() {
        if (this.pre(RenderGameOverlayEvent.ElementType.SUBTITLES)) {
            return;
        }
        this.field_184049_t.func_195620_a();
        this.post(RenderGameOverlayEvent.ElementType.SUBTITLES);
    }

    protected void renderBossHealth() {
        if (this.pre(RenderGameOverlayEvent.ElementType.BOSSHEALTH)) {
            return;
        }
        this.bind(Gui.field_110324_m);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        this.field_73839_d.field_71424_I.func_76320_a("bossHealth");
        GlStateManager.func_179147_l();
        this.field_184050_w.func_184051_a();
        GlStateManager.func_179084_k();
        this.field_73839_d.field_71424_I.func_76319_b();
        this.post(RenderGameOverlayEvent.ElementType.BOSSHEALTH);
    }

    protected void func_212303_b(Entity entity) {
        if (this.pre(RenderGameOverlayEvent.ElementType.VIGNETTE)) {
            GlStateManager.func_179126_j();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            return;
        }
        WorldBorder worldborder = this.field_73839_d.field_71441_e.func_175723_af();
        float f = (float)worldborder.func_177745_a(entity);
        double d0 = Math.min(worldborder.func_177749_o() * (double)worldborder.func_177740_p() * 1000.0, Math.abs(worldborder.func_177751_j() - worldborder.func_177741_h()));
        double d1 = Math.max((double)worldborder.func_177748_q(), d0);
        f = (double)f < d1 ? 1.0f - (float)((double)f / d1) : 0.0f;
        GlStateManager.func_179097_i();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        if (f > 0.0f) {
            GlStateManager.func_179131_c((float)0.0f, (float)f, (float)f, (float)1.0f);
        } else {
            GlStateManager.func_179131_c((float)this.field_73843_a, (float)this.field_73843_a, (float)this.field_73843_a, (float)1.0f);
        }
        this.field_73839_d.func_110434_K().func_110577_a(field_110329_b);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b(0.0, (double)this.field_194812_I, -90.0).func_187315_a(0.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b((double)this.field_194811_H, (double)this.field_194812_I, -90.0).func_187315_a(1.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b((double)this.field_194811_H, 0.0, -90.0).func_187315_a(1.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b(0.0, 0.0, -90.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179126_j();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        this.post(RenderGameOverlayEvent.ElementType.VIGNETTE);
    }

    private void renderHelmet(float partialTicks) {
        if (this.pre(RenderGameOverlayEvent.ElementType.HELMET)) {
            return;
        }
        ItemStack itemstack = this.field_73839_d.field_71439_g.field_71071_by.func_70440_f(3);
        if (this.field_73839_d.field_71474_y.field_74320_O == 0 && !itemstack.func_190926_b()) {
            Item item = itemstack.func_77973_b();
            if (item == Blocks.field_196625_cS.func_199767_j()) {
                this.func_194808_p();
            } else {
                item.renderHelmetOverlay(itemstack, (EntityPlayer)this.field_73839_d.field_71439_g, this.field_194811_H, this.field_194812_I, partialTicks);
            }
        }
        this.post(RenderGameOverlayEvent.ElementType.HELMET);
    }

    protected void func_194805_e(float partialTicks) {
        if (this.pre(RenderGameOverlayEvent.ElementType.PORTAL)) {
            return;
        }
        float timeInPortal = this.field_73839_d.field_71439_g.field_71080_cy + (this.field_73839_d.field_71439_g.field_71086_bY - this.field_73839_d.field_71439_g.field_71080_cy) * partialTicks;
        if (timeInPortal > 0.0f) {
            if (timeInPortal < 1.0f) {
                timeInPortal *= timeInPortal;
                timeInPortal *= timeInPortal;
                timeInPortal = timeInPortal * 0.8f + 0.2f;
            }
            GlStateManager.func_179118_c();
            GlStateManager.func_179097_i();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)timeInPortal);
            this.field_73839_d.func_110434_K().func_110577_a(TextureMap.field_110575_b);
            TextureAtlasSprite textureatlassprite = this.field_73839_d.func_175602_ab().func_175023_a().func_178122_a(Blocks.field_150427_aO.func_176223_P());
            float f = textureatlassprite.func_94209_e();
            float f1 = textureatlassprite.func_94206_g();
            float f2 = textureatlassprite.func_94212_f();
            float f3 = textureatlassprite.func_94210_h();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            bufferbuilder.func_181662_b(0.0, (double)this.field_194812_I, -90.0).func_187315_a((double)f, (double)f3).func_181675_d();
            bufferbuilder.func_181662_b((double)this.field_194811_H, (double)this.field_194812_I, -90.0).func_187315_a((double)f2, (double)f3).func_181675_d();
            bufferbuilder.func_181662_b((double)this.field_194811_H, 0.0, -90.0).func_187315_a((double)f2, (double)f1).func_181675_d();
            bufferbuilder.func_181662_b(0.0, 0.0, -90.0).func_187315_a((double)f, (double)f1).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179126_j();
            GlStateManager.func_179141_d();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        this.post(RenderGameOverlayEvent.ElementType.PORTAL);
    }

    public void func_175188_a(ITextComponent component, boolean animateColor) {
        this.func_110326_a(component.func_150254_d(), animateColor);
    }

    protected void renderSleepFade(int width, int height) {
        if (this.field_73839_d.field_71439_g.func_71060_bI() > 0) {
            this.field_73839_d.field_71424_I.func_76320_a("sleep");
            GlStateManager.func_179097_i();
            GlStateManager.func_179118_c();
            int sleepTime = this.field_73839_d.field_71439_g.func_71060_bI();
            float opacity = (float)sleepTime / 100.0f;
            if (opacity > 1.0f) {
                opacity = 1.0f - (float)(sleepTime - 100) / 10.0f;
            }
            int color = (int)(220.0f * opacity) << 24 | 0x101020;
            GuiIngameRPGHud.func_73734_a((int)0, (int)0, (int)width, (int)height, (int)color);
            GlStateManager.func_179141_d();
            GlStateManager.func_179126_j();
            this.field_73839_d.field_71424_I.func_76319_b();
        }
    }

    protected void renderHUDText(int width, int height) {
        RenderGameOverlayEvent.Text event;
        this.field_73839_d.field_71424_I.func_76320_a("forgeHudText");
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        ArrayList listL = new ArrayList();
        ArrayList<String> listR = new ArrayList<String>();
        if (this.field_73839_d.func_71355_q()) {
            long time = this.field_73839_d.field_71441_e.func_82737_E();
            if (time >= 120500L) {
                listR.add(I18n.func_135052_a((String)"demo.demoExpired", (Object[])new Object[0]));
            } else {
                listR.add(I18n.func_135052_a((String)"demo.remainingTime", (Object[])new Object[]{StringUtils.func_76337_a((int)((int)(120500L - time)))}));
            }
        }
        if (this.field_73839_d.field_71474_y.field_74330_P && !this.pre(RenderGameOverlayEvent.ElementType.DEBUG)) {
            this.debugOverlay.update();
            listL.addAll(this.debugOverlay.getLeft());
            listR.addAll(this.debugOverlay.getRight());
            this.post(RenderGameOverlayEvent.ElementType.DEBUG);
        }
        if (!MinecraftForge.EVENT_BUS.post((Event)(event = new RenderGameOverlayEvent.Text(this.eventParent, listL, listR)))) {
            int top = 2;
            for (String msg : listL) {
                if (msg == null) continue;
                GuiIngameRPGHud.func_73734_a((int)1, (int)(top - 1), (int)(2 + this.fontrenderer.func_78256_a(msg) + 1), (int)(top + this.fontrenderer.field_78288_b - 1), (int)-1873784752);
                this.fontrenderer.func_175063_a(msg, 2.0f, (float)top, 0xE0E0E0);
                top += this.fontrenderer.field_78288_b;
            }
            top = 2;
            for (String msg : listR) {
                if (msg == null) continue;
                int w = this.fontrenderer.func_78256_a(msg);
                int left = width - 2 - w;
                GuiIngameRPGHud.func_73734_a((int)(left - 1), (int)(top - 1), (int)(left + w + 1), (int)(top + this.fontrenderer.field_78288_b - 1), (int)-1873784752);
                this.fontrenderer.func_175063_a(msg, (float)left, (float)top, 0xE0E0E0);
                top += this.fontrenderer.field_78288_b;
            }
        }
        this.field_73839_d.field_71424_I.func_76319_b();
        this.post(RenderGameOverlayEvent.ElementType.TEXT);
    }

    protected void renderFPSGraph() {
        if (this.field_73839_d.field_71474_y.field_74330_P && this.field_73839_d.field_71474_y.field_181657_aC && !this.pre(RenderGameOverlayEvent.ElementType.FPS_GRAPH)) {
            this.debugOverlay.func_181554_e();
            this.post(RenderGameOverlayEvent.ElementType.FPS_GRAPH);
        }
    }

    protected void renderTitle(int width, int height, float partialTicks) {
        if (this.field_175195_w > 0) {
            this.field_73839_d.field_71424_I.func_76320_a("titleAndSubtitle");
            float age = (float)this.field_175195_w - partialTicks;
            int opacity = 255;
            if (this.field_175195_w > this.field_175193_B + this.field_175192_A) {
                float f3 = (float)(this.field_175199_z + this.field_175192_A + this.field_175193_B) - age;
                opacity = (int)(f3 * 255.0f / (float)this.field_175199_z);
            }
            if (this.field_175195_w <= this.field_175193_B) {
                opacity = (int)(age * 255.0f / (float)this.field_175193_B);
            }
            if ((opacity = MathHelper.func_76125_a((int)opacity, (int)0, (int)255)) > 8) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)(width / 2), (float)(height / 2), (float)0.0f);
                GlStateManager.func_179147_l();
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)4.0f, (float)4.0f, (float)4.0f);
                int l = opacity << 24 & 0xFF000000;
                this.func_175179_f().func_175063_a(this.field_175201_x, (float)(-this.func_175179_f().func_78256_a(this.field_175201_x) / 2), -10.0f, 0xFFFFFF | l);
                GlStateManager.func_179121_F();
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
                this.func_175179_f().func_175063_a(this.field_175200_y, (float)(-this.func_175179_f().func_78256_a(this.field_175200_y) / 2), 5.0f, 0xFFFFFF | l);
                GlStateManager.func_179121_F();
                GlStateManager.func_179084_k();
                GlStateManager.func_179121_F();
            }
            this.field_73839_d.field_71424_I.func_76319_b();
        }
    }

    protected void renderChat(int width, int height) {
        RenderGameOverlayEvent.Chat event;
        this.field_73839_d.field_71424_I.func_76320_a("chat");
        int offset = 0;
        if (ModRPGHud.instance.getActiveHud() instanceof HudHotbarWidget) {
            offset = -22;
        }
        if (MinecraftForge.EVENT_BUS.post((Event)(event = new RenderGameOverlayEvent.Chat(this.eventParent, 0, height - 48 + offset)))) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)event.getPosX(), (float)event.getPosY(), (float)0.0f);
        this.field_73840_e.func_146230_a(this.field_73837_f);
        GlStateManager.func_179121_F();
        this.post(RenderGameOverlayEvent.ElementType.CHAT);
        this.field_73839_d.field_71424_I.func_76319_b();
    }

    protected void renderPlayerList(int width, int height) {
        ScoreObjective scoreobjective = this.field_73839_d.field_71441_e.func_96441_U().func_96539_a(0);
        NetHandlerPlayClient handler = this.field_73839_d.field_71439_g.field_71174_a;
        if (this.field_73839_d.field_71474_y.field_74321_H.func_151470_d() && (!this.field_73839_d.func_71387_A() || handler.func_175106_d().size() > 1 || scoreobjective != null)) {
            this.field_175196_v.func_175246_a(true);
            if (this.pre(RenderGameOverlayEvent.ElementType.PLAYER_LIST)) {
                return;
            }
            this.field_175196_v.func_175249_a(width, this.field_73839_d.field_71441_e.func_96441_U(), scoreobjective);
            this.post(RenderGameOverlayEvent.ElementType.PLAYER_LIST);
        } else {
            this.field_175196_v.func_175246_a(false);
        }
    }

    private boolean pre(RenderGameOverlayEvent.ElementType type) {
        return MinecraftForge.EVENT_BUS.post((Event)new RenderGameOverlayEvent.Pre(this.eventParent, type));
    }

    private void post(RenderGameOverlayEvent.ElementType type) {
        MinecraftForge.EVENT_BUS.post((Event)new RenderGameOverlayEvent.Post(this.eventParent, type));
    }

    private void bind(ResourceLocation res) {
        this.field_73839_d.func_110434_K().func_110577_a(res);
    }

    public String getOverlayMessage() {
        return this.field_73838_g;
    }

    public int getOverlayMessageTime() {
        return this.field_73845_h;
    }

    public boolean getAnimateOverlayMessageColor() {
        return this.field_73844_j;
    }

    private void drawElement(HudElementType type, float partialTicks) {
        if (this.rpgHud.getActiveHud().checkElementConditions(type)) {
            RenderGameOverlayEvent.ElementType alias = GuiIngameRPGHud.getEventAlias(type);
            if (this.forceRenderType(type)) {
                if (this.forceRenderTypeVanilla(type)) {
                    if (!this.preventElementRenderType(type)) {
                        this.bind(Gui.field_110324_m);
                        GlStateManager.func_179147_l();
                        this.rpgHud.getVanillaHud().drawElement(type, (Gui)this, partialTicks, partialTicks, this.field_194811_H, this.field_194812_I);
                        GlStateManager.func_179084_k();
                    }
                    if (alias != null && !this.preventEventType(type)) {
                        if (this.pre(alias)) {
                            return;
                        }
                        this.post(alias);
                    }
                } else {
                    if (!this.preventElementRenderType(type)) {
                        this.bind(Gui.field_110324_m);
                        GlStateManager.func_179147_l();
                        this.rpgHud.getActiveHud().drawElement(type, (Gui)this, partialTicks, partialTicks, this.field_194811_H, this.field_194812_I);
                        GlStateManager.func_179084_k();
                    }
                    if (alias != null && !this.preventEventType(type)) {
                        if (this.pre(alias)) {
                            return;
                        }
                        this.post(alias);
                    }
                }
            } else if (this.forceRenderTypeVanilla(type)) {
                if (alias != null && !this.preventEventType(type) && this.pre(alias)) {
                    return;
                }
                if (!this.preventElementRenderType(type)) {
                    this.bind(Gui.field_110324_m);
                    GlStateManager.func_179147_l();
                    this.rpgHud.getVanillaHud().drawElement(type, (Gui)this, partialTicks, partialTicks, this.field_194811_H, this.field_194812_I);
                    GlStateManager.func_179084_k();
                }
                if (alias != null && !this.preventEventType(type)) {
                    this.post(alias);
                }
            } else {
                if (alias != null && !this.preventEventType(type) && this.pre(alias)) {
                    return;
                }
                if (!this.preventElementRenderType(type)) {
                    this.bind(Gui.field_110324_m);
                    GlStateManager.func_179147_l();
                    this.rpgHud.getActiveHud().drawElement(type, (Gui)this, partialTicks, partialTicks, this.field_194811_H, this.field_194812_I);
                    GlStateManager.func_179084_k();
                }
                if (alias != null && !this.preventEventType(type)) {
                    this.post(alias);
                }
            }
        }
    }

    private boolean forceRenderType(HudElementType type) {
        String id = "force_render_" + type.name().toLowerCase();
        if (this.rpgHud.settings.doesSettingExist(id)) {
            return this.rpgHud.settings.getBoolValue(id);
        }
        return false;
    }

    private boolean preventElementRenderType(HudElementType type) {
        String id = "prevent_element_render_" + type.name().toLowerCase();
        if (this.rpgHud.settings.doesSettingExist(id)) {
            return this.rpgHud.settings.getBoolValue(id);
        }
        return false;
    }

    private boolean forceRenderTypeVanilla(HudElementType type) {
        String id = "force_render_" + type.name().toLowerCase();
        if (this.rpgHud.settings.doesSettingExist(id)) {
            return this.rpgHud.settings.getBoolValue(id);
        }
        return false;
    }

    private boolean preventEventType(HudElementType type) {
        String id = "prevent_event_" + type.name().toLowerCase();
        if (this.rpgHud.settings.doesSettingExist(id)) {
            return this.rpgHud.settings.getBoolValue(id);
        }
        return false;
    }

    private static RenderGameOverlayEvent.ElementType getEventAlias(HudElementType type) {
        switch (type) {
            case HOTBAR: {
                return RenderGameOverlayEvent.ElementType.HOTBAR;
            }
            case CROSSHAIR: {
                return RenderGameOverlayEvent.ElementType.CROSSHAIRS;
            }
            case HEALTH: {
                return RenderGameOverlayEvent.ElementType.HEALTH;
            }
            case ARMOR: {
                return RenderGameOverlayEvent.ElementType.ARMOR;
            }
            case FOOD: {
                return RenderGameOverlayEvent.ElementType.FOOD;
            }
            case HEALTH_MOUNT: {
                return RenderGameOverlayEvent.ElementType.HEALTHMOUNT;
            }
            case AIR: {
                return RenderGameOverlayEvent.ElementType.AIR;
            }
            case JUMP_BAR: {
                return RenderGameOverlayEvent.ElementType.JUMPBAR;
            }
            case EXPERIENCE: {
                return RenderGameOverlayEvent.ElementType.EXPERIENCE;
            }
        }
        return null;
    }

    private class GuiOverlayDebugForge
    extends GuiOverlayDebug {
        private Minecraft mc;

        private GuiOverlayDebugForge(Minecraft mc) {
            super(mc);
            this.mc = mc;
        }

        public void update() {
            Entity entity = this.mc.func_175606_aa();
            this.field_211537_g = entity.func_174822_a(20.0, 0.0f, RayTraceFluidMode.NEVER);
            this.field_211538_h = entity.func_174822_a(20.0, 0.0f, RayTraceFluidMode.ALWAYS);
        }

        protected void func_180798_a() {
        }

        protected void func_194819_c() {
        }

        private List<String> getLeft() {
            List ret = this.func_209011_c();
            ret.add("");
            ret.add("Debug: Pie [shift]: " + (this.mc.field_71474_y.field_74329_Q ? "visible" : "hidden") + " FPS [alt]: " + (this.mc.field_71474_y.field_181657_aC ? "visible" : "hidden"));
            ret.add("For help: press F3 + Q");
            return ret;
        }

        private List<String> getRight() {
            return this.func_175238_c();
        }
    }
}

