/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.rpghud.gui.hud.element.hotbar;

import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.spellcraftgaming.lib.GameData;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElement;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElementType;

public class HudElementFoodHotbar
extends HudElement {
    public HudElementFoodHotbar() {
        super(HudElementType.FOOD, 0, 0, 0, 0, true);
        this.parent = HudElementType.WIDGET;
    }

    @Override
    public boolean checkConditions() {
        return GameData.shouldDrawHUD();
    }

    @Override
    public void drawElement(Gui gui, float zLevel, float partialTicks) {
        String staminaString;
        int stamina = GameData.getPlayerFood();
        int staminaMax = GameData.getPlayerMaxFood();
        ScaledResolution res = new ScaledResolution(this.mc);
        int height = res.func_78328_b() + this.settings.getPositionValue("hunger_position")[1];
        int posX = (this.settings.getBoolValue("render_player_face") != false ? 49 : 25) + this.settings.getPositionValue("hunger_position")[0];
        int offset = GameData.getHotbarWidgetWidthOffset();
        ItemStack itemMain = GameData.getMainhand();
        ItemStack itemSec = GameData.getOffhand();
        if (GameData.doesPlayerNeedFood() && this.settings.getBoolValue("show_hunger_preview").booleanValue()) {
            float value = 0.0f;
            if (itemMain != GameData.nullStack() && itemMain.func_77973_b() instanceof ItemFood) {
                value = ((ItemFood)itemMain.func_77973_b()).func_150905_g(itemMain);
            } else if (itemSec != GameData.nullStack() && itemSec.func_77973_b() instanceof ItemFood) {
                value = ((ItemFood)itemSec.func_77973_b()).func_150905_g(itemSec);
            }
            if (value > 0.0f) {
                int bonusHunger = (int)(value + (float)stamina);
                if (bonusHunger > staminaMax) {
                    bonusHunger = staminaMax;
                }
                int colorPreview = HudElementFoodHotbar.offsetColor(this.settings.getIntValue("color_food"), 0x5A5A5A);
                HudElementFoodHotbar.drawCustomBar(posX, height - 26, 200 + offset, 10, (double)bonusHunger / (double)staminaMax * 100.0, -1, -1, colorPreview, HudElementFoodHotbar.offsetColorPercent(colorPreview, 25));
            }
        }
        if (GameData.isPlayerHungered()) {
            HudElementFoodHotbar.drawCustomBar(posX, height - 26, 200 + offset, 10, (double)stamina / (double)staminaMax * 100.0, -1, -1, this.settings.getIntValue("color_hunger"), HudElementFoodHotbar.offsetColorPercent(this.settings.getIntValue("color_hunger"), 25));
        } else {
            HudElementFoodHotbar.drawCustomBar(posX, height - 26, 200 + offset, 10, (double)stamina / (double)staminaMax * 100.0, -1, -1, this.settings.getIntValue("color_food"), HudElementFoodHotbar.offsetColorPercent(this.settings.getIntValue("color_food"), 25));
        }
        String string = staminaString = this.settings.getBoolValue("hunger_percentage") == true ? (int)Math.floor((double)stamina / (double)staminaMax * 100.0) + "%" : stamina + "/" + staminaMax;
        if (this.settings.getBoolValue("show_numbers_food").booleanValue()) {
            gui.func_73732_a(GameData.getFontRenderer(), staminaString, posX + 100 + offset / 2, height - 25, -1);
        }
    }
}

