/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.rpghud.gui;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiLabel;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.spellcraftgaming.lib.GameData;
import net.spellcraftgaming.rpghud.gui.GuiButtonTooltip;
import net.spellcraftgaming.rpghud.gui.GuiScreenTooltip;
import net.spellcraftgaming.rpghud.gui.GuiSettingsModColor;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElementType;
import net.spellcraftgaming.rpghud.main.ModRPGHud;
import net.spellcraftgaming.rpghud.settings.SettingColor;
import net.spellcraftgaming.rpghud.settings.SettingPosition;
import net.spellcraftgaming.rpghud.settings.Settings;

public class GuiSettingsMod
extends GuiScreenTooltip {
    private Settings settings;
    private GuiScreen parent;
    private String subSetting;
    private Map<String, List<GuiTextField>> textFields = new HashMap<String, List<GuiTextField>>();

    public GuiSettingsMod(GuiScreen parent, String subSetting) {
        this.parent = parent;
        this.settings = ModRPGHud.instance.settings;
        this.subSetting = subSetting;
    }

    public GuiSettingsMod(GuiScreen parent) {
        this.parent = parent;
        this.settings = ModRPGHud.instance.settings;
        this.subSetting = "";
    }

    public void func_73866_w_() {
        if (this.subSetting.equals("")) {
            GuiButtonTooltip guismallbutton = new GuiButtonTooltip(0, this.field_146294_l / 2 - 155 + 0, this.field_146295_m / 6 - 14 + 0, "general", I18n.func_135052_a((String)"gui.rpg.general", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"tooltip.general", (Object[])new Object[0]));
            this.field_146292_n.add(guismallbutton);
            int count = 1;
            for (HudElementType type : HudElementType.values()) {
                List<String> settings = this.settings.getSettingsOf(type);
                if (settings.isEmpty()) continue;
                guismallbutton = new GuiButtonTooltip(count, this.field_146294_l / 2 - 155 + count % 2 * 160, this.field_146295_m / 6 - 14 + 20 * (count >> 1), type.name(), type.getDisplayName()).setTooltip(I18n.func_135052_a((String)"tooltip.element", (Object[])new Object[0]));
                this.field_146292_n.add(guismallbutton);
                ++count;
            }
        } else {
            List<String> settings = this.settings.getSettingsOf(this.subSetting);
            int id = 0;
            for (int i = 0; i < settings.size(); ++i) {
                if (this.settings.getSetting(settings.get(i)) instanceof SettingPosition) {
                    String[] values = ((String)this.settings.getSetting(settings.get(i)).getValue()).split("_");
                    ArrayList<GuiTextField> fields = new ArrayList<GuiTextField>();
                    GuiLabel settingLabel = new GuiLabel(GameData.getFontRenderer(), id, this.field_146294_l / 2 - 154 + i % 2 * 160, this.field_146295_m / 6 - 11 + 20 * (i >> 1), 30, 15, Color.white.getRGB());
                    settingLabel = GameData.addLine(settingLabel, this.settings.getButtonString(settings.get(i)));
                    this.field_146293_o.add(settingLabel);
                    GuiTextField xPos = new GuiTextField(id + 1, GameData.getFontRenderer(), this.field_146294_l / 2 - 100 + i % 2 * 160, this.field_146295_m / 6 - 12 + 20 * (i >> 1), 45, 15);
                    xPos.func_146180_a(values[0]);
                    fields.add(xPos);
                    GuiTextField yPos = new GuiTextField(id + 2, GameData.getFontRenderer(), this.field_146294_l / 2 - 100 + i % 2 * 160 + 50, this.field_146295_m / 6 - 12 + 20 * (i >> 1), 45, 15);
                    yPos.func_146180_a(values[1]);
                    fields.add(yPos);
                    this.textFields.put(settings.get(i), fields);
                    id += 2;
                    continue;
                }
                GuiButtonTooltip guismallbutton = new GuiButtonTooltip(id, this.field_146294_l / 2 - 155 + i % 2 * 160, this.field_146295_m / 6 - 14 + 20 * (i >> 1), settings.get(i), this.settings.getButtonString(settings.get(i))).setTooltip(this.settings.getSetting(settings.get(i)).getTooltip());
                this.field_146292_n.add(guismallbutton);
                ++id;
            }
        }
        this.field_146292_n.add(new GuiButtonTooltip(100, this.field_146294_l / 2 - 100, this.field_146295_m / 6 + 168, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])).setTooltip(I18n.func_135052_a((String)"tooltip.done", (Object[])new Object[0])));
    }

    public void func_146280_a(Minecraft mc, int width, int height) {
        this.field_146293_o.clear();
        this.textFields.clear();
        super.func_146280_a(mc, width, height);
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            if (button.field_146127_k == 100) {
                for (String settingID : this.textFields.keySet()) {
                    this.settings.setSetting(settingID, this.textFields.get(settingID).get(0).func_146179_b() + "_" + this.textFields.get(settingID).get(1).func_146179_b());
                }
                this.settings.saveSettings();
                this.field_146297_k.func_147108_a(this.parent);
            } else if (this.subSetting.equals("")) {
                GuiButtonTooltip b = (GuiButtonTooltip)button;
                if (b.enumOptions != null) {
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiSettingsMod(this, b.enumOptions));
                }
            } else {
                GuiButtonTooltip b = (GuiButtonTooltip)button;
                if (b.enumOptions != null) {
                    if (this.settings.getSetting(b.enumOptions) instanceof SettingColor) {
                        this.field_146297_k.func_147108_a((GuiScreen)new GuiSettingsModColor(this, b.enumOptions));
                    } else {
                        this.settings.increment(b.enumOptions);
                        button.field_146126_j = this.settings.getButtonString(b.enumOptions);
                    }
                }
            }
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.func_73732_a(GameData.getFontRenderer(), I18n.func_135052_a((String)"gui.rpg.settings", (Object[])new Object[0]), this.field_146294_l / 2, 12, 0xFFFFFF);
        for (List<GuiTextField> positionPairs : this.textFields.values()) {
            for (GuiTextField t : positionPairs) {
                t.func_146194_f();
            }
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public void func_73876_c() {
        super.func_73876_c();
        for (String settingID : this.textFields.keySet()) {
            for (GuiTextField t : this.textFields.get(settingID)) {
                if (t.func_146206_l()) {
                    this.settings.getSetting(settingID).setValue(this.textFields.get(settingID).get(0).func_146179_b() + "_" + this.textFields.get(settingID).get(1).func_146179_b());
                }
                t.func_146178_a();
            }
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        for (List<GuiTextField> positionPairs : this.textFields.values()) {
            for (GuiTextField t : positionPairs) {
                if (!t.func_146206_l()) continue;
                t.func_146201_a(typedChar, keyCode);
                if (keyCode != 28) continue;
                t.func_146195_b(false);
            }
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        for (List<GuiTextField> positionPairs : this.textFields.values()) {
            for (GuiTextField t : positionPairs) {
                t.func_146192_a(mouseX, mouseY, mouseButton);
            }
        }
    }
}

