/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.lib;

import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiLabel;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.FoodStats;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.spellcraftgaming.lib.gui.override.GuiIngameRPGHud;

public class GameData {
    protected static final ResourceLocation buttonTextures = new ResourceLocation("textures/gui/widgets.png");
    private static Minecraft mc;

    public static Minecraft getMinecraft() {
        if (mc == null) {
            mc = Minecraft.func_71410_x();
        }
        return mc;
    }

    public static FontRenderer getFontRenderer() {
        return GameData.getMinecraft().field_71466_p;
    }

    public static World getWorldOfEntity(Entity entity) {
        return entity.field_70170_p;
    }

    public static boolean shouldDrawHUD() {
        return GameData.getMinecraft().field_71442_b.func_78755_b();
    }

    public static EntityPlayerSP getPlayer() {
        return GameData.getMinecraft().field_71439_g;
    }

    public static int getHotbarWidgetWidthOffset() {
        return -20;
    }

    public static int getPlayerHealth() {
        return GameData.ceil(GameData.getPlayer().func_110143_aJ());
    }

    public static int getPlayerMaxHealth() {
        return GameData.ceil(GameData.getPlayer().func_110148_a(SharedMonsterAttributes.field_111267_a).func_111126_e());
    }

    public static int getPlayerAbsorption() {
        return GameData.floor(GameData.getPlayer().func_110139_bj());
    }

    public static boolean isPlayerPoisoned() {
        return GameData.getPlayer().func_70644_a(Potion.field_76436_u);
    }

    public static boolean isPlayerRegenerating() {
        return GameData.getPlayer().func_70644_a(Potion.field_76428_l);
    }

    public static boolean isPlayerWithering() {
        return GameData.getPlayer().func_70644_a(Potion.field_82731_v);
    }

    public static int getPlayerAir() {
        return GameData.getPlayer().func_70086_ai();
    }

    public static boolean isPlayerUnderwater() {
        return GameData.getPlayer().func_70055_a(Material.field_151586_h);
    }

    public static int getPlayerArmor() {
        return ForgeHooks.getTotalArmorValue((EntityPlayer)GameData.getPlayer());
    }

    public static int getPlayerXPCap() {
        return GameData.getPlayer().func_71050_bK();
    }

    public static float getPlayerXPRaw() {
        return GameData.getPlayer().field_71106_cc;
    }

    public static int getPlayerXP() {
        return GameData.ceil((float)GameData.getPlayerXPCap() * GameData.getPlayer().field_71106_cc);
    }

    public static FoodStats getPlayerFoodStats() {
        return GameData.getPlayer().func_71024_bL();
    }

    public static int getPlayerFood() {
        return GameData.getPlayerFoodStats().func_75116_a();
    }

    public static int getPlayerMaxFood() {
        return 20;
    }

    public static boolean doesPlayerNeedFood() {
        return GameData.getPlayerFoodStats().func_75121_c();
    }

    public static boolean isPlayerHungered() {
        return GameData.getPlayer().func_70644_a(Potion.field_76438_s);
    }

    public static boolean isPlayerCreative() {
        return GameData.getMinecraft().field_71442_b.func_78758_h();
    }

    public static ItemStack getMainhand() {
        return GameData.getPlayer().func_70694_bm();
    }

    public static ItemStack getOffhand() {
        return GameData.nullStack();
    }

    public static Entity getMount() {
        return GameData.getPlayer().field_70154_o;
    }

    public static boolean isRidingLivingMount() {
        return GameData.getMount() instanceof EntityLivingBase;
    }

    public static ItemStack getMainInventoryItemOfSlot(int slot) {
        return GameData.getPlayer().field_71071_by.field_70462_a[slot];
    }

    public static float getCooledAttackStrength() {
        return 1.0f;
    }

    public static float getCooldownPeriod() {
        return 1.0f;
    }

    public static float getItemAnimationsToGo(ItemStack item) {
        return item.field_77992_b;
    }

    public static float getHorseJumpPower() {
        return GameData.getPlayer().func_110319_bJ();
    }

    public static int getPlayerXPLevel() {
        return GameData.getPlayer().field_71068_ca;
    }

    public static boolean hasPlayerClock() {
        return GameData.getPlayer().field_71071_by.func_70431_c(new ItemStack(Items.field_151113_aN));
    }

    public static boolean hasPlayerCompass() {
        return GameData.getPlayer().field_71071_by.func_70431_c(new ItemStack(Items.field_151111_aL));
    }

    public static int getPlayerArmorInventoryLength() {
        return GameData.getPlayer().field_71071_by.field_70460_b.length;
    }

    public static ItemStack getArmorInSlot(int slot) {
        return GameData.getPlayer().field_71071_by.func_70440_f(slot);
    }

    public static ItemStack getItemInHand(int hand) {
        if (hand == 0) {
            return GameData.getMainhand();
        }
        if (hand == 1) {
            return GameData.getOffhand();
        }
        return GameData.nullStack();
    }

    public static int getOffhandSide() {
        return 0;
    }

    public static int getInventorySize() {
        return GameData.getPlayer().field_71071_by.func_70302_i_();
    }

    public static ItemStack getItemInSlot(int slot) {
        return GameData.getPlayer().field_71071_by.func_70301_a(slot);
    }

    public static int getItemStackSize(ItemStack item) {
        return item.field_77994_a;
    }

    public static ItemStack setItemStackSize(ItemStack item, int count) {
        item.field_77994_a = count;
        return item;
    }

    public static float getRotationYaw() {
        return GameData.getPlayer().field_70177_z;
    }

    public static long getWorldTime() {
        return GameData.getPlayer().func_130014_f_().func_72820_D();
    }

    public static int[] getPlayerPos() {
        int[] pos = new int[]{GameData.getPlayer().func_180425_c().func_177958_n(), GameData.getPlayer().func_180425_c().func_177956_o(), GameData.getPlayer().func_180425_c().func_177952_p()};
        return pos;
    }

    public static ItemStack nullStack() {
        return null;
    }

    public static World getWorld() {
        return GameData.getMinecraft().field_71441_e;
    }

    public static float overlayMessageTime(GuiIngameRPGHud gui) {
        return gui.getRecordPlayingUpFor();
    }

    public static int overlayColor(GuiIngameRPGHud gui, float hue) {
        return 0xFFFFFF;
    }

    public static boolean isRecordPlaying(GuiIngameRPGHud gui) {
        return gui.getRecordIsPlaying();
    }

    public static String getOverlayText(GuiIngameRPGHud gui) {
        return gui.getRecordPlaying();
    }

    public static int getAttackIndicatorSetting() {
        return -1;
    }

    public static int addArrowStackIfCorrect(ItemStack item, ItemStack arrow) {
        return GameData.getItemStackSize(arrow);
    }

    public static ItemStack arrowStack() {
        return new ItemStack(Items.field_151032_g);
    }

    public static void bindIcons() {
        GameData.getMinecraft().func_110434_K().func_110577_a(Gui.field_110324_m);
    }

    public static void bindButtonTextures() {
        GameData.getMinecraft().func_110434_K().func_110577_a(buttonTextures);
    }

    public static void renderItemIntoGUI(EntityPlayer player, ItemStack item, int xPos, int yPos) {
        GameData.getMinecraft().func_175599_af().func_180450_b(item, xPos, yPos);
    }

    public static boolean spectatorStuff() {
        return false;
    }

    public static boolean isArrow(ItemStack item) {
        if (item != GameData.nullStack()) {
            return ItemStack.func_179545_c((ItemStack)item, (ItemStack)GameData.arrowStack());
        }
        return false;
    }

    public static EntityPlayer playerOfEvent(EntityItemPickupEvent event) {
        return event.entityPlayer;
    }

    public static ItemStack itemStackOfEvent(EntityItemPickupEvent event) {
        return event.item.func_92059_d();
    }

    public static void beginVertex(int i, VertexFormat format) {
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(i, format);
    }

    public static void addVertexPos(double x, double y, double z) {
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181662_b(x, y, z).func_181675_d();
    }

    public static void drawVertex() {
        Tessellator tessellator = Tessellator.func_178181_a();
        tessellator.func_78381_a();
    }

    public static void doRenderDirections() {
    }

    public static int getSrcAlpha() {
        return 770;
    }

    public static int getOneMinusSrcAlpha() {
        return 771;
    }

    public static int getOneMinusDstColor() {
        return 775;
    }

    public static int getOneMinusSrcColor() {
        return 769;
    }

    public static int getGlOne() {
        return 1;
    }

    public static int getGlZero() {
        return 0;
    }

    public static void tryBlendFuncSeparate() {
        GlStateManager.func_179120_a((int)GameData.getSrcAlpha(), (int)GameData.getOneMinusSrcAlpha(), (int)GameData.getGlOne(), (int)GameData.getGlZero());
    }

    public static void tryBlendFuncCrosshair() {
        GlStateManager.func_179120_a((int)GameData.getOneMinusDstColor(), (int)GameData.getOneMinusSrcColor(), (int)GameData.getGlOne(), (int)GameData.getGlZero());
    }

    public static void blendFunc() {
        GlStateManager.func_179112_b((int)GameData.getSrcAlpha(), (int)GameData.getOneMinusSrcAlpha());
    }

    public static int ceil(float value) {
        return MathHelper.func_76123_f((float)value);
    }

    public static int floor(float value) {
        return MathHelper.func_76141_d((float)value);
    }

    public static int ceil(double value) {
        return MathHelper.func_76143_f((double)value);
    }

    public static double clamp(double d1, double d2, double d3) {
        return MathHelper.func_151237_a((double)d1, (double)d2, (double)d3);
    }

    public static float clamp(float f1, float f2, float f3) {
        return MathHelper.func_76131_a((float)f1, (float)f2, (float)f3);
    }

    public static int clamp(int f1, int f2, int f3) {
        return MathHelper.func_76125_a((int)f1, (int)f2, (int)f3);
    }

    public static int hsvToRGB(float f1, float f2, float f3) {
        return 0;
    }

    public static Vec3 scaleVec(Vec3 vec, double scale) {
        return new Vec3(vec.field_72450_a * scale, vec.field_72448_b * scale, vec.field_72449_c * scale);
    }

    public static EntityLiving getFocusedEntity(Entity watcher) {
        EntityLiving focusedEntity = null;
        double maxDistance = 64.0;
        Vec3 vec = new Vec3(watcher.field_70165_t, watcher.field_70163_u, watcher.field_70161_v);
        Vec3 posVec = watcher.func_174791_d();
        if (watcher instanceof EntityPlayer) {
            vec = vec.func_72441_c(0.0, (double)watcher.func_70047_e(), 0.0);
            posVec = posVec.func_72441_c(0.0, (double)watcher.func_70047_e(), 0.0);
        }
        Vec3 lookVec = watcher.func_70040_Z();
        Vec3 vec2 = vec.func_178787_e(GameData.scaleVec(lookVec.func_72432_b(), maxDistance));
        MovingObjectPosition ray = GameData.getWorldOfEntity(watcher).func_72933_a(vec, vec2);
        double distance = maxDistance;
        if (ray != null) {
            distance = ray.field_72307_f.func_72438_d(posVec);
        }
        Vec3 reachVector = posVec.func_72441_c(lookVec.field_72450_a * maxDistance, lookVec.field_72448_b * maxDistance, lookVec.field_72449_c * maxDistance);
        double currentDistance = distance;
        List entitiesWithinMaxDistance = GameData.getWorldOfEntity(watcher).func_72839_b(watcher, watcher.func_174813_aQ().func_72321_a(lookVec.field_72450_a * maxDistance, lookVec.field_72448_b * maxDistance, lookVec.field_72449_c * maxDistance).func_72314_b(1.0, 1.0, 1.0));
        for (Entity entity : entitiesWithinMaxDistance) {
            double distanceToEntity;
            if (!(entity instanceof EntityLiving)) continue;
            float collisionBorderSize = entity.func_70111_Y();
            AxisAlignedBB hitBox = entity.func_174813_aQ().func_72314_b((double)collisionBorderSize, (double)collisionBorderSize, (double)collisionBorderSize);
            MovingObjectPosition intercept = hitBox.func_72327_a(posVec, reachVector);
            if (hitBox.func_72318_a(posVec)) {
                if (!(currentDistance <= 0.0)) continue;
                currentDistance = 0.0;
                focusedEntity = (EntityLiving)entity;
                continue;
            }
            if (intercept == null || !((distanceToEntity = posVec.func_72438_d(intercept.field_72307_f)) <= currentDistance)) continue;
            currentDistance = distanceToEntity;
            focusedEntity = (EntityLiving)entity;
        }
        return focusedEntity;
    }

    public static int getButtonX(GuiButton b) {
        return b.field_146128_h;
    }

    public static int getButtonY(GuiButton b) {
        return b.field_146128_h;
    }

    public static GuiScreen getGuiOfEvent(GuiScreenEvent event) {
        return event.gui;
    }

    public static GuiLabel addLine(GuiLabel label, String string) {
        label.func_175202_a(string);
        return label;
    }
}

