/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.worldGeneration.structure.base.processor;

import com.davidm1a2.afraidofthedark.common.capabilities.world.IHeightmap;
import com.davidm1a2.afraidofthedark.common.worldGeneration.structure.base.processor.IChunkProcessor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.math.ChunkPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\r\u0010\t\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/davidm1a2/afraidofthedark/common/worldGeneration/structure/base/processor/AverageHeightChunkProcessor;", "Lcom/davidm1a2/afraidofthedark/common/worldGeneration/structure/base/processor/IChunkProcessor;", "", "heightmap", "Lcom/davidm1a2/afraidofthedark/common/capabilities/world/IHeightmap;", "(Lcom/davidm1a2/afraidofthedark/common/capabilities/world/IHeightmap;)V", "datapoints", "", "heightSum", "getResult", "()Ljava/lang/Integer;", "processChunk", "", "chunkPos", "Lnet/minecraft/util/math/ChunkPos;", "afraidofthedark"})
public final class AverageHeightChunkProcessor
implements IChunkProcessor<Integer> {
    private double heightSum;
    private double datapoints;
    private final IHeightmap heightmap;

    @Override
    public boolean processChunk(@NotNull ChunkPos chunkPos) {
        Intrinsics.checkParameterIsNotNull(chunkPos, "chunkPos");
        this.heightSum += (double)((this.heightmap.getLowestHeight(chunkPos) + this.heightmap.getHighestHeight(chunkPos)) / 2);
        double d = this.datapoints;
        this.datapoints = d + 1.0;
        return true;
    }

    @Override
    @NotNull
    public Integer getResult() {
        double d = this.heightSum / this.datapoints;
        boolean bl = false;
        return (int)Math.rint(d);
    }

    public AverageHeightChunkProcessor(@NotNull IHeightmap heightmap) {
        Intrinsics.checkParameterIsNotNull(heightmap, "heightmap");
        this.heightmap = heightmap;
    }

    @Override
    @Nullable
    public Integer getDefaultResult() {
        return IChunkProcessor.DefaultImpls.getDefaultResult(this);
    }
}

