/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.worldGeneration.structure;

import com.davidm1a2.afraidofthedark.AfraidOfTheDark;
import com.davidm1a2.afraidofthedark.common.capabilities.world.IHeightmap;
import com.davidm1a2.afraidofthedark.common.capabilities.world.OverworldHeightmap;
import com.davidm1a2.afraidofthedark.common.constants.ModLootTables;
import com.davidm1a2.afraidofthedark.common.constants.ModSchematics;
import com.davidm1a2.afraidofthedark.common.worldGeneration.schematic.Schematic;
import com.davidm1a2.afraidofthedark.common.worldGeneration.schematic.SchematicGenerator;
import com.davidm1a2.afraidofthedark.common.worldGeneration.structure.base.AOTDStructure;
import com.davidm1a2.afraidofthedark.common.worldGeneration.structure.base.iterator.InteriorChunkIterator;
import com.davidm1a2.afraidofthedark.common.worldGeneration.structure.base.processor.IChunkProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import net.minecraft.init.Biomes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001d\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016J(\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u0015H\u0002\u00a8\u0006\u001f"}, d2={"Lcom/davidm1a2/afraidofthedark/common/worldGeneration/structure/StructureDesertOasis;", "Lcom/davidm1a2/afraidofthedark/common/worldGeneration/structure/base/AOTDStructure;", "()V", "computeChanceToGenerateAt", "", "blockPos", "Lnet/minecraft/util/math/BlockPos;", "heightmap", "Lcom/davidm1a2/afraidofthedark/common/capabilities/world/IHeightmap;", "biomeProvider", "Lnet/minecraft/world/biome/BiomeProvider;", "generate", "", "world", "Lnet/minecraft/world/World;", "chunkPos", "Lnet/minecraft/util/math/ChunkPos;", "data", "Lnet/minecraft/nbt/NBTTagCompound;", "generateStructureData", "getXWidth", "", "getZLength", "recordPlotPicks", "nbt", "tagName", "", "numTypes", "numWanted", "Companion", "PlotType", "afraidofthedark"})
public final class StructureDesertOasis
extends AOTDStructure {
    private static final String NBT_SMALL_PLOT_INDICES = "small_plot_indices";
    private static final String NBT_SMALL90_PLOT_INDICES = "small90_plot_indices";
    private static final String NBT_MEDIUM_PLOT_INDICES = "medium_plot_indices";
    private static final String NBT_MEDIUM90_PLOT_INDICES = "medium90_plot_indices";
    private static final String NBT_LARGE_PLOT_INDICES = "large_plot_indices";
    private static final Set<Biome> VALID_BIOMES;
    public static final Companion Companion;

    @Override
    public double computeChanceToGenerateAt(@NotNull BlockPos blockPos, @NotNull IHeightmap heightmap, @NotNull BiomeProvider biomeProvider) {
        Intrinsics.checkParameterIsNotNull(blockPos, "blockPos");
        Intrinsics.checkParameterIsNotNull(heightmap, "heightmap");
        Intrinsics.checkParameterIsNotNull(biomeProvider, "biomeProvider");
        return ((Number)this.processChunks(new IChunkProcessor<Double>(this, biomeProvider){
            private double numValidChunks;
            private double numNonValidChunks;
            final /* synthetic */ StructureDesertOasis this$0;
            final /* synthetic */ BiomeProvider $biomeProvider;

            public final double getNumValidChunks() {
                return this.numValidChunks;
            }

            public final void setNumValidChunks(double d) {
                this.numValidChunks = d;
            }

            public final double getNumNonValidChunks() {
                return this.numNonValidChunks;
            }

            public final void setNumNonValidChunks(double d) {
                this.numNonValidChunks = d;
            }

            public boolean processChunk(@NotNull ChunkPos chunkPos) {
                boolean bl;
                block5: {
                    Intrinsics.checkParameterIsNotNull(chunkPos, "chunkPos");
                    Set biomes = StructureDesertOasis.access$getBiomesInChunk(this.this$0, this.$biomeProvider, chunkPos.field_77276_a, chunkPos.field_77275_b);
                    Iterable $this$any$iv = biomes;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            Biome it = (Biome)element$iv;
                            boolean bl2 = false;
                            if (!(!StructureDesertOasis.access$getVALID_BIOMES$cp().contains(it))) continue;
                            bl = true;
                            break block5;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    double d = this.numNonValidChunks;
                    this.numNonValidChunks = d + 1.0;
                } else {
                    double d = this.numValidChunks;
                    this.numValidChunks = d + 1.0;
                }
                return true;
            }

            @NotNull
            public Double getResult() {
                double percentDesertTiles = this.numValidChunks / (this.numValidChunks + this.numNonValidChunks);
                return percentDesertTiles > 0.7 ? 0.005 * (double)AfraidOfTheDark.Companion.getINSTANCE().getConfigurationHandler().getDesertOasisMultiplier() : 0.0;
            }

            @NotNull
            public Double getDefaultResult() {
                return 0.0;
            }
            {
                this.this$0 = $outer;
                this.$biomeProvider = $captured_local_variable$1;
            }
        }, new InteriorChunkIterator(this, blockPos))).doubleValue();
    }

    @Override
    public void generate(@NotNull World world, @NotNull ChunkPos chunkPos, @NotNull NBTTagCompound data) {
        int pick;
        int index;
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(chunkPos, "chunkPos");
        Intrinsics.checkParameterIsNotNull(data, "data");
        BlockPos blockPos = this.getPosition(data);
        SchematicGenerator.INSTANCE.generateSchematic(ModSchematics.INSTANCE.getDESERT_OASIS(), world, blockPos, chunkPos, ModLootTables.INSTANCE.getDESERT_OASIS());
        NBTBase nBTBase = data.func_74781_a(NBT_SMALL_PLOT_INDICES);
        if (nBTBase == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.minecraft.nbt.NBTTagIntArray");
        }
        int[] nArray = ((NBTTagIntArray)nBTBase).func_150302_c();
        Intrinsics.checkExpressionValueIsNotNull(nArray, "(data.getTag(NBT_SMALL_P\u2026 NBTTagIntArray).intArray");
        int[] $this$forEachIndexed$iv = nArray;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (int item$iv : $this$forEachIndexed$iv) {
            int n = index$iv++;
            int n2 = item$iv;
            index = n;
            boolean bl = false;
            Schematic schematic = ModSchematics.INSTANCE.getDESERT_OASIS_SMALL_PLOTS()[pick];
            BlockPos blockPos2 = blockPos.func_177971_a((Vec3i)PlotType.Small.getBaseOffsets().get(index));
            Intrinsics.checkExpressionValueIsNotNull(blockPos2, "blockPos.add(PlotType.Small.baseOffsets[index])");
            SchematicGenerator.INSTANCE.generateSchematic(schematic, world, blockPos2, chunkPos, ModLootTables.INSTANCE.getDESERT_OASIS());
        }
        NBTBase nBTBase2 = data.func_74781_a(NBT_SMALL90_PLOT_INDICES);
        if (nBTBase2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.minecraft.nbt.NBTTagIntArray");
        }
        int[] nArray2 = ((NBTTagIntArray)nBTBase2).func_150302_c();
        Intrinsics.checkExpressionValueIsNotNull(nArray2, "(data.getTag(NBT_SMALL90\u2026 NBTTagIntArray).intArray");
        $this$forEachIndexed$iv = nArray2;
        $i$f$forEachIndexed = false;
        index$iv = 0;
        for (int item$iv : $this$forEachIndexed$iv) {
            int n = index$iv++;
            pick = item$iv;
            index = n;
            boolean bl = false;
            Schematic schematic = ModSchematics.INSTANCE.getDESERT_OASIS_SMALL_PLOTS90()[pick];
            BlockPos blockPos3 = blockPos.func_177971_a((Vec3i)PlotType.Small90.getBaseOffsets().get(index));
            Intrinsics.checkExpressionValueIsNotNull(blockPos3, "blockPos.add(PlotType.Small90.baseOffsets[index])");
            SchematicGenerator.INSTANCE.generateSchematic(schematic, world, blockPos3, chunkPos, ModLootTables.INSTANCE.getDESERT_OASIS());
        }
        NBTBase nBTBase3 = data.func_74781_a(NBT_MEDIUM_PLOT_INDICES);
        if (nBTBase3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.minecraft.nbt.NBTTagIntArray");
        }
        int[] nArray3 = ((NBTTagIntArray)nBTBase3).func_150302_c();
        Intrinsics.checkExpressionValueIsNotNull(nArray3, "(data.getTag(NBT_MEDIUM_\u2026 NBTTagIntArray).intArray");
        $this$forEachIndexed$iv = nArray3;
        $i$f$forEachIndexed = false;
        index$iv = 0;
        for (int item$iv : $this$forEachIndexed$iv) {
            int n = index$iv++;
            pick = item$iv;
            index = n;
            boolean bl = false;
            Schematic schematic = ModSchematics.INSTANCE.getDESERT_OASIS_MEDIUM_PLOTS()[pick];
            BlockPos blockPos4 = blockPos.func_177971_a((Vec3i)PlotType.Medium.getBaseOffsets().get(index));
            Intrinsics.checkExpressionValueIsNotNull(blockPos4, "blockPos.add(PlotType.Medium.baseOffsets[index])");
            SchematicGenerator.INSTANCE.generateSchematic(schematic, world, blockPos4, chunkPos, ModLootTables.INSTANCE.getDESERT_OASIS());
        }
        NBTBase nBTBase4 = data.func_74781_a(NBT_MEDIUM90_PLOT_INDICES);
        if (nBTBase4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.minecraft.nbt.NBTTagIntArray");
        }
        int[] nArray4 = ((NBTTagIntArray)nBTBase4).func_150302_c();
        Intrinsics.checkExpressionValueIsNotNull(nArray4, "(data.getTag(NBT_MEDIUM9\u2026 NBTTagIntArray).intArray");
        $this$forEachIndexed$iv = nArray4;
        $i$f$forEachIndexed = false;
        index$iv = 0;
        for (int item$iv : $this$forEachIndexed$iv) {
            int n = index$iv++;
            pick = item$iv;
            index = n;
            boolean bl = false;
            Schematic schematic = ModSchematics.INSTANCE.getDESERT_OASIS_MEDIUM_PLOTS90()[pick];
            BlockPos blockPos5 = blockPos.func_177971_a((Vec3i)PlotType.Medium90.getBaseOffsets().get(index));
            Intrinsics.checkExpressionValueIsNotNull(blockPos5, "blockPos.add(PlotType.Medium90.baseOffsets[index])");
            SchematicGenerator.INSTANCE.generateSchematic(schematic, world, blockPos5, chunkPos, ModLootTables.INSTANCE.getDESERT_OASIS());
        }
        NBTBase nBTBase5 = data.func_74781_a(NBT_LARGE_PLOT_INDICES);
        if (nBTBase5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.minecraft.nbt.NBTTagIntArray");
        }
        int[] nArray5 = ((NBTTagIntArray)nBTBase5).func_150302_c();
        Intrinsics.checkExpressionValueIsNotNull(nArray5, "(data.getTag(NBT_LARGE_P\u2026 NBTTagIntArray).intArray");
        $this$forEachIndexed$iv = nArray5;
        $i$f$forEachIndexed = false;
        index$iv = 0;
        for (int item$iv : $this$forEachIndexed$iv) {
            int n = index$iv++;
            pick = item$iv;
            index = n;
            boolean bl = false;
            Schematic schematic = ModSchematics.INSTANCE.getDESERT_OASIS_LARGE_PLOTS()[pick];
            BlockPos blockPos6 = blockPos.func_177971_a((Vec3i)PlotType.Large.getBaseOffsets().get(index));
            Intrinsics.checkExpressionValueIsNotNull(blockPos6, "blockPos.add(PlotType.Large.baseOffsets[index])");
            SchematicGenerator.INSTANCE.generateSchematic(schematic, world, blockPos6, chunkPos, ModLootTables.INSTANCE.getDESERT_OASIS());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public NBTTagCompound generateStructureData(@NotNull World world, @NotNull BlockPos blockPos, @NotNull BiomeProvider biomeProvider) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(blockPos, "blockPos");
        Intrinsics.checkParameterIsNotNull(biomeProvider, "biomeProvider");
        NBTTagCompound nbt = new NBTTagCompound();
        IHeightmap heightmap = OverworldHeightmap.Companion.get(world);
        Iterable $this$map$iv = new InteriorChunkIterator(this, blockPos).getChunks();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ChunkPos chunkPos = (ChunkPos)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Integer n = heightmap.getLowestHeight((ChunkPos)it);
            collection.add(n);
        }
        int averageLowHeight = (int)CollectionsKt.averageOfInt((List)destination$iv$iv);
        int n = 0;
        int yHeight = RangesKt.coerceIn(averageLowHeight - 18, new IntRange(n, 255));
        nbt.func_74782_a("position", (NBTBase)NBTUtil.func_186859_a((BlockPos)new BlockPos(blockPos.func_177958_n(), yHeight, blockPos.func_177952_p())));
        this.recordPlotPicks(nbt, NBT_SMALL_PLOT_INDICES, ModSchematics.INSTANCE.getDESERT_OASIS_SMALL_PLOTS().length, PlotType.Small.getBaseOffsets().size());
        this.recordPlotPicks(nbt, NBT_SMALL90_PLOT_INDICES, ModSchematics.INSTANCE.getDESERT_OASIS_SMALL_PLOTS90().length, PlotType.Small90.getBaseOffsets().size());
        this.recordPlotPicks(nbt, NBT_MEDIUM_PLOT_INDICES, ModSchematics.INSTANCE.getDESERT_OASIS_MEDIUM_PLOTS().length, PlotType.Medium.getBaseOffsets().size());
        this.recordPlotPicks(nbt, NBT_MEDIUM90_PLOT_INDICES, ModSchematics.INSTANCE.getDESERT_OASIS_MEDIUM_PLOTS90().length, PlotType.Medium90.getBaseOffsets().size());
        this.recordPlotPicks(nbt, NBT_LARGE_PLOT_INDICES, ModSchematics.INSTANCE.getDESERT_OASIS_LARGE_PLOTS().length, PlotType.Large.getBaseOffsets().size());
        return nbt;
    }

    private final void recordPlotPicks(NBTTagCompound nbt, String tagName, int numTypes, int numWanted) {
        boolean bl = numWanted <= numTypes * 2;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        List plotPicks = CollectionsKt.take(CollectionsKt.shuffled(RangesKt.until(0, numTypes)), numWanted);
        NBTTagIntArray plotPicksNbt = new NBTTagIntArray(plotPicks);
        nbt.func_74782_a(tagName, (NBTBase)plotPicksNbt);
    }

    @Override
    public int getXWidth() {
        return ModSchematics.INSTANCE.getDESERT_OASIS().getWidth();
    }

    @Override
    public int getZLength() {
        return ModSchematics.INSTANCE.getDESERT_OASIS().getLength();
    }

    public StructureDesertOasis() {
        super("desert_oasis");
    }

    static {
        Companion = new Companion(null);
        VALID_BIOMES = SetsKt.setOf(Biomes.field_76769_d, Biomes.field_185442_R, Biomes.field_76781_i);
    }

    public static final /* synthetic */ Set access$getBiomesInChunk(StructureDesertOasis $this, BiomeProvider biomeProvider, int chunkX, int chunkZ) {
        return $this.getBiomesInChunk(biomeProvider, chunkX, chunkZ);
    }

    public static final /* synthetic */ Set access$getVALID_BIOMES$cp() {
        return VALID_BIOMES;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0015\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Lcom/davidm1a2/afraidofthedark/common/worldGeneration/structure/StructureDesertOasis$PlotType;", "", "baseOffsets", "", "Lnet/minecraft/util/math/BlockPos;", "(Ljava/lang/String;ILjava/util/List;)V", "getBaseOffsets", "()Ljava/util/List;", "Small", "Small90", "Medium", "Medium90", "Large", "afraidofthedark"})
    private static final class PlotType
    extends Enum<PlotType> {
        public static final /* enum */ PlotType Small;
        public static final /* enum */ PlotType Small90;
        public static final /* enum */ PlotType Medium;
        public static final /* enum */ PlotType Medium90;
        public static final /* enum */ PlotType Large;
        private static final /* synthetic */ PlotType[] $VALUES;
        @NotNull
        private final List<BlockPos> baseOffsets;

        static {
            PlotType[] plotTypeArray = new PlotType[5];
            PlotType[] plotTypeArray2 = plotTypeArray;
            plotTypeArray[0] = Small = new PlotType(CollectionsKt.listOf(new BlockPos(154, 19, 141), new BlockPos(93, 20, 161), new BlockPos(132, 21, 78), new BlockPos(43, 21, 99), new BlockPos(35, 21, 136)));
            plotTypeArray[1] = Small90 = new PlotType(CollectionsKt.listOf(new BlockPos(37, 21, 22), new BlockPos(10, 21, 77), new BlockPos(164, 21, 101)));
            plotTypeArray[2] = Medium = new PlotType(CollectionsKt.listOf(new BlockPos(122, 22, 129), new BlockPos(155, 24, 74), new BlockPos(84, 25, 119)));
            plotTypeArray[3] = Medium90 = new PlotType(CollectionsKt.listOf(new BlockPos(113, 19, 61), new BlockPos(45, 22, 42), new BlockPos(76, 26, 57)));
            plotTypeArray[4] = Large = new PlotType(CollectionsKt.listOf(new BlockPos(132, 22, 31)));
            $VALUES = plotTypeArray;
        }

        @NotNull
        public final List<BlockPos> getBaseOffsets() {
            return this.baseOffsets;
        }

        private PlotType(List<? extends BlockPos> baseOffsets) {
            this.baseOffsets = baseOffsets;
        }

        public static PlotType[] values() {
            return (PlotType[])$VALUES.clone();
        }

        public static PlotType valueOf(String string) {
            return Enum.valueOf(PlotType.class, string);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/davidm1a2/afraidofthedark/common/worldGeneration/structure/StructureDesertOasis$Companion;", "", "()V", "NBT_LARGE_PLOT_INDICES", "", "NBT_MEDIUM90_PLOT_INDICES", "NBT_MEDIUM_PLOT_INDICES", "NBT_SMALL90_PLOT_INDICES", "NBT_SMALL_PLOT_INDICES", "VALID_BIOMES", "", "Lnet/minecraft/world/biome/Biome;", "kotlin.jvm.PlatformType", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

