/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.worldGeneration.schematic;

import com.davidm1a2.afraidofthedark.common.worldGeneration.LootTable;
import com.davidm1a2.afraidofthedark.common.worldGeneration.WorldGenFast;
import com.davidm1a2.afraidofthedark.common.worldGeneration.schematic.Schematic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J*\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J6\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014J4\u0010\u0015\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/davidm1a2/afraidofthedark/common/worldGeneration/schematic/SchematicGenerator;", "", "()V", "PHASE_2_BLOCKS", "", "Lnet/minecraft/block/Block;", "kotlin.jvm.PlatformType", "generateBlocks", "", "schematic", "Lcom/davidm1a2/afraidofthedark/common/worldGeneration/schematic/Schematic;", "world", "Lnet/minecraft/world/World;", "blockPos", "Lnet/minecraft/util/math/BlockPos;", "chunkPos", "Lnet/minecraft/util/math/ChunkPos;", "generateEntities", "generateSchematic", "lootTable", "Lcom/davidm1a2/afraidofthedark/common/worldGeneration/LootTable;", "generateTileEntities", "isInsideChunk", "", "x", "", "z", "afraidofthedark"})
public final class SchematicGenerator {
    private static final Set<Block> PHASE_2_BLOCKS;
    public static final SchematicGenerator INSTANCE;

    public final void generateSchematic(@NotNull Schematic schematic, @NotNull World world, @NotNull BlockPos blockPos, @Nullable ChunkPos chunkPos, @Nullable LootTable lootTable) {
        Intrinsics.checkParameterIsNotNull(schematic, "schematic");
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(blockPos, "blockPos");
        if (!world.field_72995_K) {
            this.generateBlocks(schematic, world, blockPos, chunkPos);
            this.generateTileEntities(schematic, world, blockPos, chunkPos, lootTable);
            this.generateEntities(schematic, world, blockPos, chunkPos);
        }
    }

    public static /* synthetic */ void generateSchematic$default(SchematicGenerator schematicGenerator, Schematic schematic, World world, BlockPos blockPos, ChunkPos chunkPos, LootTable lootTable, int n, Object object) {
        if ((n & 8) != 0) {
            chunkPos = null;
        }
        if ((n & 0x10) != 0) {
            lootTable = null;
        }
        schematicGenerator.generateSchematic(schematic, world, blockPos, chunkPos, lootTable);
    }

    /*
     * WARNING - void declaration
     */
    private final void generateBlocks(Schematic schematic, World world, BlockPos blockPos, ChunkPos chunkPos) {
        int y;
        int posX = blockPos.func_177958_n();
        int posY = blockPos.func_177956_o();
        int posZ = blockPos.func_177952_p();
        Block[] blocks = schematic.getBlocks();
        int[] data = schematic.getData();
        short width = schematic.getWidth();
        short height = schematic.getHeight();
        short length = schematic.getLength();
        int endY = posY + height;
        int startZ = posZ;
        int endZ = posZ + length;
        int startX = posX;
        int endX = posX + width;
        if (chunkPos != null) {
            startZ = RangesKt.coerceIn(startZ, chunkPos.func_180333_d(), chunkPos.func_180330_f() + 1);
            endZ = RangesKt.coerceIn(endZ, chunkPos.func_180333_d(), chunkPos.func_180330_f() + 1);
            startX = RangesKt.coerceIn(startX, chunkPos.func_180334_c(), chunkPos.func_180332_e() + 1);
            endX = RangesKt.coerceIn(endX, chunkPos.func_180334_c(), chunkPos.func_180332_e() + 1);
        }
        int setBlockFlags = 18;
        boolean bl = false;
        List phase2Blocks = new ArrayList();
        int n = 0;
        List phase2Positions = new ArrayList();
        n = posY;
        int n2 = endY;
        while (n < n2) {
            void indexY = (y - posY) * length * width;
            int n3 = startZ;
            int n4 = endZ;
            while (n3 < n4) {
                void z;
                void indexZ = (z - posZ) * width;
                int n5 = startX;
                int n6 = endX;
                while (n5 < n6) {
                    void x;
                    void indexX = x - posX;
                    void index = indexY + indexZ + indexX;
                    Block nextToPlace = blocks[index];
                    if (nextToPlace != Blocks.field_150350_a) {
                        BlockPos position = new BlockPos((int)x, y, (int)z);
                        if (Intrinsics.areEqual(nextToPlace, Blocks.field_189881_dj)) {
                            Block block = Blocks.field_150350_a;
                            Intrinsics.checkExpressionValueIsNotNull(block, "Blocks.AIR");
                            IBlockState iBlockState = block.func_176223_P();
                            Intrinsics.checkExpressionValueIsNotNull(iBlockState, "Blocks.AIR.defaultState");
                            WorldGenFast.INSTANCE.setBlockStateFast(world, position, iBlockState, setBlockFlags);
                        } else if (!PHASE_2_BLOCKS.contains(nextToPlace)) {
                            IBlockState blockState;
                            IBlockState iBlockState = blockState = blocks[index].func_176203_a(data[index]);
                            Intrinsics.checkExpressionValueIsNotNull(iBlockState, "blockState");
                            WorldGenFast.INSTANCE.setBlockStateFast(world, position, iBlockState, setBlockFlags);
                        } else {
                            phase2Blocks.add((int)index);
                            phase2Positions.add(position);
                        }
                    }
                    ++x;
                }
                ++z;
            }
            ++y;
        }
        y = 0;
        n2 = ((Collection)phase2Blocks).size();
        while (y < n2) {
            IBlockState blockState;
            void i;
            int index = ((Number)phase2Blocks.get((int)i)).intValue();
            BlockPos position = (BlockPos)phase2Positions.get((int)i);
            IBlockState iBlockState = blockState = blocks[index].func_176203_a(data[index]);
            Intrinsics.checkExpressionValueIsNotNull(iBlockState, "blockState");
            WorldGenFast.INSTANCE.setBlockStateFast(world, position, iBlockState, setBlockFlags);
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void generateTileEntities(Schematic schematic, World world, BlockPos blockPos, ChunkPos chunkPos, LootTable lootTable) {
        NBTTagList tileEntities = schematic.getTileEntities();
        int n = 0;
        int n2 = tileEntities.func_74745_c();
        while (n < n2) {
            void i;
            block5: {
                BlockPos tileEntityPosition;
                TileEntity tileEntity;
                block6: {
                    NBTTagCompound tileEntityCompound = tileEntities.func_150305_b((int)i);
                    tileEntity = TileEntity.func_190200_a((World)world, (NBTTagCompound)tileEntityCompound);
                    if (tileEntity == null) break block5;
                    tileEntityPosition = tileEntity.func_174877_v().func_177971_a((Vec3i)blockPos);
                    if (chunkPos == null) break block6;
                    BlockPos blockPos2 = tileEntityPosition;
                    Intrinsics.checkExpressionValueIsNotNull(blockPos2, "tileEntityPosition");
                    if (!this.isInsideChunk(blockPos2, chunkPos)) break block5;
                }
                world.func_175713_t(tileEntityPosition);
                tileEntity.func_174878_a(tileEntityPosition);
                world.func_175690_a(tileEntityPosition, tileEntity);
                if (tileEntity instanceof TileEntityChest && lootTable != null) {
                    lootTable.generate((TileEntityChest)tileEntity);
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void generateEntities(Schematic schematic, World world, BlockPos blockPos, ChunkPos chunkPos) {
        NBTTagList entities = schematic.getEntities();
        int n = 0;
        int n2 = entities.func_74745_c();
        while (n < n2) {
            void i;
            NBTTagCompound entityCompound = entities.func_150305_b((int)i);
            Entity entity = EntityList.func_75615_a((NBTTagCompound)entityCompound, (World)world);
            if (entity != null) {
                entity.func_184221_a(UUID.randomUUID());
                double newX = entity.field_70165_t + (double)blockPos.func_177958_n();
                double newY = entity.field_70163_u + (double)blockPos.func_177956_o();
                double newZ = entity.field_70161_v + (double)blockPos.func_177952_p();
                if (chunkPos == null || this.isInsideChunk(newX, newZ, chunkPos)) {
                    entity.func_70107_b(newX, newY, newZ);
                    world.func_72838_d(entity);
                }
            }
            ++i;
        }
    }

    private final boolean isInsideChunk(double x, double z, ChunkPos chunkPos) {
        return x >= (double)chunkPos.func_180334_c() && x <= (double)chunkPos.func_180332_e() && z >= (double)chunkPos.func_180333_d() && z <= (double)chunkPos.func_180330_f();
    }

    private final boolean isInsideChunk(BlockPos blockPos, ChunkPos chunkPos) {
        return blockPos.func_177958_n() >= chunkPos.func_180334_c() && blockPos.func_177958_n() <= chunkPos.func_180332_e() && blockPos.func_177952_p() >= chunkPos.func_180333_d() && blockPos.func_177952_p() <= chunkPos.func_180330_f();
    }

    private SchematicGenerator() {
    }

    static {
        SchematicGenerator schematicGenerator;
        INSTANCE = schematicGenerator = new SchematicGenerator();
        PHASE_2_BLOCKS = SetsKt.setOf(Blocks.field_150345_g, Blocks.field_150324_C, Blocks.field_150448_aq, Blocks.field_150408_cc, Blocks.field_150319_E, Blocks.field_150318_D, (Block)Blocks.field_150330_I, (Block)Blocks.field_150329_H, (Block)Blocks.field_150327_N, (Block)Blocks.field_150328_O, (Block)Blocks.field_150338_P, (Block)Blocks.field_150337_Q, Blocks.field_150478_aa, (Block)Blocks.field_150480_ab, (Block)Blocks.field_150488_af, Blocks.field_150464_aj, Blocks.field_150472_an, Blocks.field_150444_as, Blocks.field_150468_ap, Blocks.field_150442_at, Blocks.field_150456_au, (Block)Blocks.field_150454_av, Blocks.field_150452_aw, Blocks.field_150429_aA, Blocks.field_150437_az, Blocks.field_150430_aB, (Block)Blocks.field_150434_aF, (Block)Blocks.field_150436_aH, (Block)Blocks.field_150416_aS, (Block)Blocks.field_150413_aR, Blocks.field_150393_bb, Blocks.field_150394_bc, Blocks.field_150395_bd, Blocks.field_150392_bi, Blocks.field_150388_bm, Blocks.field_150380_bt, Blocks.field_150375_by, (Block)Blocks.field_150479_bC, Blocks.field_150473_bD, Blocks.field_150459_bM, Blocks.field_150469_bN, Blocks.field_150471_bO, Blocks.field_150445_bS, Blocks.field_150443_bT, Blocks.field_150404_cg, (Block)Blocks.field_150398_cm, Blocks.field_180393_cK, Blocks.field_180394_cL, (Block)Blocks.field_180414_ap, (Block)Blocks.field_180412_aq, (Block)Blocks.field_180411_ar, (Block)Blocks.field_180410_as, (Block)Blocks.field_180409_at, Blocks.field_185773_cZ);
    }
}

