/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.worldGeneration.schematic;

import com.davidm1a2.afraidofthedark.AfraidOfTheDark;
import com.davidm1a2.afraidofthedark.common.constants.ModSchematics;
import com.davidm1a2.afraidofthedark.common.worldGeneration.schematic.Schematic;
import com.davidm1a2.afraidofthedark.common.worldGeneration.schematic.SchematicBuilder;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import net.minecraft.block.Block;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0006\u0010\u0007\u001a\u00020\u0004J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0006H\u0002J.\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0006\u00a8\u0006\u0015"}, d2={"Lcom/davidm1a2/afraidofthedark/common/worldGeneration/schematic/SchematicDebugUtils;", "", "()V", "createMetaFor", "", "schematicFile", "Ljava/io/File;", "createSchematicMetaFiles", "generateMcMetaFileForDir", "schematicDir", "setBlock", "schematic", "Lcom/davidm1a2/afraidofthedark/common/worldGeneration/schematic/Schematic;", "x", "", "y", "z", "block", "Lnet/minecraft/block/Block;", "writeToFile", "file", "afraidofthedark"})
public final class SchematicDebugUtils {
    public static final SchematicDebugUtils INSTANCE;

    public final void setBlock(@NotNull Schematic schematic, int x, int y, int z, @NotNull Block block) {
        Intrinsics.checkParameterIsNotNull(schematic, "schematic");
        Intrinsics.checkParameterIsNotNull(block, "block");
        short width = ModSchematics.INSTANCE.getDESERT_OASIS().getWidth();
        short length = ModSchematics.INSTANCE.getDESERT_OASIS().getLength();
        schematic.getBlocks()[x + y * length * width + z * width] = block;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void writeToFile(@NotNull Schematic schematic, @NotNull File file) {
        Intrinsics.checkParameterIsNotNull(schematic, "schematic");
        Intrinsics.checkParameterIsNotNull(file, "file");
        if (file.exists()) {
            AfraidOfTheDark.Companion.getINSTANCE().getLogger().warn("File already exists, returning...");
            return;
        }
        try {
            Object object;
            String it;
            Collection collection;
            void $this$mapTo$iv$iv;
            Block[] blocks;
            file.getParentFile().mkdirs();
            file.createNewFile();
            NBTTagCompound schematicNBT = new NBTTagCompound();
            schematicNBT.func_74777_a("Width", schematic.getWidth());
            schematicNBT.func_74777_a("Height", schematic.getHeight());
            schematicNBT.func_74777_a("Length", schematic.getLength());
            schematicNBT.func_74782_a("TileEntities", (NBTBase)schematic.getTileEntities());
            schematicNBT.func_74782_a("Entities", (NBTBase)schematic.getEntities());
            Ref.IntRef intRef = new Ref.IntRef();
            intRef.element = 0;
            boolean bl = false;
            Map idToBlock = new LinkedHashMap();
            Block[] $this$map$iv = blocks = schematic.getBlocks();
            boolean $i$f$map = false;
            Block[] blockArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            void var13_18 = $this$mapTo$iv$iv;
            int n = ((void)var13_18).length;
            for (int i = 0; i < n; ++i) {
                void lastBlockId;
                void item$iv$iv;
                void var17_23 = item$iv$iv = var13_18[i];
                collection = destination$iv$iv;
                boolean bl2 = false;
                object = (Integer)idToBlock.computeIfAbsent(String.valueOf(it.getRegistryName()), (Function)new Function<String, Integer>(idToBlock, (Ref.IntRef)lastBlockId){
                    final /* synthetic */ Map $idToBlock$inlined;
                    final /* synthetic */ Ref.IntRef $lastBlockId$inlined;
                    {
                        this.$idToBlock$inlined = map2;
                        this.$lastBlockId$inlined = intRef;
                    }

                    public final int apply(@NotNull String it) {
                        Intrinsics.checkParameterIsNotNull(it, "it");
                        int n = this.$lastBlockId$inlined.element;
                        this.$lastBlockId$inlined.element = n + 1;
                        return n;
                    }
                });
                collection.add(object);
            }
            int[] blockIds = CollectionsKt.toIntArray((List)destination$iv$iv);
            schematicNBT.func_74782_a("BlockIds", (NBTBase)new NBTTagIntArray(blockIds));
            Object object2 = new NBTTagList();
            object = "BlockIdNames";
            collection = schematicNBT;
            boolean bl3 = false;
            boolean bl4 = false;
            NBTTagList $this$apply = object2;
            boolean bl5 = false;
            Iterable $this$forEach$iv = idToBlock.keySet();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (String)element$iv;
                boolean bl6 = false;
                $this$apply.func_74742_a((NBTBase)new NBTTagString(it));
            }
            NBTTagList nBTTagList = object2;
            collection.func_74782_a((String)object, (NBTBase)nBTTagList);
            schematicNBT.func_74783_a("Data", schematic.getData());
            object2 = new FileOutputStream(file);
            bl3 = false;
            Throwable throwable = null;
            try {
                FileOutputStream it2 = (FileOutputStream)object2;
                boolean bl7 = false;
                CompressedStreamTools.func_74799_a((NBTTagCompound)schematicNBT, (OutputStream)it2);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, throwable);
            }
        }
        catch (IOException e) {
            AfraidOfTheDark.Companion.getINSTANCE().getLogger().error((Object)e);
        }
    }

    public final void createSchematicMetaFiles() {
        this.generateMcMetaFileForDir(new File("../src/main/resources/assets/afraidofthedark/schematics"));
    }

    private final void generateMcMetaFileForDir(File schematicDir) {
        File[] subfiles = schematicDir.listFiles();
        if (subfiles != null) {
            File it;
            File element$iv$iv;
            int n;
            File[] $this$filterTo$iv$iv;
            Object $this$filter$iv = subfiles;
            boolean $i$f$filter = false;
            File[] fileArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            void var8_10 = $this$filterTo$iv$iv;
            int n2 = ((void)var8_10).length;
            for (n = 0; n < n2; ++n) {
                it = element$iv$iv = var8_10[n];
                boolean bl = false;
                void v0 = it;
                Intrinsics.checkExpressionValueIsNotNull(v0, "it");
                if (!v0.isDirectory()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it2 = (File)element$iv;
                boolean bl = false;
                File file = it2;
                Intrinsics.checkExpressionValueIsNotNull(file, "it");
                INSTANCE.generateMcMetaFileForDir(file);
            }
            $this$filter$iv = subfiles;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            File[] bl = $this$filterTo$iv$iv;
            int n3 = bl.length;
            for (n = 0; n < n3; ++n) {
                it = element$iv$iv = bl[n];
                boolean bl2 = false;
                File file = it;
                Intrinsics.checkExpressionValueIsNotNull(file, "it");
                if (!file.isFile()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object e : $this$filterTo$iv$iv) {
                File it3 = (File)e;
                boolean bl3 = false;
                File file = it3;
                Intrinsics.checkExpressionValueIsNotNull(file, "it");
                String string = file.getName();
                Intrinsics.checkExpressionValueIsNotNull(string, "it.name");
                if (!StringsKt.endsWith$default(string, ".schematic", false, 2, null)) continue;
                destination$iv$iv.add(e);
            }
            $this$forEach$iv = (List)destination$iv$iv;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it4 = (File)element$iv;
                boolean bl4 = false;
                File file = it4;
                Intrinsics.checkExpressionValueIsNotNull(file, "it");
                INSTANCE.createMetaFor(file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void createMetaFor(File schematicFile) {
        File schematicMetaFile = new File(schematicFile.getAbsolutePath() + ".meta");
        if (schematicMetaFile.exists()) {
            schematicMetaFile.delete();
        }
        String string = schematicFile.getAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull(string, "schematicFile.absolutePath");
        String localPath = StringUtils.substringAfter((String)StringsKt.replace$default(string, "\\", "/", false, 4, null), (String)"src/main/resources/assets/afraidofthedark/");
        Schematic schematic = new SchematicBuilder().withFile(new ResourceLocation("afraidofthedark", localPath)).withCacheEnabled(true).build();
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74777_a("width", schematic.getWidth());
        nbt.func_74777_a("height", schematic.getHeight());
        nbt.func_74777_a("length", schematic.getLength());
        try {
            Closeable closeable = new FileOutputStream(schematicMetaFile);
            boolean bl = false;
            Throwable throwable = null;
            try {
                FileOutputStream it = (FileOutputStream)closeable;
                boolean bl2 = false;
                CompressedStreamTools.func_74799_a((NBTTagCompound)nbt, (OutputStream)it);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        catch (IOException e) {
            System.err.println("Could not write schematic .meta file:\n" + ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    private SchematicDebugUtils() {
    }

    static {
        SchematicDebugUtils schematicDebugUtils;
        INSTANCE = schematicDebugUtils = new SchematicDebugUtils();
    }
}

