/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.worldGeneration.schematic;

import com.davidm1a2.afraidofthedark.common.utility.ResourceUtil;
import com.davidm1a2.afraidofthedark.common.worldGeneration.schematic.CachedSchematic;
import com.davidm1a2.afraidofthedark.common.worldGeneration.schematic.OnDemandSchematic;
import com.davidm1a2.afraidofthedark.common.worldGeneration.schematic.Schematic;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\b\u0010\t\u001a\u00020\bH\u0002J\b\u0010\n\u001a\u00020\bH\u0002J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/davidm1a2/afraidofthedark/common/worldGeneration/schematic/SchematicBuilder;", "", "()V", "cacheEnabled", "", "resourceLocation", "Lnet/minecraft/util/ResourceLocation;", "build", "Lcom/davidm1a2/afraidofthedark/common/worldGeneration/schematic/Schematic;", "createCached", "createOnDemand", "withCacheEnabled", "withFile", "afraidofthedark"})
public final class SchematicBuilder {
    private boolean cacheEnabled = true;
    private ResourceLocation resourceLocation;

    @NotNull
    public final SchematicBuilder withCacheEnabled(boolean cacheEnabled) {
        this.cacheEnabled = cacheEnabled;
        return this;
    }

    @NotNull
    public final SchematicBuilder withFile(@NotNull ResourceLocation resourceLocation) {
        Intrinsics.checkParameterIsNotNull(resourceLocation, "resourceLocation");
        this.resourceLocation = resourceLocation;
        return this;
    }

    @NotNull
    public final Schematic build() {
        ResourceLocation resourceLocation = this.resourceLocation;
        boolean bl = false;
        boolean bl2 = false;
        if (resourceLocation == null) {
            boolean bl3 = false;
            String string = "Resource location must be specified!";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return this.cacheEnabled ? this.createCached() : this.createOnDemand();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Schematic createCached() {
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        String string;
        Collection collection;
        NBTBase nBTBase;
        void $this$mapTo$iv$iv3;
        ResourceLocation resourceLocation = this.resourceLocation;
        if (resourceLocation == null) {
            Intrinsics.throwNpe();
        }
        String schematicName = FilenameUtils.getBaseName((String)resourceLocation.func_110623_a());
        ResourceLocation resourceLocation2 = this.resourceLocation;
        if (resourceLocation2 == null) {
            Intrinsics.throwNpe();
        }
        Closeable closeable = ResourceUtil.INSTANCE.getInputStream(resourceLocation2);
        boolean bl = false;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl2 = false;
            it = CompressedStreamTools.func_74796_a((InputStream)it);
        }
        catch (Throwable it) {
            throwable = it;
            throw it;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        InputStream nbtData = it;
        short width = nbtData.func_74765_d("Width");
        short height = nbtData.func_74765_d("Height");
        short length = nbtData.func_74765_d("Length");
        NBTTagList tileEntities = nbtData.func_150295_c("TileEntities", 10);
        NBTTagList entities = nbtData.func_150295_c("Entities", 10);
        int[] data = nbtData.func_74759_k("Data");
        int[] blockIds = nbtData.func_74759_k("BlockIds");
        NBTTagList nBTTagList = nbtData.func_150295_c("BlockIdNames", 8);
        Intrinsics.checkExpressionValueIsNotNull(nBTTagList, "nbtData.getTagList(\"BlockIdNames\", 8)");
        Iterable $this$map$iv = (Iterable)nBTTagList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void it;
            nBTBase = (NBTBase)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl3 = false;
            void v3 = it;
            if (v3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.minecraft.nbt.NBTTagString");
            }
            string = ((NBTTagString)v3).func_150285_a_();
            collection.add(string);
        }
        List blockMapNames = (List)destination$iv$iv;
        Iterable $this$map$iv2 = blockMapNames;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Object destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            String bl3 = (String)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl4 = false;
            if (Block.func_149684_b((String)it) == null) {
                throw (Throwable)new IllegalStateException("Invalid schematic block found: " + (String)it + '}');
            }
            collection.add(string);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Block[] blockArray = thisCollection$iv.toArray(new Block[0]);
        if (blockArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Block[] blockMapBlocks = blockArray;
        Intrinsics.checkExpressionValueIsNotNull(blockIds, "blockIds");
        int[] $this$map$iv3 = blockIds;
        boolean $i$f$map3 = false;
        destination$iv$iv2 = $this$map$iv3;
        Collection destination$iv$iv3 = new ArrayList($this$map$iv3.length);
        boolean $i$f$mapTo3 = false;
        nBTBase = $this$mapTo$iv$iv;
        int n = ((NBTBase)nBTBase).length;
        for (int i = 0; i < n; ++i) {
            void it;
            NBTBase item$iv$iv;
            NBTBase nBTBase2 = item$iv$iv = nBTBase[i];
            collection = destination$iv$iv3;
            boolean bl5 = false;
            string = blockMapBlocks[it];
            collection.add(string);
        }
        Collection $this$toTypedArray$iv2 = (List)destination$iv$iv3;
        boolean $i$f$toTypedArray2 = false;
        Collection thisCollection$iv2 = $this$toTypedArray$iv2;
        Block[] blockArray2 = thisCollection$iv2.toArray(new Block[0]);
        if (blockArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Block[] blocks = blockArray2;
        String string2 = schematicName;
        Intrinsics.checkExpressionValueIsNotNull(string2, "schematicName");
        NBTTagList nBTTagList2 = tileEntities;
        Intrinsics.checkExpressionValueIsNotNull(nBTTagList2, "tileEntities");
        Intrinsics.checkExpressionValueIsNotNull(data, "data");
        NBTTagList nBTTagList3 = entities;
        Intrinsics.checkExpressionValueIsNotNull(nBTTagList3, "entities");
        return new CachedSchematic(string2, nBTTagList2, width, height, length, blocks, data, nBTTagList3);
    }

    private final Schematic createOnDemand() {
        ResourceLocation resourceLocation = this.resourceLocation;
        if (resourceLocation == null) {
            Intrinsics.throwNpe();
        }
        String schematicName = FilenameUtils.getBaseName((String)resourceLocation.func_110623_a());
        ResourceLocation resourceLocation2 = this.resourceLocation;
        if (resourceLocation2 == null) {
            Intrinsics.throwNpe();
        }
        String string = resourceLocation2.func_110624_b();
        StringBuilder stringBuilder = new StringBuilder();
        ResourceLocation resourceLocation3 = this.resourceLocation;
        if (resourceLocation3 == null) {
            Intrinsics.throwNpe();
        }
        ResourceLocation metaLocation = new ResourceLocation(string, stringBuilder.append(resourceLocation3.func_110623_a()).append(".meta").toString());
        InputStream inputStream = ResourceUtil.INSTANCE.getInputStream(metaLocation);
        NBTTagCompound nbtData = CompressedStreamTools.func_74796_a((InputStream)inputStream);
        short width = nbtData.func_74765_d("width");
        short height = nbtData.func_74765_d("height");
        short length = nbtData.func_74765_d("length");
        ResourceLocation resourceLocation4 = this.resourceLocation;
        if (resourceLocation4 == null) {
            Intrinsics.throwNpe();
        }
        String string2 = schematicName;
        Intrinsics.checkExpressionValueIsNotNull(string2, "schematicName");
        return new OnDemandSchematic(resourceLocation4, string2, width, height, length);
    }
}

