/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.worldGeneration;

import com.davidm1a2.afraidofthedark.AfraidOfTheDark;
import com.davidm1a2.afraidofthedark.common.capabilities.world.IHeightmap;
import com.davidm1a2.afraidofthedark.common.capabilities.world.OverworldHeightmap;
import com.davidm1a2.afraidofthedark.common.constants.ModRegistries;
import com.davidm1a2.afraidofthedark.common.worldGeneration.structure.base.Structure;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/davidm1a2/afraidofthedark/common/worldGeneration/WorldHeightMapper;", "", "()V", "chunkPredictionRange", "", "heightMapChunk", "", "world", "Lnet/minecraft/world/World;", "chunkX", "chunkZ", "onChunkPopulated", "event", "Lnet/minecraftforge/event/terraingen/PopulateChunkEvent$Pre;", "afraidofthedark"})
public final class WorldHeightMapper {
    private int chunkPredictionRange = -1;

    @SubscribeEvent(priority=EventPriority.HIGH)
    public final void onChunkPopulated(@NotNull PopulateChunkEvent.Pre event) {
        Intrinsics.checkParameterIsNotNull(event, "event");
        World world = event.getWorld();
        int chunkX = event.getChunkX();
        int chunkZ = event.getChunkZ();
        if (this.chunkPredictionRange == -1) {
            for (Structure structure : ModRegistries.INSTANCE.getSTRUCTURE()) {
                int n;
                int maxXBlocksCovered = structure.getXWidth() + 15;
                int maxZBlocksCovered = structure.getZLength() + 15;
                boolean bl = false;
                int maxBlocksCovered = Math.max(maxXBlocksCovered, maxZBlocksCovered);
                double d = (double)maxBlocksCovered / 16.0;
                boolean bl2 = false;
                int maxChunksCovered = (int)Math.ceil(d);
                int n2 = this.chunkPredictionRange;
                WorldHeightMapper worldHeightMapper = this;
                boolean bl3 = false;
                worldHeightMapper.chunkPredictionRange = n = Math.max(n2, maxChunksCovered);
            }
            if (AfraidOfTheDark.Companion.getINSTANCE().getConfigurationHandler().getDebugMessages()) {
                AfraidOfTheDark.Companion.getINSTANCE().getLogger().debug("Chunk heightmap prediction range set to " + this.chunkPredictionRange);
            }
        }
        World world2 = world;
        Intrinsics.checkExpressionValueIsNotNull(world2, "world");
        this.heightMapChunk(world2, chunkX, chunkZ, this.chunkPredictionRange);
    }

    /*
     * WARNING - void declaration
     */
    private final void heightMapChunk(World world, int chunkX, int chunkZ, int chunkPredictionRange) {
        if (!world.field_72995_K && world instanceof WorldServer) {
            WorldProvider worldProvider = world.field_73011_w;
            Intrinsics.checkExpressionValueIsNotNull(worldProvider, "world.provider");
            if (worldProvider.getDimension() == 0) {
                ChunkProviderServer chunkProvider = ((WorldServer)world).func_72863_F();
                IHeightmap heightmap = OverworldHeightmap.Companion.get(world);
                int n = chunkX - chunkPredictionRange;
                int n2 = chunkX + chunkPredictionRange;
                if (n <= n2) {
                    while (true) {
                        void x;
                        int n3;
                        int n4;
                        if ((n4 = chunkZ - chunkPredictionRange) <= (n3 = chunkZ + chunkPredictionRange)) {
                            while (true) {
                                void z;
                                ChunkPos chunkPos;
                                if (!heightmap.heightKnown(chunkPos = new ChunkPos((int)x, (int)z))) {
                                    Chunk chunk = chunkProvider.field_186029_c.func_185932_a((int)x, (int)z);
                                    int corner1Height = chunk.func_76611_b(0, 0);
                                    int corner2Height = chunk.func_76611_b(15, 0);
                                    int corner3Height = chunk.func_76611_b(0, 15);
                                    int corner4Height = chunk.func_76611_b(15, 15);
                                    int n5 = 0;
                                    n5 = Math.min(corner1Height, corner2Height);
                                    int n6 = 0;
                                    n6 = Math.min(corner3Height, corner4Height);
                                    int n7 = 0;
                                    int minHeight = Math.min(n5, n6);
                                    n6 = 0;
                                    n6 = Math.max(corner1Height, corner2Height);
                                    n7 = 0;
                                    n7 = Math.max(corner3Height, corner4Height);
                                    boolean bl = false;
                                    int maxHeight = Math.max(n6, n7);
                                    heightmap.setHeight(chunkPos, minHeight, maxHeight);
                                }
                                if (z == n3) break;
                                ++z;
                            }
                        }
                        if (x == n2) break;
                        ++x;
                    }
                }
            }
        }
    }
}

