/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.tileEntity;

import com.davidm1a2.afraidofthedark.AfraidOfTheDark;
import com.davidm1a2.afraidofthedark.common.capabilities.CapabilityExtensionsKt;
import com.davidm1a2.afraidofthedark.common.capabilities.player.dimension.IAOTDPlayerVoidChestData;
import com.davidm1a2.afraidofthedark.common.constants.ModBlocks;
import com.davidm1a2.afraidofthedark.common.constants.ModDimensions;
import com.davidm1a2.afraidofthedark.common.dimension.IslandUtility;
import com.davidm1a2.afraidofthedark.common.packets.otherPackets.SyncVoidChest;
import com.davidm1a2.afraidofthedark.common.packets.packetHandler.PacketHandler;
import com.davidm1a2.afraidofthedark.common.tileEntity.core.AOTDTickingTileEntity;
import com.mojang.authlib.GameProfile;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemNameTag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ITeleporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0011J\u0010\u0010\u001c\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0011J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u001aH\u0016J\u0010\u0010!\u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000eR\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/davidm1a2/afraidofthedark/common/tileEntity/TileEntityVoidChest;", "Lcom/davidm1a2/afraidofthedark/common/tileEntity/core/AOTDTickingTileEntity;", "()V", "friends", "", "Ljava/util/UUID;", "indexToGoTo", "", "lastInteraction", "", "<set-?>", "", "lidAngle", "getLidAngle", "()F", "owner", "playerToSend", "Lnet/minecraft/entity/player/EntityPlayer;", "previousLidAngle", "getPreviousLidAngle", "shouldBeOpen", "", "getID", "playerName", "", "interact", "", "entityPlayer", "openChest", "readFromNBT", "compound", "Lnet/minecraft/nbt/NBTTagCompound;", "update", "writeToNBT", "Companion", "afraidofthedark"})
public final class TileEntityVoidChest
extends AOTDTickingTileEntity {
    private float lidAngle;
    private float previousLidAngle;
    private boolean shouldBeOpen;
    private UUID owner;
    private final Set<UUID> friends;
    private int indexToGoTo;
    private EntityPlayer playerToSend;
    private long lastInteraction;
    private static final String NBT_OWNER = "owner";
    private static final String NBT_INDEX_TO_GO_TO = "index_to_go_to";
    private static final String NBT_FRIENDS = "friends";
    private static final int MILLIS_TO_CLOSE_CHEST = 2000;
    private static final double PULL_FORCE = 1.0;
    private static final float OPEN_CLOSE_SPEED = 0.1f;
    private static final double DISTANCE_TO_SEND_PLAYER = 2.0;
    public static final Companion Companion = new Companion(null);

    public final float getLidAngle() {
        return this.lidAngle;
    }

    public final float getPreviousLidAngle() {
        return this.previousLidAngle;
    }

    @Override
    public void func_73660_a() {
        double distanceSqToPlayer;
        super.func_73660_a();
        BlockPos blockPos = this.field_174879_c;
        Intrinsics.checkExpressionValueIsNotNull(blockPos, "pos");
        int x = blockPos.func_177958_n();
        BlockPos blockPos2 = this.field_174879_c;
        Intrinsics.checkExpressionValueIsNotNull(blockPos2, "pos");
        int y = blockPos2.func_177956_o();
        BlockPos blockPos3 = this.field_174879_c;
        Intrinsics.checkExpressionValueIsNotNull(blockPos3, "pos");
        int z = blockPos3.func_177952_p();
        if (this.getTicksExisted() % (long)10 == 0L && System.currentTimeMillis() - this.lastInteraction > (long)2000) {
            this.shouldBeOpen = false;
        }
        this.previousLidAngle = this.lidAngle;
        if (this.shouldBeOpen && this.lidAngle == 0.0f) {
            this.field_145850_b.func_184134_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
        }
        if (this.shouldBeOpen && this.playerToSend != null) {
            Vec3d vec3d = new Vec3d((Vec3i)this.field_174879_c).func_72441_c(0.5, 0.5, 0.5);
            EntityPlayer entityPlayer = this.playerToSend;
            if (entityPlayer == null) {
                Intrinsics.throwNpe();
            }
            double d = entityPlayer.field_70165_t;
            EntityPlayer entityPlayer2 = this.playerToSend;
            if (entityPlayer2 == null) {
                Intrinsics.throwNpe();
            }
            double d2 = entityPlayer2.field_70163_u;
            EntityPlayer entityPlayer3 = this.playerToSend;
            if (entityPlayer3 == null) {
                Intrinsics.throwNpe();
            }
            Vec3d velocity = vec3d.func_178786_a(d, d2, entityPlayer3.field_70161_v).func_72432_b();
            EntityPlayer entityPlayer4 = this.playerToSend;
            if (entityPlayer4 == null) {
                Intrinsics.throwNpe();
            }
            distanceSqToPlayer = entityPlayer4.func_174818_b(this.field_174879_c);
            Vec3d adjustedVelocity = velocity.func_186678_a(RangesKt.coerceIn(1.0 / distanceSqToPlayer, 0.01, 0.25));
            EntityPlayer entityPlayer5 = this.playerToSend;
            if (entityPlayer5 == null) {
                Intrinsics.throwNpe();
            }
            entityPlayer5.func_70024_g(adjustedVelocity.field_72450_a, adjustedVelocity.field_72448_b, adjustedVelocity.field_72449_c);
        }
        if (!this.shouldBeOpen && this.lidAngle > 0.0f || this.shouldBeOpen && this.lidAngle < 1.0f) {
            this.lidAngle = this.shouldBeOpen ? this.lidAngle + 0.1f : this.lidAngle - 0.1f;
            this.lidAngle = RangesKt.coerceIn(this.lidAngle, 0.0f, 1.0f);
            if ((double)this.lidAngle < 0.5 && (double)this.previousLidAngle >= 0.5) {
                this.field_145850_b.func_184134_a((double)x + 0.5, (double)y + 0.5, (double)z + (double)0.5f, SoundEvents.field_187651_T, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                if (this.playerToSend != null) {
                    WorldProvider worldProvider = this.field_145850_b.field_73011_w;
                    Intrinsics.checkExpressionValueIsNotNull(worldProvider, "world.provider");
                    int currentDimensionID = worldProvider.getDimension();
                    if (currentDimensionID == 0) {
                        EntityPlayer entityPlayer = this.playerToSend;
                        if (entityPlayer == null) {
                            Intrinsics.throwNpe();
                        }
                        distanceSqToPlayer = entityPlayer.func_174818_b(this.func_174877_v());
                        boolean bl = false;
                        if (Math.sqrt(distanceSqToPlayer) < 2.0 && !this.field_145850_b.field_72995_K) {
                            EntityPlayer entityPlayer6 = this.playerToSend;
                            if (entityPlayer6 == null) {
                                Intrinsics.throwNpe();
                            }
                            IAOTDPlayerVoidChestData playerVoidChestData = CapabilityExtensionsKt.getVoidChestData(entityPlayer6);
                            EntityPlayer entityPlayer7 = this.playerToSend;
                            if (entityPlayer7 == null) {
                                Intrinsics.throwNpe();
                            }
                            GameProfile gameProfile = entityPlayer7.func_146103_bH();
                            Intrinsics.checkExpressionValueIsNotNull(gameProfile, "playerToSend!!.gameProfile");
                            if (Intrinsics.areEqual(gameProfile.getId(), this.owner)) {
                                playerVoidChestData.setFriendsIndex(-1);
                            } else {
                                playerVoidChestData.setFriendsIndex(this.indexToGoTo);
                            }
                            EntityPlayer entityPlayer8 = this.playerToSend;
                            if (entityPlayer8 == null) {
                                Intrinsics.throwNpe();
                            }
                            entityPlayer8.changeDimension(ModDimensions.INSTANCE.getVOID_CHEST().func_186068_a(), (ITeleporter)ModDimensions.INSTANCE.getNOOP_TELEPORTER());
                        }
                    } else if (!this.field_145850_b.field_72995_K) {
                        EntityPlayer entityPlayer = this.playerToSend;
                        if (entityPlayer == null) {
                            Intrinsics.throwNpe();
                        }
                        entityPlayer.func_145747_a((ITextComponent)new TextComponentTranslation("message.afraidofthedark:void_chest.wrong_dimension", new Object[0]));
                    }
                }
            }
        }
    }

    public final void interact(@NotNull EntityPlayer entityPlayer) {
        Intrinsics.checkParameterIsNotNull(entityPlayer, "entityPlayer");
        if (!this.field_145850_b.field_72995_K) {
            if (this.owner == null) {
                GameProfile gameProfile = entityPlayer.func_146103_bH();
                Intrinsics.checkExpressionValueIsNotNull(gameProfile, "entityPlayer.gameProfile");
                this.owner = gameProfile.getId();
                World world = this.field_145850_b;
                Intrinsics.checkExpressionValueIsNotNull(world, "world");
                MinecraftServer minecraftServer = world.func_73046_m();
                if (minecraftServer == null) {
                    Intrinsics.throwNpe();
                }
                WorldServer worldServer = minecraftServer.func_71218_a(ModDimensions.INSTANCE.getVOID_CHEST().func_186068_a());
                Intrinsics.checkExpressionValueIsNotNull(worldServer, "world.minecraftServer!!.\u2026Dimensions.VOID_CHEST.id)");
                World voidChestWorld = (World)worldServer;
                IAOTDPlayerVoidChestData playerVoidChestData = CapabilityExtensionsKt.getVoidChestData(entityPlayer);
                this.indexToGoTo = IslandUtility.INSTANCE.getOrAssignPlayerPositionalIndex(voidChestWorld, playerVoidChestData);
                Object[] objectArray = new Object[1];
                GameProfile gameProfile2 = entityPlayer.func_146103_bH();
                Intrinsics.checkExpressionValueIsNotNull(gameProfile2, "entityPlayer.gameProfile");
                objectArray[0] = gameProfile2.getName();
                entityPlayer.func_145747_a((ITextComponent)new TextComponentTranslation("message.afraidofthedark:void_chest.owner_set", objectArray));
            } else {
                GameProfile gameProfile = entityPlayer.func_146103_bH();
                Intrinsics.checkExpressionValueIsNotNull(gameProfile, "entityPlayer.gameProfile");
                if (Intrinsics.areEqual(gameProfile.getId(), this.owner)) {
                    ItemStack heldItem;
                    ItemStack itemStack = heldItem = entityPlayer.func_184614_ca();
                    Intrinsics.checkExpressionValueIsNotNull(itemStack, "heldItem");
                    if (itemStack.func_77973_b() instanceof ItemNameTag) {
                        String string = heldItem.func_82833_r();
                        Intrinsics.checkExpressionValueIsNotNull(string, "heldItem.displayName");
                        UUID friendsUUID = this.getID(string);
                        if (friendsUUID != null) {
                            if (!this.friends.contains(friendsUUID)) {
                                this.friends.add(friendsUUID);
                                entityPlayer.func_145747_a((ITextComponent)new TextComponentTranslation("message.afraidofthedark:void_chest.friend_add", new Object[]{heldItem.func_82833_r()}));
                            } else {
                                this.friends.remove(friendsUUID);
                                entityPlayer.func_145747_a((ITextComponent)new TextComponentTranslation("message.afraidofthedark:void_chest.friend_remove", new Object[]{heldItem.func_82833_r()}));
                            }
                        } else {
                            entityPlayer.func_145747_a((ITextComponent)new TextComponentTranslation("message.afraidofthedark:void_chest.invalid_account", new Object[]{heldItem.func_82833_r()}));
                        }
                    } else {
                        this.openChest(entityPlayer);
                        PacketHandler packetHandler = AfraidOfTheDark.Companion.getINSTANCE().getPacketHandler();
                        BlockPos blockPos = this.field_174879_c;
                        Intrinsics.checkExpressionValueIsNotNull(blockPos, "pos");
                        int n = blockPos.func_177958_n();
                        BlockPos blockPos2 = this.field_174879_c;
                        Intrinsics.checkExpressionValueIsNotNull(blockPos2, "pos");
                        int n2 = blockPos2.func_177956_o();
                        BlockPos blockPos3 = this.field_174879_c;
                        Intrinsics.checkExpressionValueIsNotNull(blockPos3, "pos");
                        packetHandler.sendToDimension(new SyncVoidChest(n, n2, blockPos3.func_177952_p(), entityPlayer), 0);
                    }
                } else {
                    GameProfile gameProfile3 = entityPlayer.func_146103_bH();
                    Intrinsics.checkExpressionValueIsNotNull(gameProfile3, "entityPlayer.gameProfile");
                    if (this.friends.contains(gameProfile3.getId())) {
                        ItemStack heldItem;
                        ItemStack itemStack = heldItem = entityPlayer.func_184614_ca();
                        Intrinsics.checkExpressionValueIsNotNull(itemStack, "heldItem");
                        if (itemStack.func_77973_b() instanceof ItemNameTag) {
                            entityPlayer.func_145747_a((ITextComponent)new TextComponentTranslation("message.afraidofthedark:void_chest.no_edit_access", new Object[0]));
                        } else {
                            this.openChest(entityPlayer);
                            PacketHandler packetHandler = AfraidOfTheDark.Companion.getINSTANCE().getPacketHandler();
                            BlockPos blockPos = this.field_174879_c;
                            Intrinsics.checkExpressionValueIsNotNull(blockPos, "pos");
                            int n = blockPos.func_177958_n();
                            BlockPos blockPos4 = this.field_174879_c;
                            Intrinsics.checkExpressionValueIsNotNull(blockPos4, "pos");
                            int n3 = blockPos4.func_177956_o();
                            BlockPos blockPos5 = this.field_174879_c;
                            Intrinsics.checkExpressionValueIsNotNull(blockPos5, "pos");
                            packetHandler.sendToDimension(new SyncVoidChest(n, n3, blockPos5.func_177952_p(), entityPlayer), 0);
                        }
                    } else {
                        entityPlayer.func_145747_a((ITextComponent)new TextComponentTranslation("message.afraidofthedark:void_chest.no_access", new Object[0]));
                    }
                }
            }
        }
    }

    public final void openChest(@Nullable EntityPlayer entityPlayer) {
        this.lastInteraction = System.currentTimeMillis();
        this.shouldBeOpen = true;
        this.playerToSend = entityPlayer;
    }

    private final UUID getID(String playerName) {
        GameProfile gameProfileForUsername;
        World world = this.field_145850_b;
        Intrinsics.checkExpressionValueIsNotNull(world, "world");
        MinecraftServer minecraftServer = world.func_73046_m();
        if (minecraftServer == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull(minecraftServer, "world.minecraftServer!!");
        GameProfile gameProfile = gameProfileForUsername = minecraftServer.func_152358_ax().func_152655_a(playerName);
        return gameProfile != null ? gameProfile.getId() : null;
    }

    @NotNull
    public NBTTagCompound func_189515_b(@NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull(compound, "compound");
        super.func_189515_b(compound);
        if (this.owner != null) {
            UUID uUID = this.owner;
            if (uUID == null) {
                Intrinsics.throwNpe();
            }
            compound.func_186854_a(NBT_OWNER, uUID);
        }
        compound.func_74768_a(NBT_INDEX_TO_GO_TO, this.indexToGoTo);
        NBTTagList friendNBT = new NBTTagList();
        Iterable $this$forEach$iv = this.friends;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UUID it = (UUID)element$iv;
            boolean bl = false;
            friendNBT.func_74742_a((NBTBase)new NBTTagLong(it.getLeastSignificantBits()));
            friendNBT.func_74742_a((NBTBase)new NBTTagLong(it.getMostSignificantBits()));
        }
        compound.func_74782_a(NBT_FRIENDS, (NBTBase)friendNBT);
        return compound;
    }

    public void func_145839_a(@NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull(compound, "compound");
        super.func_145839_a(compound);
        this.owner = compound.func_74764_b("ownerMost") && compound.func_74764_b("ownerLeast") ? compound.func_186857_a(NBT_OWNER) : null;
        this.indexToGoTo = compound.func_74762_e(NBT_INDEX_TO_GO_TO);
        NBTTagList friendIDParts = compound.func_150295_c(NBT_FRIENDS, 4);
        for (int i = 0; i < friendIDParts.func_74745_c(); i += 2) {
            NBTBase friendIDLeast = friendIDParts.func_179238_g(i);
            NBTBase friendIDMost = friendIDParts.func_179238_g(i + 1);
            if (!(friendIDLeast instanceof NBTTagLong) || !(friendIDMost instanceof NBTTagLong)) continue;
            this.friends.add(new UUID(((NBTTagLong)friendIDMost).func_150291_c(), ((NBTTagLong)friendIDLeast).func_150291_c()));
        }
    }

    public TileEntityVoidChest() {
        super(ModBlocks.INSTANCE.getVOID_CHEST());
        Set set;
        TileEntityVoidChest tileEntityVoidChest = this;
        boolean bl = false;
        tileEntityVoidChest.friends = set = (Set)new LinkedHashSet();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/davidm1a2/afraidofthedark/common/tileEntity/TileEntityVoidChest$Companion;", "", "()V", "DISTANCE_TO_SEND_PLAYER", "", "MILLIS_TO_CLOSE_CHEST", "", "NBT_FRIENDS", "", "NBT_INDEX_TO_GO_TO", "NBT_OWNER", "OPEN_CLOSE_SPEED", "", "PULL_FORCE", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

