/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.spell.component.property;

import com.davidm1a2.afraidofthedark.common.spell.component.InvalidValueException;
import com.davidm1a2.afraidofthedark.common.spell.component.SpellComponentInstance;
import com.davidm1a2.afraidofthedark.common.spell.component.property.SpellComponentProperty;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001Bg\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u001c\u0010\u0005\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0006\u0012\u0016\u0010\n\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u000b\u0012\u0006\u0010\f\u001a\u00020\b\u0012\b\u0010\r\u001a\u0004\u0018\u00010\b\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/davidm1a2/afraidofthedark/common/spell/component/property/IntSpellComponentProperty;", "Lcom/davidm1a2/afraidofthedark/common/spell/component/property/SpellComponentProperty;", "name", "", "description", "setter", "Lkotlin/Function2;", "Lcom/davidm1a2/afraidofthedark/common/spell/component/SpellComponentInstance;", "", "", "getter", "Lkotlin/Function1;", "defaultValue", "minValue", "maxValue", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function1;ILjava/lang/Integer;Ljava/lang/Integer;)V", "afraidofthedark"})
public final class IntSpellComponentProperty
extends SpellComponentProperty {
    public IntSpellComponentProperty(final @NotNull String name, @NotNull String description, final @NotNull Function2<? super SpellComponentInstance<?>, ? super Integer, Unit> setter, final @NotNull Function1<? super SpellComponentInstance<?>, Integer> getter, final int defaultValue, final @Nullable Integer minValue, final @Nullable Integer maxValue) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(description, "description");
        Intrinsics.checkParameterIsNotNull(setter, "setter");
        Intrinsics.checkParameterIsNotNull(getter, "getter");
        super(name, description, new Function2<SpellComponentInstance<?>, String, Unit>(){

            @Override
            public final void invoke(@NotNull SpellComponentInstance<?> instance, @NotNull String newValue) {
                Intrinsics.checkParameterIsNotNull(instance, "instance");
                Intrinsics.checkParameterIsNotNull(newValue, "newValue");
                Integer n = StringsKt.toIntOrNull(newValue);
                if (n == null) {
                    throw (Throwable)new InvalidValueException(newValue + " is not a valid integer!");
                }
                int intValue = n;
                if (minValue != null && Intrinsics.compare(intValue, minValue) < 0) {
                    setter.invoke(instance, defaultValue);
                    throw (Throwable)new InvalidValueException(name + " must be larger than or equal to " + minValue);
                }
                if (maxValue != null && Intrinsics.compare(intValue, maxValue) > 0) {
                    setter.invoke(instance, defaultValue);
                    throw (Throwable)new InvalidValueException(name + " must be smaller than than or equal to " + maxValue);
                }
                setter.invoke(instance, intValue);
            }
        }, new Function1<SpellComponentInstance<?>, String>(){

            @Override
            @NotNull
            public final String invoke(@NotNull SpellComponentInstance<?> it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                return String.valueOf(((Number)getter.invoke(it)).intValue());
            }
        }, new Function1<SpellComponentInstance<?>, Unit>(){

            @Override
            public final void invoke(@NotNull SpellComponentInstance<?> it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                setter.invoke(it, defaultValue);
            }
        });
    }
}

