/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.spell.component.deliveryMethod.base;

import com.davidm1a2.afraidofthedark.common.spell.Spell;
import com.davidm1a2.afraidofthedark.common.spell.SpellStage;
import com.davidm1a2.afraidofthedark.common.spell.component.DeliveryTransitionState;
import com.davidm1a2.afraidofthedark.common.spell.component.SpellComponent;
import com.davidm1a2.afraidofthedark.common.spell.component.SpellComponentInstance;
import com.davidm1a2.afraidofthedark.common.spell.component.deliveryMethod.base.ISpellDeliveryEffectApplicator;
import com.davidm1a2.afraidofthedark.common.spell.component.deliveryMethod.base.ISpellDeliveryTransitioner;
import com.davidm1a2.afraidofthedark.common.spell.component.effect.base.SpellEffect;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\nJ\u0016\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0007J\u001e\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u0016H&J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H&J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\tJ\u0016\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00000\u0016H&J\u0016\u0010\u001c\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00000\u0016H&J\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u0000J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H&J\u000e\u0010!\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\"\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/davidm1a2/afraidofthedark/common/spell/component/deliveryMethod/base/SpellDeliveryMethod;", "Lcom/davidm1a2/afraidofthedark/common/spell/component/SpellComponent;", "id", "Lnet/minecraft/util/ResourceLocation;", "(Lnet/minecraft/util/ResourceLocation;)V", "deliveryCustomTransitioners", "", "Lcom/davidm1a2/afraidofthedark/common/spell/component/deliveryMethod/base/ISpellDeliveryTransitioner;", "deliveryEffectCustomApplicators", "Lcom/davidm1a2/afraidofthedark/common/spell/component/effect/base/SpellEffect;", "Lcom/davidm1a2/afraidofthedark/common/spell/component/deliveryMethod/base/ISpellDeliveryEffectApplicator;", "addCustomEffectApplicator", "", "effectEntry", "applicator", "addCustomTransitioner", "previous", "transitioner", "defaultEffectProc", "state", "Lcom/davidm1a2/afraidofthedark/common/spell/component/DeliveryTransitionState;", "effect", "Lcom/davidm1a2/afraidofthedark/common/spell/component/SpellComponentInstance;", "executeDelivery", "getApplicator", "getCost", "", "instance", "getStageCostMultiplier", "getTransitioner", "getUnlocalizedName", "", "performDefaultTransition", "procEffects", "transitionFrom", "afraidofthedark"})
public abstract class SpellDeliveryMethod
extends SpellComponent<SpellDeliveryMethod> {
    private final Map<SpellDeliveryMethod, ISpellDeliveryTransitioner> deliveryCustomTransitioners;
    private final Map<SpellEffect, ISpellDeliveryEffectApplicator> deliveryEffectCustomApplicators;

    public abstract void executeDelivery(@NotNull DeliveryTransitionState var1);

    public final void procEffects(@NotNull DeliveryTransitionState state) {
        Intrinsics.checkParameterIsNotNull(state, "state");
        for (SpellComponentInstance<SpellEffect> effect : state.getCurrentStage().getEffects()) {
            if (effect == null) continue;
            ISpellDeliveryEffectApplicator customApplicator = this.getApplicator(effect.getComponent());
            if (customApplicator != null) {
                boolean customApplicationSuccessful = customApplicator.procEffect(state, effect);
                if (customApplicationSuccessful) continue;
                this.defaultEffectProc(state, effect);
                continue;
            }
            this.defaultEffectProc(state, effect);
        }
    }

    public abstract void defaultEffectProc(@NotNull DeliveryTransitionState var1, @NotNull SpellComponentInstance<SpellEffect> var2);

    public final void transitionFrom(@NotNull DeliveryTransitionState state) {
        Intrinsics.checkParameterIsNotNull(state, "state");
        Spell spell = state.getSpell();
        if (spell.hasStage(state.getStageIndex() + 1)) {
            ISpellDeliveryTransitioner transitioner;
            SpellStage spellStage = spell.getStage(state.getStageIndex() + 1);
            if (spellStage == null) {
                Intrinsics.throwNpe();
            }
            SpellComponentInstance<SpellDeliveryMethod> spellComponentInstance = spellStage.getDeliveryInstance();
            if (spellComponentInstance == null) {
                Intrinsics.throwNpe();
            }
            SpellDeliveryMethod nextDeliveryInstance = spellComponentInstance.getComponent();
            SpellComponentInstance<SpellDeliveryMethod> spellComponentInstance2 = state.getCurrentStage().getDeliveryInstance();
            if (spellComponentInstance2 == null) {
                Intrinsics.throwNpe();
            }
            ISpellDeliveryTransitioner iSpellDeliveryTransitioner = transitioner = nextDeliveryInstance.getTransitioner(spellComponentInstance2.getComponent());
            if (iSpellDeliveryTransitioner != null) {
                iSpellDeliveryTransitioner.transition(state);
            } else {
                this.performDefaultTransition(state);
            }
        }
    }

    public abstract void performDefaultTransition(@NotNull DeliveryTransitionState var1);

    public abstract double getCost(@NotNull SpellComponentInstance<SpellDeliveryMethod> var1);

    public abstract double getStageCostMultiplier(@NotNull SpellComponentInstance<SpellDeliveryMethod> var1);

    @Override
    @NotNull
    public String getUnlocalizedName() {
        return "delivery_method." + String.valueOf(this.getRegistryName()) + ".name";
    }

    public final void addCustomTransitioner(@NotNull SpellDeliveryMethod previous, @NotNull ISpellDeliveryTransitioner transitioner) {
        Intrinsics.checkParameterIsNotNull((Object)previous, "previous");
        Intrinsics.checkParameterIsNotNull(transitioner, "transitioner");
        this.deliveryCustomTransitioners.put(previous, transitioner);
    }

    public final void addCustomEffectApplicator(@NotNull SpellEffect effectEntry, @NotNull ISpellDeliveryEffectApplicator applicator) {
        Intrinsics.checkParameterIsNotNull((Object)effectEntry, "effectEntry");
        Intrinsics.checkParameterIsNotNull(applicator, "applicator");
        this.deliveryEffectCustomApplicators.put(effectEntry, applicator);
    }

    @Nullable
    public final ISpellDeliveryTransitioner getTransitioner(@NotNull SpellDeliveryMethod previous) {
        Intrinsics.checkParameterIsNotNull((Object)previous, "previous");
        return this.deliveryCustomTransitioners.get((Object)previous);
    }

    @Nullable
    public final ISpellDeliveryEffectApplicator getApplicator(@NotNull SpellEffect effectEntry) {
        Intrinsics.checkParameterIsNotNull((Object)effectEntry, "effectEntry");
        return this.deliveryEffectCustomApplicators.get((Object)effectEntry);
    }

    public SpellDeliveryMethod(@NotNull ResourceLocation id) {
        Map map2;
        Intrinsics.checkParameterIsNotNull(id, "id");
        super(id, new ResourceLocation(id.func_110624_b(), "textures/gui/spell_component/delivery_methods/" + id.func_110623_a() + ".png"));
        SpellDeliveryMethod spellDeliveryMethod = this;
        boolean bl = false;
        spellDeliveryMethod.deliveryCustomTransitioners = map2 = (Map)new LinkedHashMap();
        spellDeliveryMethod = this;
        bl = false;
        spellDeliveryMethod.deliveryEffectCustomApplicators = map2 = (Map)new LinkedHashMap();
    }
}

