/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.spell.component.deliveryMethod;

import com.davidm1a2.afraidofthedark.common.capabilities.world.SpellStateData;
import com.davidm1a2.afraidofthedark.common.spell.Spell;
import com.davidm1a2.afraidofthedark.common.spell.SpellStage;
import com.davidm1a2.afraidofthedark.common.spell.component.DeliveryTransitionState;
import com.davidm1a2.afraidofthedark.common.spell.component.DeliveryTransitionStateBuilder;
import com.davidm1a2.afraidofthedark.common.spell.component.SpellComponentInstance;
import com.davidm1a2.afraidofthedark.common.spell.component.deliveryMethod.base.AOTDSpellDeliveryMethod;
import com.davidm1a2.afraidofthedark.common.spell.component.deliveryMethod.base.SpellDeliveryMethod;
import com.davidm1a2.afraidofthedark.common.spell.component.effect.base.SpellEffect;
import com.davidm1a2.afraidofthedark.common.spell.component.property.LongSpellComponentPropertyBuilder;
import com.davidm1a2.afraidofthedark.common.spell.component.property.SpellComponentPropertyFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\bH\u0016J\u0014\u0010\u000f\u001a\u00020\u00102\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\bJ\u0016\u0010\u0011\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\bH\u0016J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/davidm1a2/afraidofthedark/common/spell/component/deliveryMethod/SpellDeliveryMethodDelay;", "Lcom/davidm1a2/afraidofthedark/common/spell/component/deliveryMethod/base/AOTDSpellDeliveryMethod;", "()V", "defaultEffectProc", "", "state", "Lcom/davidm1a2/afraidofthedark/common/spell/component/DeliveryTransitionState;", "effect", "Lcom/davidm1a2/afraidofthedark/common/spell/component/SpellComponentInstance;", "Lcom/davidm1a2/afraidofthedark/common/spell/component/effect/base/SpellEffect;", "executeDelivery", "getCost", "", "instance", "Lcom/davidm1a2/afraidofthedark/common/spell/component/deliveryMethod/base/SpellDeliveryMethod;", "getDelay", "", "getStageCostMultiplier", "performDefaultTransition", "Companion", "afraidofthedark"})
public final class SpellDeliveryMethodDelay
extends AOTDSpellDeliveryMethod {
    private static final String NBT_DELAY = "delay";
    public static final Companion Companion = new Companion(null);

    @Override
    public void executeDelivery(@NotNull DeliveryTransitionState state) {
        Intrinsics.checkParameterIsNotNull(state, "state");
        SpellStateData spellStateData = SpellStateData.Companion.get((World)state.getWorld());
        spellStateData.addDelayedDelivery(state);
    }

    @Override
    public void defaultEffectProc(@NotNull DeliveryTransitionState state, @NotNull SpellComponentInstance<SpellEffect> effect) {
        Intrinsics.checkParameterIsNotNull(state, "state");
        Intrinsics.checkParameterIsNotNull(effect, "effect");
        effect.getComponent().procEffect(state, effect);
    }

    @Override
    public void performDefaultTransition(@NotNull DeliveryTransitionState state) {
        Intrinsics.checkParameterIsNotNull(state, "state");
        Spell spell = state.getSpell();
        int spellIndex = state.getStageIndex();
        SpellStage spellStage = spell.getStage(spellIndex + 1);
        if (spellStage == null) {
            Intrinsics.throwNpe();
        }
        SpellComponentInstance<SpellDeliveryMethod> spellComponentInstance = spellStage.getDeliveryInstance();
        if (spellComponentInstance == null) {
            Intrinsics.throwNpe();
        }
        spellComponentInstance.getComponent().executeDelivery(new DeliveryTransitionStateBuilder().copyOf(state).withStageIndex(spellIndex + 1).withDeliveryEntity(null).build());
    }

    @Override
    public double getCost(@NotNull SpellComponentInstance<SpellDeliveryMethod> instance) {
        Intrinsics.checkParameterIsNotNull(instance, "instance");
        return (double)10 + (double)this.getDelay(instance) / 10.0;
    }

    @Override
    public double getStageCostMultiplier(@NotNull SpellComponentInstance<SpellDeliveryMethod> instance) {
        Intrinsics.checkParameterIsNotNull(instance, "instance");
        return 1.0;
    }

    public final long getDelay(@NotNull SpellComponentInstance<SpellDeliveryMethod> instance) {
        Intrinsics.checkParameterIsNotNull(instance, "instance");
        return instance.getData().func_74763_f(NBT_DELAY);
    }

    public SpellDeliveryMethodDelay() {
        super(new ResourceLocation("afraidofthedark", NBT_DELAY));
        this.addEditableProperty(((LongSpellComponentPropertyBuilder)((LongSpellComponentPropertyBuilder)((LongSpellComponentPropertyBuilder)((LongSpellComponentPropertyBuilder)((LongSpellComponentPropertyBuilder)((LongSpellComponentPropertyBuilder)SpellComponentPropertyFactory.INSTANCE.longProperty().withName("Delay")).withDescription("The delay of the delivery in ticks (20 ticks = 1 second).")).withSetter(1.INSTANCE)).withGetter(2.INSTANCE)).withDefaultValue(20L)).withMinValue(1L)).build());
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/davidm1a2/afraidofthedark/common/spell/component/deliveryMethod/SpellDeliveryMethodDelay$Companion;", "", "()V", "NBT_DELAY", "", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

