/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.packets.otherPackets;

import com.davidm1a2.afraidofthedark.AfraidOfTheDark;
import com.davidm1a2.afraidofthedark.common.capabilities.CapabilityExtensionsKt;
import com.davidm1a2.afraidofthedark.common.capabilities.player.basics.IAOTDPlayerBasics;
import com.davidm1a2.afraidofthedark.common.constants.ModBlocks;
import com.davidm1a2.afraidofthedark.common.packets.packetHandler.MessageHandler;
import com.davidm1a2.afraidofthedark.common.registry.meteor.MeteorEntry;
import com.mojang.authlib.GameProfile;
import io.netty.buffer.ByteBuf;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\rB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u001f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/davidm1a2/afraidofthedark/common/packets/otherPackets/ProcessSextantInput;", "Lnet/minecraftforge/fml/common/network/simpleimpl/IMessage;", "()V", "dropAngle", "", "latitude", "longitude", "(III)V", "fromBytes", "", "buf", "Lio/netty/buffer/ByteBuf;", "toBytes", "Handler", "afraidofthedark"})
public final class ProcessSextantInput
implements IMessage {
    private int dropAngle;
    private int latitude;
    private int longitude;

    public void fromBytes(@NotNull ByteBuf buf) {
        Intrinsics.checkParameterIsNotNull(buf, "buf");
        this.dropAngle = buf.readInt();
        this.latitude = buf.readInt();
        this.longitude = buf.readInt();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        Intrinsics.checkParameterIsNotNull(buf, "buf");
        buf.writeInt(this.dropAngle);
        buf.writeInt(this.latitude);
        buf.writeInt(this.longitude);
    }

    public ProcessSextantInput() {
        this.dropAngle = -1;
        this.latitude = -1;
        this.longitude = -1;
    }

    public ProcessSextantInput(int dropAngle, int latitude, int longitude) {
        this.dropAngle = dropAngle;
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public static final /* synthetic */ void access$setDropAngle$p(ProcessSextantInput $this, int n) {
        $this.dropAngle = n;
    }

    public static final /* synthetic */ void access$setLatitude$p(ProcessSextantInput $this, int n) {
        $this.latitude = n;
    }

    public static final /* synthetic */ void access$setLongitude$p(ProcessSextantInput $this, int n) {
        $this.longitude = n;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J \u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/davidm1a2/afraidofthedark/common/packets/otherPackets/ProcessSextantInput$Handler;", "Lcom/davidm1a2/afraidofthedark/common/packets/packetHandler/MessageHandler$Server;", "Lcom/davidm1a2/afraidofthedark/common/packets/otherPackets/ProcessSextantInput;", "()V", "dropMeteor", "", "world", "Lnet/minecraft/world/World;", "meteorEntry", "Lcom/davidm1a2/afraidofthedark/common/registry/meteor/MeteorEntry;", "xPos", "", "zPos", "handleServerMessage", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "msg", "ctx", "Lnet/minecraftforge/fml/common/network/simpleimpl/MessageContext;", "Companion", "afraidofthedark"})
    public static final class Handler
    extends MessageHandler.Server<ProcessSextantInput> {
        private static final int MAX_METEOR_DISTANCE = 500;
        private static final Set<Block> INVALID_TOP_BLOCKS;
        private static final Set<Block> REPLACEABLE_BLOCKS;
        public static final Companion Companion;

        @Override
        public void handleServerMessage(@NotNull EntityPlayer player, @NotNull ProcessSextantInput msg, @NotNull MessageContext ctx) {
            Intrinsics.checkParameterIsNotNull(player, "player");
            Intrinsics.checkParameterIsNotNull(msg, "msg");
            Intrinsics.checkParameterIsNotNull(ctx, "ctx");
            IAOTDPlayerBasics playerBasics = CapabilityExtensionsKt.getBasics(player);
            if (playerBasics.getWatchedMeteorDropAngle() == msg.dropAngle && playerBasics.getWatchedMeteorLatitude() == msg.latitude && playerBasics.getWatchedMeteorLongitude() == msg.longitude) {
                MeteorEntry meteorEntry = playerBasics.getWatchedMeteor();
                if (meteorEntry != null) {
                    BlockPos blockPos = player.func_180425_c();
                    Intrinsics.checkExpressionValueIsNotNull(blockPos, "player.position");
                    int xLocOfDrop = blockPos.func_177958_n() + (Random.Default.nextBoolean() ? -1 : 1) * (Random.Default.nextInt(485) + 15);
                    BlockPos blockPos2 = player.func_180425_c();
                    Intrinsics.checkExpressionValueIsNotNull(blockPos2, "player.position");
                    int zLocOfDrop = blockPos2.func_177952_p() + (Random.Default.nextBoolean() ? -1 : 1) * (Random.Default.nextInt(485) + 15);
                    World world = player.field_70170_p;
                    Intrinsics.checkExpressionValueIsNotNull(world, "player.world");
                    this.dropMeteor(world, meteorEntry, xLocOfDrop, zLocOfDrop);
                    int accuracy = playerBasics.getWatchedMeteorAccuracy();
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("message.afraidofthedark:meteor.location", new Object[]{xLocOfDrop += (Random.Default.nextBoolean() ? -1 : 1) * Random.Default.nextInt(accuracy + 1), zLocOfDrop += (Random.Default.nextBoolean() ? -1 : 1) * Random.Default.nextInt(accuracy + 1)}));
                    playerBasics.setWatchedMeteor(null, 0, -1, -1, -1);
                    playerBasics.syncWatchedMeteor(player);
                } else {
                    Logger logger = AfraidOfTheDark.Companion.getINSTANCE().getLogger();
                    StringBuilder stringBuilder = new StringBuilder().append("Player ");
                    GameProfile gameProfile = player.func_146103_bH();
                    Intrinsics.checkExpressionValueIsNotNull(gameProfile, "player.gameProfile");
                    logger.error(stringBuilder.append(gameProfile.getName()).append(" had null meteor entry").toString());
                }
            } else {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("message.afraidofthedark:meteor.process.invalid_vals", new Object[0]));
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void dropMeteor(World world, MeteorEntry meteorEntry, int xPos, int zPos) {
            int yPos = 255;
            IBlockState iBlockState = world.func_180495_p(new BlockPos(xPos, yPos, zPos));
            Intrinsics.checkExpressionValueIsNotNull(iBlockState, "world.getBlockState(BlockPos(xPos, yPos, zPos))");
            Block block = iBlockState.func_177230_c();
            while (yPos > 0 && INVALID_TOP_BLOCKS.contains(block)) {
                IBlockState iBlockState2 = world.func_180495_p(new BlockPos(xPos, --yPos, zPos));
                Intrinsics.checkExpressionValueIsNotNull(iBlockState2, "world.getBlockState(BlockPos(xPos, yPos, zPos))");
                block = iBlockState2.func_177230_c();
            }
            AfraidOfTheDark.Companion.getINSTANCE().getLogger().info("Meteor dropped at " + xPos + ", " + yPos + ", " + zPos);
            if (yPos > 0) {
                int n;
                int radius = Random.Default.nextInt(meteorEntry.getMinMeteorRadius(), meteorEntry.getMaxMeteorRadius() + 1);
                int n2 = xPos - radius;
                if (n2 <= (n = xPos + radius)) {
                    while (true) {
                        void x;
                        int n3 = yPos - radius;
                        int n4 = yPos + radius;
                        while (n3 < n4) {
                            void y;
                            int n5 = zPos - radius;
                            int n6 = zPos + radius;
                            if (n5 <= n6) {
                                while (true) {
                                    void z;
                                    double distanceFromCenter;
                                    if ((distanceFromCenter = (double)((xPos - x) * (xPos - x) + (yPos - y) * (yPos - y)) + (double)((zPos - z) * (zPos - z))) < (double)(radius * radius)) {
                                        BlockPos blockPos = new BlockPos((int)x, (int)y, (int)z);
                                        IBlockState iBlockState3 = world.func_180495_p(blockPos);
                                        Intrinsics.checkExpressionValueIsNotNull(iBlockState3, "world.getBlockState(blockPos)");
                                        Block existingBlock = iBlockState3.func_177230_c();
                                        if (REPLACEABLE_BLOCKS.contains(existingBlock)) {
                                            if (distanceFromCenter >= (double)((radius - 1) * (radius - 1)) || Math.random() > meteorEntry.getRichnessPercent()) {
                                                world.func_175656_a(blockPos, ModBlocks.INSTANCE.getMETEOR().func_176223_P());
                                            } else {
                                                world.func_175656_a(blockPos, meteorEntry.getInteriorBlock().func_176223_P());
                                            }
                                        }
                                    }
                                    if (z == n6) break;
                                    ++z;
                                }
                            }
                            ++y;
                        }
                        if (x != n) {
                            ++x;
                            continue;
                        }
                        break;
                    }
                }
            } else {
                AfraidOfTheDark.Companion.getINSTANCE().getLogger().error("Could not find a suitable y-level for the meteor at " + xPos + ", " + yPos);
            }
        }

        static {
            Companion = new Companion(null);
            INVALID_TOP_BLOCKS = SetsKt.setOf(Blocks.field_150350_a, (Block)Blocks.field_150355_j, (Block)Blocks.field_150358_i, (Block)Blocks.field_150353_l, (Block)Blocks.field_150356_k);
            REPLACEABLE_BLOCKS = SetsKt.setOf(new Block[]{ModBlocks.INSTANCE.getMETEOR(), Blocks.field_150346_d, (Block)Blocks.field_150349_c, (Block)Blocks.field_150362_t, (Block)Blocks.field_150361_u, (Block)Blocks.field_150354_m, Blocks.field_150364_r, Blocks.field_150363_s, Blocks.field_150395_bd, (Block)Blocks.field_150330_I, (Block)Blocks.field_150398_cm, Blocks.field_150432_aD, Blocks.field_150350_a, Blocks.field_150348_b, Blocks.field_150351_n, Blocks.field_150322_A, Blocks.field_150433_aE, Blocks.field_150431_aC, Blocks.field_150405_ch, Blocks.field_150435_aG, (Block)Blocks.field_150355_j, (Block)Blocks.field_150358_i, (Block)Blocks.field_150353_l, (Block)Blocks.field_150356_k, Blocks.field_185774_da});
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/davidm1a2/afraidofthedark/common/packets/otherPackets/ProcessSextantInput$Handler$Companion;", "", "()V", "INVALID_TOP_BLOCKS", "", "Lnet/minecraft/block/Block;", "kotlin.jvm.PlatformType", "MAX_METEOR_DISTANCE", "", "REPLACEABLE_BLOCKS", "afraidofthedark"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

