/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.item.crossbow;

import com.davidm1a2.afraidofthedark.common.constants.ModSounds;
import com.davidm1a2.afraidofthedark.common.entity.bolt.EntityBolt;
import com.davidm1a2.afraidofthedark.common.item.core.AOTDItem;
import com.davidm1a2.afraidofthedark.common.registry.bolt.BoltEntry;
import com.davidm1a2.afraidofthedark.common.utility.BoltOrderHelper;
import com.davidm1a2.afraidofthedark.common.utility.NBTHelper;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 &2\u00020\u0001:\u0001&B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0017J \u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0006H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0006H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0006H\u0002J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0006H\u0002J\u0018\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J&\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u001d2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 H\u0016J \u0010!\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u0015H\u0016J\u0018\u0010$\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010%\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u00a8\u0006'"}, d2={"Lcom/davidm1a2/afraidofthedark/common/item/crossbow/ItemCrossbow;", "Lcom/davidm1a2/afraidofthedark/common/item/core/AOTDItem;", "()V", "addInformation", "", "stack", "Lnet/minecraft/item/ItemStack;", "world", "Lnet/minecraft/world/World;", "tooltip", "", "", "flag", "Lnet/minecraft/client/util/ITooltipFlag;", "fireBolt", "entityPlayer", "Lnet/minecraft/entity/player/EntityPlayer;", "itemStack", "getCurrentBoltType", "Lcom/davidm1a2/afraidofthedark/common/registry/bolt/BoltEntry;", "getCurrentBoltTypeIndex", "", "getMaxItemUseDuration", "isLoaded", "", "onEntitySwing", "entityLiving", "Lnet/minecraft/entity/EntityLivingBase;", "onItemRightClick", "Lnet/minecraft/util/ActionResult;", "player", "hand", "Lnet/minecraft/util/EnumHand;", "onUsingTick", "entity", "count", "selectNextBoltType", "setLoaded", "Companion", "afraidofthedark"})
public final class ItemCrossbow
extends AOTDItem {
    private static final int RELOAD_TIME = 40;
    private static final String NBT_BOLT_TYPE = "bolt_type";
    private static final String NBT_LOADED = "is_loaded";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public ActionResult<ItemStack> func_77659_a(@NotNull World world, @NotNull EntityPlayer player, @NotNull EnumHand hand) {
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(player, "player");
        Intrinsics.checkParameterIsNotNull(hand, "hand");
        ItemStack itemStack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            if (player.func_70093_af()) {
                ItemStack itemStack2 = itemStack;
                Intrinsics.checkExpressionValueIsNotNull(itemStack2, "itemStack");
                this.selectNextBoltType(itemStack2, player);
            } else {
                ItemStack itemStack3 = itemStack;
                Intrinsics.checkExpressionValueIsNotNull(itemStack3, "itemStack");
                if (!this.isLoaded(itemStack3)) {
                    if (player.field_71075_bZ.field_75098_d || player.field_71071_by.func_70431_c(new ItemStack(this.getCurrentBoltType(itemStack).getBoltItem()))) {
                        world.func_184133_a(null, player.func_180425_c(), ModSounds.INSTANCE.getCROSSBOW_LOAD(), SoundCategory.PLAYERS, 0.9f, world.field_73012_v.nextFloat() * 0.8f + 1.2f);
                        player.func_184598_c(hand);
                    } else {
                        player.func_145747_a((ITextComponent)new TextComponentTranslation("message.afraidofthedark:crossbow.no_bolt", new Object[]{new TextComponentTranslation(this.getCurrentBoltType(itemStack).getUnlocalizedName(), new Object[0])}));
                    }
                }
            }
        }
        ActionResult actionResult = ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)itemStack);
        Intrinsics.checkExpressionValueIsNotNull(actionResult, "ActionResult.newResult(E\u2026onResult.FAIL, itemStack)");
        return actionResult;
    }

    public void onUsingTick(@NotNull ItemStack stack, @NotNull EntityLivingBase entity, int count) {
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        Intrinsics.checkParameterIsNotNull(entity, "entity");
        if (entity instanceof EntityPlayer && count == 2 && (((EntityPlayer)entity).field_71075_bZ.field_75098_d || ((EntityPlayer)entity).field_71071_by.func_174925_a(this.getCurrentBoltType(stack).getBoltItem(), -1, 1, null) == 1)) {
            this.setLoaded(stack, true);
        }
    }

    public boolean onEntitySwing(@NotNull EntityLivingBase entityLiving, @NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull(entityLiving, "entityLiving");
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        if (!entityLiving.field_70170_p.field_72995_K && entityLiving instanceof EntityPlayer && this.isLoaded(stack)) {
            this.setLoaded(stack, false);
            EntityPlayer entityPlayer = (EntityPlayer)entityLiving;
            World world = entityLiving.field_70170_p;
            Intrinsics.checkExpressionValueIsNotNull(world, "entityLiving.world");
            this.fireBolt(entityPlayer, world, stack);
        }
        return super.onEntitySwing(entityLiving, stack);
    }

    private final void fireBolt(EntityPlayer entityPlayer, World world, ItemStack itemStack) {
        world.func_184133_a(null, entityPlayer.func_180425_c(), ModSounds.INSTANCE.getCROSSBOW_FIRE(), SoundCategory.PLAYERS, 0.5f, world.field_73012_v.nextFloat() * 0.4f + 0.8f);
        EntityBolt bolt = this.getCurrentBoltType(itemStack).getBoltEntityFactory().invoke(world, entityPlayer);
        bolt.func_184538_a((Entity)entityPlayer, entityPlayer.field_70125_A, entityPlayer.field_70177_z, 0.0f, 3.0f, 0.0f);
        bolt.field_70165_t += bolt.field_70159_w;
        bolt.field_70163_u += bolt.field_70181_x;
        bolt.field_70161_v += bolt.field_70179_y;
        world.func_72838_d((Entity)bolt);
    }

    private final void selectNextBoltType(ItemStack itemStack, EntityPlayer entityPlayer) {
        if (!this.isLoaded(itemStack)) {
            int currentBoltTypeIndex = this.getCurrentBoltTypeIndex(itemStack);
            currentBoltTypeIndex = BoltOrderHelper.INSTANCE.getNextBoltIndex(entityPlayer, currentBoltTypeIndex);
            NBTHelper.INSTANCE.setInteger(itemStack, NBT_BOLT_TYPE, currentBoltTypeIndex);
            if (!entityPlayer.field_70170_p.field_72995_K) {
                entityPlayer.func_145747_a((ITextComponent)new TextComponentTranslation("message.afraidofthedark:crossbow.bolt_change", new Object[]{new TextComponentTranslation(this.getCurrentBoltType(itemStack).getUnlocalizedName(), new Object[0])}));
            }
        }
    }

    private final BoltEntry getCurrentBoltType(ItemStack itemStack) {
        return BoltOrderHelper.INSTANCE.getBoltAt(this.getCurrentBoltTypeIndex(itemStack));
    }

    private final int getCurrentBoltTypeIndex(ItemStack itemStack) {
        if (!NBTHelper.INSTANCE.hasTag(itemStack, NBT_BOLT_TYPE)) {
            NBTHelper.INSTANCE.setInteger(itemStack, NBT_BOLT_TYPE, 0);
        }
        Integer n = NBTHelper.INSTANCE.getInteger(itemStack, NBT_BOLT_TYPE);
        if (n == null) {
            Intrinsics.throwNpe();
        }
        return n;
    }

    private final void setLoaded(ItemStack itemStack, boolean isLoaded) {
        NBTHelper.INSTANCE.setBoolean(itemStack, NBT_LOADED, isLoaded);
    }

    private final boolean isLoaded(ItemStack itemStack) {
        if (!NBTHelper.INSTANCE.hasTag(itemStack, NBT_LOADED)) {
            this.setLoaded(itemStack, false);
        }
        Boolean bl = NBTHelper.INSTANCE.getBoolean(itemStack, NBT_LOADED);
        if (bl == null) {
            Intrinsics.throwNpe();
        }
        return bl;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@NotNull ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, @NotNull ITooltipFlag flag) {
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        Intrinsics.checkParameterIsNotNull(tooltip, "tooltip");
        Intrinsics.checkParameterIsNotNull(flag, "flag");
        String string = I18n.func_135052_a((String)"tooltip.afraidofthedark:crossbow.change_bolt", (Object[])new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull(string, "I18n.format(Localization\u2026SBOW_TOOLTIP_CHANGE_BOLT)");
        tooltip.add(string);
        String string2 = I18n.func_135052_a((String)"tooltip.afraidofthedark:crossbow.fire_bolt_type", (Object[])new Object[]{I18n.func_135052_a((String)this.getCurrentBoltType(stack).getUnlocalizedName(), (Object[])new Object[0])});
        Intrinsics.checkExpressionValueIsNotNull(string2, "I18n.format(Localization\u2026k).getUnlocalizedName()))");
        tooltip.add(string2);
        if (this.isLoaded(stack)) {
            String string3 = I18n.func_135052_a((String)"tooltip.afraidofthedark:crossbow.loaded", (Object[])new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull(string3, "I18n.format(Localization\u2026.CROSSBOW_TOOLTIP_LOADED)");
            tooltip.add(string3);
        } else {
            String string4 = I18n.func_135052_a((String)"tooltip.afraidofthedark:crossbow.unloaded", (Object[])new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull(string4, "I18n.format(Localization\u2026ROSSBOW_TOOLTIP_UNLOADED)");
            tooltip.add(string4);
        }
    }

    public int func_77626_a(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        return 40;
    }

    public ItemCrossbow() {
        super("crossbow", false, 2, null);
        this.func_77625_d(1);
        this.func_185043_a(new ResourceLocation("afraidofthedark", "charge_level"), new IItemPropertyGetter(){

            public final float func_185085_a(@NotNull ItemStack stack, @Nullable World $noName_1, @Nullable EntityLivingBase entity) {
                Intrinsics.checkParameterIsNotNull(stack, "stack");
                if (entity instanceof EntityPlayer && Intrinsics.areEqual((ItemStack)((EntityPlayer)entity).field_71071_by.field_70462_a.get(((EntityPlayer)entity).field_71071_by.field_70461_c), stack)) {
                    return (float)entity.func_184612_cw() / (float)this.func_77626_a(stack);
                }
                return 0.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("afraidofthedark", NBT_LOADED), new IItemPropertyGetter(){

            public final float func_185085_a(@NotNull ItemStack stack, @Nullable World $noName_1, @Nullable EntityLivingBase $noName_2) {
                Intrinsics.checkParameterIsNotNull(stack, "stack");
                return this.isLoaded(stack) ? 1.0f : 0.0f;
            }
        });
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/davidm1a2/afraidofthedark/common/item/crossbow/ItemCrossbow$Companion;", "", "()V", "NBT_BOLT_TYPE", "", "NBT_LOADED", "RELOAD_TIME", "", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

