/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.item;

import com.davidm1a2.afraidofthedark.common.capabilities.CapabilityExtensionsKt;
import com.davidm1a2.afraidofthedark.common.constants.ModResearches;
import com.davidm1a2.afraidofthedark.common.item.core.AOTDItemWithSharedCooldown;
import com.davidm1a2.afraidofthedark.common.utility.NBTHelper;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 %2\u00020\u0001:\u0001%B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0006H\u0016J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006J&\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J(\u0010\u0016\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0004H\u0016J0\u0010\u0019\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\nH\u0016J \u0010\u001e\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u0004H\u0016J\u0018\u0010!\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u0010H\u0002J\u0016\u0010#\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\n\u00a8\u0006&"}, d2={"Lcom/davidm1a2/afraidofthedark/common/item/ItemStarMetalStaff;", "Lcom/davidm1a2/afraidofthedark/common/item/core/AOTDItemWithSharedCooldown;", "()V", "getCooldownInMilliseconds", "", "itemStack", "Lnet/minecraft/item/ItemStack;", "getMaxItemUseDuration", "stack", "isInUse", "", "onItemRightClick", "Lnet/minecraft/util/ActionResult;", "world", "Lnet/minecraft/world/World;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "hand", "Lnet/minecraft/util/EnumHand;", "onItemUseFinish", "entityLiving", "Lnet/minecraft/entity/EntityLivingBase;", "onPlayerStoppedUsing", "", "timeLeft", "onUpdate", "entity", "Lnet/minecraft/entity/Entity;", "itemSlot", "isSelected", "onUsingTick", "entityLivingBase", "count", "performKnockback", "entityPlayer", "setInUse", "inUse", "Companion", "afraidofthedark"})
public final class ItemStarMetalStaff
extends AOTDItemWithSharedCooldown {
    private static final double KNOCKBACK_STRENGTH = 6.0;
    private static final int MAX_TROLL_POLE_TIME_IN_TICKS = 60;
    private static final String NBT_IN_USE = "in_use";
    public static final Companion Companion = new Companion(null);

    public void func_77663_a(@NotNull ItemStack stack, @NotNull World world, @NotNull Entity entity, int itemSlot, boolean isSelected) {
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(entity, "entity");
        if (!world.field_72995_K && entity instanceof EntityPlayer && !isSelected && !((EntityPlayer)entity).field_71075_bZ.field_75098_d && ((EntityPlayer)entity).field_71075_bZ.field_75102_a && this.isInUse(stack)) {
            ((EntityPlayer)entity).field_71075_bZ.field_75102_a = false;
            this.setInUse(stack, false);
        }
    }

    @NotNull
    public ActionResult<ItemStack> func_77659_a(@NotNull World world, @NotNull EntityPlayer player, @NotNull EnumHand hand) {
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(player, "player");
        Intrinsics.checkParameterIsNotNull(hand, "hand");
        if (!world.field_72995_K) {
            if (CapabilityExtensionsKt.getResearch(player).isResearched(ModResearches.INSTANCE.getSTAR_METAL())) {
                ItemStack heldItem;
                ItemStack itemStack = heldItem = player.func_184586_b(hand);
                Intrinsics.checkExpressionValueIsNotNull(itemStack, "heldItem");
                if (!this.isOnCooldown(itemStack)) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.field_71075_bZ.field_75102_a = true;
                    }
                    ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(player.func_145782_y(), 0.0, 0.5, 0.0));
                    this.setOnCooldown(heldItem, player);
                    player.func_184598_c(hand);
                    this.setInUse(heldItem, true);
                    ActionResult actionResult = ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)heldItem);
                    Intrinsics.checkExpressionValueIsNotNull(actionResult, "ActionResult.newResult(E\u2026Result.SUCCESS, heldItem)");
                    return actionResult;
                }
                player.func_145747_a((ITextComponent)new TextComponentTranslation("message.afraidofthedark:star_metal_staff.on_cooldown", new Object[]{this.cooldownRemainingInSeconds(heldItem)}));
            } else {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("message.afraidofthedark:dont_understand", new Object[0]));
            }
        }
        ActionResult actionResult = super.func_77659_a(world, player, hand);
        Intrinsics.checkExpressionValueIsNotNull(actionResult, "super.onItemRightClick(world, player, hand)");
        return actionResult;
    }

    public void onUsingTick(@NotNull ItemStack stack, @NotNull EntityLivingBase entityLivingBase, int count) {
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        Intrinsics.checkParameterIsNotNull(entityLivingBase, "entityLivingBase");
        int count2 = count;
        if (!entityLivingBase.field_70170_p.field_72995_K && entityLivingBase instanceof EntityPlayer) {
            count2 = this.func_77626_a(stack) - count2;
            if (count2 == 1) {
                entityLivingBase.field_70143_R = 0.0f;
            }
            if (count2 >= 5) {
                ((EntityPlayerMP)entityLivingBase).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(entityLivingBase.func_145782_y(), 0.0, 0.0, 0.0));
            }
        }
    }

    @NotNull
    public ItemStack func_77654_b(@NotNull ItemStack stack, @NotNull World world, @NotNull EntityLivingBase entityLiving) {
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(entityLiving, "entityLiving");
        if (!entityLiving.field_70170_p.field_72995_K) {
            this.setInUse(stack, false);
            if (entityLiving instanceof EntityPlayer) {
                if (!((EntityPlayer)entityLiving).field_71075_bZ.field_75098_d) {
                    ((EntityPlayer)entityLiving).field_71075_bZ.field_75102_a = false;
                }
                this.performKnockback(world, (EntityPlayer)entityLiving);
            }
        }
        ItemStack itemStack = super.func_77654_b(stack, world, entityLiving);
        Intrinsics.checkExpressionValueIsNotNull(itemStack, "super.onItemUseFinish(stack, world, entityLiving)");
        return itemStack;
    }

    public void func_77615_a(@NotNull ItemStack stack, @NotNull World world, @NotNull EntityLivingBase entityLiving, int timeLeft) {
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(entityLiving, "entityLiving");
        if (!world.field_72995_K) {
            this.setInUse(stack, false);
            if (entityLiving instanceof EntityPlayer) {
                if (!((EntityPlayer)entityLiving).field_71075_bZ.field_75098_d) {
                    ((EntityPlayer)entityLiving).field_71075_bZ.field_75102_a = false;
                }
                if (timeLeft < 5) {
                    this.performKnockback(world, (EntityPlayer)entityLiving);
                }
            }
        }
    }

    private final void performKnockback(World world, EntityPlayer entityPlayer) {
        List entityList = world.func_72839_b((Entity)entityPlayer, entityPlayer.func_174813_aQ().func_186662_g(10.0));
        for (Entity entity : entityList) {
            if (!(entity instanceof EntityPlayer) && !(entity instanceof EntityLiving)) continue;
            BlockPos blockPos = entityPlayer.func_180425_c();
            Intrinsics.checkExpressionValueIsNotNull(blockPos, "entityPlayer.position");
            double d = blockPos.func_177958_n();
            BlockPos blockPos2 = entity.func_180425_c();
            Intrinsics.checkExpressionValueIsNotNull(blockPos2, "entity.position");
            double motionX = d - (double)blockPos2.func_177958_n();
            BlockPos blockPos3 = entityPlayer.func_180425_c();
            Intrinsics.checkExpressionValueIsNotNull(blockPos3, "entityPlayer.position");
            double d2 = blockPos3.func_177952_p();
            BlockPos blockPos4 = entity.func_180425_c();
            Intrinsics.checkExpressionValueIsNotNull(blockPos4, "entity.position");
            double motionZ = d2 - (double)blockPos4.func_177952_p();
            double d3 = motionX * motionX + motionZ * motionZ;
            boolean bl = false;
            double hypotenuse = Math.sqrt(d3);
            entity.func_70024_g(-motionX * 6.0 * 0.6 / hypotenuse, 0.1, -motionZ * 6.0 * 0.6 / hypotenuse);
        }
    }

    @Override
    public int getCooldownInMilliseconds(@NotNull ItemStack itemStack) {
        Intrinsics.checkParameterIsNotNull(itemStack, "itemStack");
        return 5000;
    }

    public int func_77626_a(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        return 60;
    }

    public final void setInUse(@NotNull ItemStack itemStack, boolean inUse) {
        Intrinsics.checkParameterIsNotNull(itemStack, "itemStack");
        NBTHelper.INSTANCE.setBoolean(itemStack, NBT_IN_USE, inUse);
    }

    public final boolean isInUse(@NotNull ItemStack itemStack) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(itemStack, "itemStack");
        if (NBTHelper.INSTANCE.hasTag(itemStack, NBT_IN_USE)) {
            Boolean bl2 = NBTHelper.INSTANCE.getBoolean(itemStack, NBT_IN_USE);
            if (bl2 == null) {
                Intrinsics.throwNpe();
            }
            bl = bl2;
        } else {
            bl = false;
        }
        return bl;
    }

    public ItemStarMetalStaff() {
        super("star_metal_staff", false, 2, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/davidm1a2/afraidofthedark/common/item/ItemStarMetalStaff$Companion;", "", "()V", "KNOCKBACK_STRENGTH", "", "MAX_TROLL_POLE_TIME_IN_TICKS", "", "NBT_IN_USE", "", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

