/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.item;

import com.davidm1a2.afraidofthedark.common.capabilities.CapabilityExtensionsKt;
import com.davidm1a2.afraidofthedark.common.capabilities.player.research.IAOTDPlayerResearch;
import com.davidm1a2.afraidofthedark.common.constants.ModRegistries;
import com.davidm1a2.afraidofthedark.common.item.core.AOTDItem;
import com.davidm1a2.afraidofthedark.common.registry.research.Research;
import com.davidm1a2.afraidofthedark.common.utility.NBTHelper;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 #2\u00020\u0001:\u0001#B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006J\u000e\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0010\u001a\u00020\u0006J\u001e\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u0018H\u0016J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u0006J&\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u001c2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0016\u0010!\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u0013\u00a8\u0006$"}, d2={"Lcom/davidm1a2/afraidofthedark/common/item/ItemResearchScroll;", "Lcom/davidm1a2/afraidofthedark/common/item/core/AOTDItem;", "()V", "addInformation", "", "stack", "Lnet/minecraft/item/ItemStack;", "world", "Lnet/minecraft/world/World;", "tooltip", "", "", "flag", "Lnet/minecraft/client/util/ITooltipFlag;", "getNumberParts", "", "itemStack", "getPartNumber", "getScrollResearch", "Lcom/davidm1a2/afraidofthedark/common/registry/research/Research;", "getSubItems", "tab", "Lnet/minecraft/creativetab/CreativeTabs;", "items", "Lnet/minecraft/util/NonNullList;", "isPart", "", "onItemRightClick", "Lnet/minecraft/util/ActionResult;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "hand", "Lnet/minecraft/util/EnumHand;", "setScrollResearch", "research", "Companion", "afraidofthedark"})
public final class ItemResearchScroll
extends AOTDItem {
    private static final String NBT_RESEARCH_ID = "research_id";
    private static final String NBT_PART_NUMBER = "part_number";
    private static final String NBT_NUMBER_PARTS = "number_parts";
    public static final Companion Companion = new Companion(null);

    public void func_150895_a(@NotNull CreativeTabs tab, @NotNull NonNullList<ItemStack> items) {
        Intrinsics.checkParameterIsNotNull(tab, "tab");
        Intrinsics.checkParameterIsNotNull(items, "items");
        if (this.func_194125_a(tab)) {
            for (Research research : ModRegistries.INSTANCE.getRESEARCH()) {
                ItemStack itemStack = new ItemStack((Item)this, 1, 0);
                Research research2 = research;
                Intrinsics.checkExpressionValueIsNotNull((Object)research2, "research");
                this.setScrollResearch(itemStack, research2);
                items.add((Object)itemStack);
            }
        }
    }

    @NotNull
    public ActionResult<ItemStack> func_77659_a(@NotNull World world, @NotNull EntityPlayer player, @NotNull EnumHand hand) {
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(player, "player");
        Intrinsics.checkParameterIsNotNull(hand, "hand");
        ItemStack itemStack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            IAOTDPlayerResearch playerResearch = CapabilityExtensionsKt.getResearch(player);
            ItemStack itemStack2 = itemStack;
            Intrinsics.checkExpressionValueIsNotNull(itemStack2, "itemStack");
            Research scrollResearch = this.getScrollResearch(itemStack2);
            if (scrollResearch != null) {
                if (playerResearch.canResearch(scrollResearch)) {
                    if (!this.isPart(itemStack)) {
                        itemStack.func_190918_g(1);
                        playerResearch.setResearch(scrollResearch, true);
                        playerResearch.sync(player, true);
                    } else {
                        player.func_145747_a((ITextComponent)new TextComponentTranslation("message.afraidofthedark:research_scroll.incomplete", new Object[0]));
                    }
                } else if (!playerResearch.isResearched(scrollResearch)) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("message.afraidofthedark:research_scroll.cant_understand", new Object[0]));
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("message.afraidofthedark:research_scroll.already_researched", new Object[0]));
                }
            } else {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("message.afraidofthedark:research_scroll.corrupt", new Object[0]));
            }
        }
        ActionResult actionResult = super.func_77659_a(world, player, hand);
        Intrinsics.checkExpressionValueIsNotNull(actionResult, "super.onItemRightClick(world, player, hand)");
        return actionResult;
    }

    public void func_77624_a(@NotNull ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, @NotNull ITooltipFlag flag) {
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        Intrinsics.checkParameterIsNotNull(tooltip, "tooltip");
        Intrinsics.checkParameterIsNotNull(flag, "flag");
        Research scrollResearch = this.getScrollResearch(stack);
        if (scrollResearch != null) {
            if (this.isPart(stack)) {
                String string = I18n.func_135052_a((String)"tooltip.afraidofthedark:research_scroll.part", (Object[])new Object[]{this.getPartNumber(stack), this.getNumberParts(stack), I18n.func_135052_a((String)scrollResearch.getUnlocalizedName(), (Object[])new Object[0])});
                Intrinsics.checkExpressionValueIsNotNull(string, "I18n.format(\n           \u2026())\n                    )");
                tooltip.add(string);
            } else {
                String string = I18n.func_135052_a((String)"tooltip.afraidofthedark:research_scroll.complete", (Object[])new Object[]{I18n.func_135052_a((String)scrollResearch.getUnlocalizedName(), (Object[])new Object[0])});
                Intrinsics.checkExpressionValueIsNotNull(string, "I18n.format(Localization\u2026ch.getUnlocalizedName()))");
                tooltip.add(string);
            }
        } else {
            String string = I18n.func_135052_a((String)"tooltip.afraidofthedark:research_scroll.corrupt", (Object[])new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull(string, "I18n.format(Localization\u2026H_SCROLL_TOOLTIP_CORRUPT)");
            tooltip.add(string);
        }
    }

    public final void setScrollResearch(@NotNull ItemStack itemStack, @NotNull Research research) {
        Intrinsics.checkParameterIsNotNull(itemStack, "itemStack");
        Intrinsics.checkParameterIsNotNull((Object)research, "research");
        NBTHelper.INSTANCE.setString(itemStack, NBT_RESEARCH_ID, String.valueOf(research.getRegistryName()));
    }

    public final boolean isPart(@NotNull ItemStack itemStack) {
        Intrinsics.checkParameterIsNotNull(itemStack, "itemStack");
        return NBTHelper.INSTANCE.hasTag(itemStack, NBT_NUMBER_PARTS) && NBTHelper.INSTANCE.hasTag(itemStack, NBT_PART_NUMBER);
    }

    public final int getNumberParts(@NotNull ItemStack itemStack) {
        Intrinsics.checkParameterIsNotNull(itemStack, "itemStack");
        Integer n = NBTHelper.INSTANCE.getInteger(itemStack, NBT_NUMBER_PARTS);
        if (n == null) {
            Intrinsics.throwNpe();
        }
        return n;
    }

    public final int getPartNumber(@NotNull ItemStack itemStack) {
        Intrinsics.checkParameterIsNotNull(itemStack, "itemStack");
        Integer n = NBTHelper.INSTANCE.getInteger(itemStack, NBT_PART_NUMBER);
        if (n == null) {
            Intrinsics.throwNpe();
        }
        return n;
    }

    @Nullable
    public final Research getScrollResearch(@NotNull ItemStack itemStack) {
        Research research;
        Intrinsics.checkParameterIsNotNull(itemStack, "itemStack");
        if (NBTHelper.INSTANCE.hasTag(itemStack, NBT_RESEARCH_ID)) {
            IForgeRegistry<Research> iForgeRegistry = ModRegistries.INSTANCE.getRESEARCH();
            String string = NBTHelper.INSTANCE.getString(itemStack, NBT_RESEARCH_ID);
            if (string == null) {
                Intrinsics.throwNpe();
            }
            research = (Research)iForgeRegistry.getValue(new ResourceLocation(string));
        } else {
            research = null;
        }
        return research;
    }

    public ItemResearchScroll() {
        super("research_scroll", false, 2, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/davidm1a2/afraidofthedark/common/item/ItemResearchScroll$Companion;", "", "()V", "NBT_NUMBER_PARTS", "", "NBT_PART_NUMBER", "NBT_RESEARCH_ID", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

