/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.item;

import com.davidm1a2.afraidofthedark.common.capabilities.CapabilityExtensionsKt;
import com.davidm1a2.afraidofthedark.common.constants.ModArmorMaterials;
import com.davidm1a2.afraidofthedark.common.constants.ModResearches;
import com.davidm1a2.afraidofthedark.common.item.core.AOTDItemArmor;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 *2\u00020\u00012\u00020\u0002:\u0001*B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J0\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J0\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0016J \u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0018H\u0016J*\u0010\u001e\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00020\u00062\b\u0010 \u001a\u0004\u0018\u00010\u0004H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u0018H\u0002J0\u0010#\u001a\u00020\"2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020$2\u0006\u0010\u0019\u001a\u00020\u0018H\u0016J\u0010\u0010%\u001a\u00020$2\u0006\u0010\u0019\u001a\u00020\u0018H\u0002J0\u0010&\u001a\u00020'2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020$2\u0006\u0010\u0019\u001a\u00020\u0018H\u0016J \u0010(\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020\u000bH\u0016\u00a8\u0006+"}, d2={"Lcom/davidm1a2/afraidofthedark/common/item/ItemIgneousArmor;", "Lcom/davidm1a2/afraidofthedark/common/item/core/AOTDItemArmor;", "Lnet/minecraftforge/common/ISpecialArmor;", "baseName", "", "equipmentSlot", "Lnet/minecraft/inventory/EntityEquipmentSlot;", "(Ljava/lang/String;Lnet/minecraft/inventory/EntityEquipmentSlot;)V", "addInformation", "", "stack", "Lnet/minecraft/item/ItemStack;", "world", "Lnet/minecraft/world/World;", "tooltip", "", "flag", "Lnet/minecraft/client/util/ITooltipFlag;", "damageArmor", "entity", "Lnet/minecraft/entity/EntityLivingBase;", "source", "Lnet/minecraft/util/DamageSource;", "damage", "", "slot", "getArmorDisplay", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "armor", "getArmorTexture", "Lnet/minecraft/entity/Entity;", "type", "getDefaultProperties", "Lnet/minecraftforge/common/ISpecialArmor$ArmorProperties;", "getProperties", "", "getRatio", "handleUnblockableDamage", "", "onArmorTick", "itemStack", "Companion", "afraidofthedark"})
public final class ItemIgneousArmor
extends AOTDItemArmor
implements ISpecialArmor {
    private static final double KNOCKBACK_STRENGTH = 0.6;
    private static final Set<DamageSource> FIRE_SOURCES;
    private static final Set<DamageSource> TRUE_DAMAGE_SOURCES;
    public static final Companion Companion;

    @NotNull
    public String getArmorTexture(@NotNull ItemStack stack, @NotNull Entity entity, @NotNull EntityEquipmentSlot slot, @Nullable String type) {
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        Intrinsics.checkParameterIsNotNull(entity, "entity");
        Intrinsics.checkParameterIsNotNull(slot, "slot");
        return slot == EntityEquipmentSlot.LEGS ? "afraidofthedark:textures/armor/igneous_2.png" : "afraidofthedark:textures/armor/igneous_1.png";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@NotNull ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, @NotNull ITooltipFlag flag) {
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        Intrinsics.checkParameterIsNotNull(tooltip, "tooltip");
        Intrinsics.checkParameterIsNotNull(flag, "flag");
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && CapabilityExtensionsKt.getResearch((EntityPlayer)player).isResearched(ModResearches.INSTANCE.getIGNEOUS())) {
            String string = I18n.func_135052_a((String)"tooltip.afraidofthedark:magic_armor_never_breaks", (Object[])new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull(string, "I18n.format(Localization\u2026MAGIC_ARMOR_NEVER_BREAKS)");
            tooltip.add(string);
            String string2 = I18n.func_135052_a((String)"tooltip.afraidofthedark:igneous_armor.effect", (Object[])new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull(string2, "I18n.format(Localization\u2026OUS_ARMOR_TOOLTIP_EFFECT)");
            tooltip.add(string2);
        } else {
            String string = I18n.func_135052_a((String)"tooltip.afraidofthedark:dont_know_how_to_use", (Object[])new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull(string, "I18n.format(Localization\u2026TIP_DONT_KNOW_HOW_TO_USE)");
            tooltip.add(string);
        }
    }

    public void onArmorTick(@NotNull World world, @NotNull EntityPlayer player, @NotNull ItemStack itemStack) {
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(player, "player");
        Intrinsics.checkParameterIsNotNull(itemStack, "itemStack");
        super.onArmorTick(world, player, itemStack);
        if (player.func_70027_ad() && CapabilityExtensionsKt.getResearch(player).isResearched(ModResearches.INSTANCE.getIGNEOUS()) && this.isWearingFullArmor(player)) {
            player.func_70066_B();
        }
    }

    public void damageArmor(@NotNull EntityLivingBase entity, @NotNull ItemStack stack, @NotNull DamageSource source, int damage, int slot) {
        Intrinsics.checkParameterIsNotNull(entity, "entity");
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        Intrinsics.checkParameterIsNotNull(source, "source");
    }

    public int getArmorDisplay(@NotNull EntityPlayer player, @NotNull ItemStack armor, int slot) {
        Intrinsics.checkParameterIsNotNull(player, "player");
        Intrinsics.checkParameterIsNotNull(armor, "armor");
        return 0;
    }

    public boolean handleUnblockableDamage(@NotNull EntityLivingBase entity, @NotNull ItemStack armor, @NotNull DamageSource source, double damage, int slot) {
        Intrinsics.checkParameterIsNotNull(entity, "entity");
        Intrinsics.checkParameterIsNotNull(armor, "armor");
        Intrinsics.checkParameterIsNotNull(source, "source");
        return false;
    }

    @NotNull
    public ISpecialArmor.ArmorProperties getProperties(@NotNull EntityLivingBase entity, @NotNull ItemStack armor, @NotNull DamageSource source, double damage, int slot) {
        Intrinsics.checkParameterIsNotNull(entity, "entity");
        Intrinsics.checkParameterIsNotNull(armor, "armor");
        Intrinsics.checkParameterIsNotNull(source, "source");
        if (entity instanceof EntityPlayer) {
            if (CapabilityExtensionsKt.getResearch((EntityPlayer)entity).isResearched(ModResearches.INSTANCE.getIGNEOUS())) {
                Entity damageSourceEntity;
                if (this.isWearingFullArmor((EntityPlayer)entity) && (damageSourceEntity = source.func_76346_g()) != null) {
                    damageSourceEntity.func_70015_d(5);
                    BlockPos blockPos = ((EntityPlayer)entity).func_180425_c();
                    Intrinsics.checkExpressionValueIsNotNull(blockPos, "entity.position");
                    double d = blockPos.func_177958_n();
                    BlockPos blockPos2 = damageSourceEntity.func_180425_c();
                    Intrinsics.checkExpressionValueIsNotNull(blockPos2, "damageSourceEntity.position");
                    double motionX = d - (double)blockPos2.func_177958_n();
                    BlockPos blockPos3 = ((EntityPlayer)entity).func_180425_c();
                    Intrinsics.checkExpressionValueIsNotNull(blockPos3, "entity.position");
                    double d2 = blockPos3.func_177952_p();
                    BlockPos blockPos4 = damageSourceEntity.func_180425_c();
                    Intrinsics.checkExpressionValueIsNotNull(blockPos4, "damageSourceEntity.position");
                    double motionZ = d2 - (double)blockPos4.func_177952_p();
                    double d3 = motionX * motionX + motionZ * motionZ;
                    boolean bl = false;
                    double hypotenuse = Math.sqrt(d3);
                    damageSourceEntity.func_70024_g(-motionX * 0.6 * 0.6 / hypotenuse, 0.1, -motionZ * 0.6 * 0.6 / hypotenuse);
                }
                if (FIRE_SOURCES.contains(source)) {
                    return new ISpecialArmor.ArmorProperties(0, this.getRatio(slot), Integer.MAX_VALUE);
                }
                if (TRUE_DAMAGE_SOURCES.contains(source)) {
                    return new ISpecialArmor.ArmorProperties(0, this.getRatio(slot), 0);
                }
            } else {
                return new ISpecialArmor.ArmorProperties(0, this.getRatio(slot), 0);
            }
        }
        return this.getDefaultProperties(slot);
    }

    private final double getRatio(int slot) {
        double d;
        int totalProtection = 20;
        switch (slot) {
            case 0: 
            case 3: {
                d = 3.0 / (double)totalProtection * this.getPercentOfDamageBlocked();
                break;
            }
            case 1: {
                d = 6.0 / (double)totalProtection * this.getPercentOfDamageBlocked();
                break;
            }
            case 2: {
                d = 8.0 / (double)totalProtection * this.getPercentOfDamageBlocked();
                break;
            }
            default: {
                d = 0.0;
            }
        }
        return d;
    }

    private final ISpecialArmor.ArmorProperties getDefaultProperties(int slot) {
        return new ISpecialArmor.ArmorProperties(0, this.getRatio(slot), this.getMaxDamageBlocked());
    }

    public ItemIgneousArmor(@NotNull String baseName, @NotNull EntityEquipmentSlot equipmentSlot) {
        Intrinsics.checkParameterIsNotNull(baseName, "baseName");
        Intrinsics.checkParameterIsNotNull(equipmentSlot, "equipmentSlot");
        super(baseName, ModArmorMaterials.INSTANCE.getIGNEOUS(), 3, equipmentSlot, false, 16, null);
        this.func_77656_e(0);
        this.setMaxDamageBlocked(20);
        this.setPercentOfDamageBlocked(0.8);
    }

    static {
        Companion = new Companion(null);
        FIRE_SOURCES = SetsKt.setOf(DamageSource.field_76372_a, DamageSource.field_76370_b);
        TRUE_DAMAGE_SOURCES = SetsKt.setOf(DamageSource.field_76369_e, DamageSource.field_76379_h, DamageSource.field_76368_d, DamageSource.field_76380_i, DamageSource.field_76366_f);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/davidm1a2/afraidofthedark/common/item/ItemIgneousArmor$Companion;", "", "()V", "FIRE_SOURCES", "", "Lnet/minecraft/util/DamageSource;", "kotlin.jvm.PlatformType", "KNOCKBACK_STRENGTH", "", "TRUE_DAMAGE_SOURCES", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

