/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.event.register;

import com.davidm1a2.afraidofthedark.common.constants.ModSpellDeliveryMethods;
import com.davidm1a2.afraidofthedark.common.constants.ModSpellEffects;
import com.davidm1a2.afraidofthedark.common.spell.component.DeliveryTransitionState;
import com.davidm1a2.afraidofthedark.common.spell.component.DeliveryTransitionStateBuilder;
import com.davidm1a2.afraidofthedark.common.spell.component.SpellComponentInstance;
import com.davidm1a2.afraidofthedark.common.spell.component.deliveryMethod.SpellDeliveryMethodAOE;
import com.davidm1a2.afraidofthedark.common.spell.component.deliveryMethod.base.ISpellDeliveryEffectApplicator;
import com.davidm1a2.afraidofthedark.common.spell.component.deliveryMethod.base.SpellDeliveryMethod;
import com.davidm1a2.afraidofthedark.common.spell.component.deliveryMethod.helper.TargetType;
import com.davidm1a2.afraidofthedark.common.spell.component.effect.base.AOTDSpellEffect;
import com.davidm1a2.afraidofthedark.common.spell.component.effect.base.SpellEffect;
import com.davidm1a2.afraidofthedark.common.worldGeneration.WorldGenFast;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\b\u0010\u0005\u001a\u00020\u0004H\u0002J\b\u0010\u0006\u001a\u00020\u0004H\u0002J\b\u0010\u0007\u001a\u00020\u0004H\u0002\u00a8\u0006\b"}, d2={"Lcom/davidm1a2/afraidofthedark/common/event/register/SpellEffectOverrideRegister;", "", "()V", "initialize", "", "registerAoeFixes", "registerAoeFreezeFix", "registerAoeTeleportFix", "afraidofthedark"})
public final class SpellEffectOverrideRegister {
    public static final SpellEffectOverrideRegister INSTANCE;

    public final void initialize() {
        this.registerAoeFixes();
        this.registerAoeTeleportFix();
        this.registerAoeFreezeFix();
    }

    private final void registerAoeFixes() {
        ISpellDeliveryEffectApplicator customAOEApplicator2 = new ISpellDeliveryEffectApplicator(){

            public boolean procEffect(@NotNull DeliveryTransitionState state, @NotNull SpellComponentInstance<SpellEffect> effect) {
                SpellComponentInstance<SpellDeliveryMethod> deliveryInstance;
                SpellDeliveryMethod deliveryMethod;
                Intrinsics.checkParameterIsNotNull(state, "state");
                Intrinsics.checkParameterIsNotNull(effect, "effect");
                SpellComponentInstance<SpellDeliveryMethod> spellComponentInstance = state.getCurrentStage().getDeliveryInstance();
                if (spellComponentInstance == null) {
                    Intrinsics.throwNpe();
                }
                if ((deliveryMethod = (deliveryInstance = spellComponentInstance).getComponent()) instanceof SpellDeliveryMethodAOE) {
                    double radius = ((SpellDeliveryMethodAOE)deliveryMethod).getRadius(deliveryInstance);
                    if (((SpellDeliveryMethodAOE)deliveryMethod).getTargetType(deliveryInstance) == TargetType.ENTITY) {
                        return false;
                    }
                    boolean bl = false;
                    double d = Math.sqrt(radius);
                    boolean bl2 = false;
                    int maxExplosions = RangesKt.coerceIn((int)Math.ceil(d), 1, Integer.MAX_VALUE);
                    BlockPos basePos = new BlockPos(state.getPosition());
                    DeliveryTransitionStateBuilder transitionBuilder = new DeliveryTransitionStateBuilder().withSpell(state.getSpell()).withStageIndex(state.getStageIndex()).withWorld((World)state.getWorld()).withCasterEntity(state.getCasterEntity());
                    int explosionCount = 0;
                    while (explosionCount < maxExplosions) {
                        double randomZ;
                        double randomY;
                        double randomX = Random.Default.nextDouble(radius * (double)2) - radius;
                        BlockPos aoePos = basePos.func_177963_a(randomX, randomY = Random.Default.nextDouble(radius * (double)2) - radius, randomZ = Random.Default.nextDouble(radius * (double)2) - radius);
                        if (!(aoePos.func_177951_i((Vec3i)basePos) < radius * radius)) continue;
                        BlockPos blockPos = aoePos;
                        Intrinsics.checkExpressionValueIsNotNull(blockPos, "aoePos");
                        DeliveryTransitionStateBuilder deliveryTransitionStateBuilder = transitionBuilder.withPosition(new Vec3d((double)blockPos.func_177958_n(), (double)aoePos.func_177956_o(), (double)aoePos.func_177952_p())).withBlockPosition(aoePos);
                        Vec3d vec3d = new Vec3d(Math.random() - 0.5, Math.random() - 0.5, Math.random() - 0.5).func_72432_b();
                        Intrinsics.checkExpressionValueIsNotNull(vec3d, "Vec3d(\n                 \u2026            ).normalize()");
                        effect.getComponent().procEffect(deliveryTransitionStateBuilder.withDirection(vec3d).build(), effect);
                        ++explosionCount;
                    }
                }
                return true;
            }
        };
        ModSpellDeliveryMethods.INSTANCE.getAOE().addCustomEffectApplicator(ModSpellEffects.INSTANCE.getEXPLOSION(), customAOEApplicator2);
        ModSpellDeliveryMethods.INSTANCE.getAOE().addCustomEffectApplicator(ModSpellEffects.INSTANCE.getPOTION_EFFECT(), customAOEApplicator2);
    }

    private final void registerAoeTeleportFix() {
        ModSpellDeliveryMethods.INSTANCE.getAOE().addCustomEffectApplicator(ModSpellEffects.INSTANCE.getTELEPORT(), new ISpellDeliveryEffectApplicator(){

            /*
             * WARNING - void declaration
             */
            public boolean procEffect(@NotNull DeliveryTransitionState state, @NotNull SpellComponentInstance<SpellEffect> effect) {
                Intrinsics.checkParameterIsNotNull(state, "state");
                Intrinsics.checkParameterIsNotNull(effect, "effect");
                WorldServer world = state.getWorld();
                Entity spellCaster = state.getCasterEntity();
                if (spellCaster != null) {
                    SpellComponentInstance<SpellDeliveryMethod> spellComponentInstance = state.getCurrentStage().getDeliveryInstance();
                    if (spellComponentInstance == null) {
                        Intrinsics.throwNpe();
                    }
                    SpellComponentInstance<SpellDeliveryMethod> deliveryInstance = spellComponentInstance;
                    SpellDeliveryMethod spellDeliveryMethod = deliveryInstance.getComponent();
                    if (spellDeliveryMethod == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.davidm1a2.afraidofthedark.common.spell.component.deliveryMethod.SpellDeliveryMethodAOE");
                    }
                    double radius = ((SpellDeliveryMethodAOE)spellDeliveryMethod).getRadius(deliveryInstance);
                    Vec3d center = state.getPosition();
                    int n = 0;
                    int n2 = 19;
                    while (n <= n2) {
                        void i;
                        Vec3d teleportPos = center.func_72441_c(Random.Default.nextDouble(radius * (double)2) - radius, Random.Default.nextDouble(radius * (double)2) - radius, Random.Default.nextDouble(radius * (double)2) - radius);
                        BlockPos blockPos = new BlockPos(teleportPos);
                        IBlockState iBlockState = world.func_180495_p(blockPos);
                        Intrinsics.checkExpressionValueIsNotNull(iBlockState, "world.getBlockState(blockPos)");
                        if (Intrinsics.areEqual(iBlockState.func_177230_c(), Blocks.field_150350_a)) {
                            Vec3d vec3d = teleportPos;
                            Intrinsics.checkExpressionValueIsNotNull(vec3d, "teleportPos");
                            AOTDSpellEffect.Companion.createParticlesAt(1, 3, vec3d, spellCaster.field_71093_bK);
                            world.func_184148_a(null, teleportPos.field_72450_a, teleportPos.field_72448_b, teleportPos.field_72449_c, SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 2.5f, 1.0f);
                            spellCaster.func_70634_a(teleportPos.field_72450_a, teleportPos.field_72448_b, teleportPos.field_72449_c);
                            AOTDSpellEffect.Companion.createParticlesAt(1, 3, teleportPos, spellCaster.field_71093_bK);
                            world.func_184148_a(null, teleportPos.field_72450_a, teleportPos.field_72448_b, teleportPos.field_72449_c, SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 2.5f, 1.0f);
                            break;
                        }
                        ++i;
                    }
                }
                return true;
            }
        });
    }

    private final void registerAoeFreezeFix() {
        ModSpellDeliveryMethods.INSTANCE.getAOE().addCustomEffectApplicator(ModSpellEffects.INSTANCE.getFREEZE(), new ISpellDeliveryEffectApplicator(){

            /*
             * WARNING - void declaration
             */
            public boolean procEffect(@NotNull DeliveryTransitionState state, @NotNull SpellComponentInstance<SpellEffect> effect) {
                Intrinsics.checkParameterIsNotNull(state, "state");
                Intrinsics.checkParameterIsNotNull(effect, "effect");
                WorldServer world = state.getWorld();
                Vec3d centerPosition = state.getPosition();
                BlockPos centerBlockPosition = state.getBlockPosition();
                SpellComponentInstance<SpellDeliveryMethod> spellComponentInstance = state.getCurrentStage().getDeliveryInstance();
                if (spellComponentInstance == null) {
                    Intrinsics.throwNpe();
                }
                SpellComponentInstance<SpellDeliveryMethod> deliveryInstance = spellComponentInstance;
                SpellDeliveryMethod spellDeliveryMethod = deliveryInstance.getComponent();
                if (spellDeliveryMethod == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.davidm1a2.afraidofthedark.common.spell.component.deliveryMethod.SpellDeliveryMethodAOE");
                }
                SpellDeliveryMethodAOE deliveryMethodAOE = (SpellDeliveryMethodAOE)spellDeliveryMethod;
                if (deliveryMethodAOE.getTargetType(deliveryInstance) == TargetType.ENTITY) {
                    return false;
                }
                double radius = deliveryMethodAOE.getRadius(deliveryInstance);
                boolean bl = false;
                int blockRadius = (int)Math.ceil(radius);
                double threshhold = 0.5;
                int n = -blockRadius;
                int n2 = blockRadius + 1;
                while (n < n2) {
                    void x;
                    int n3 = -blockRadius;
                    int n4 = blockRadius + 1;
                    while (n3 < n4) {
                        void y;
                        int n5 = -blockRadius;
                        int n6 = blockRadius + 1;
                        while (n5 < n6) {
                            void z;
                            BlockPos blockLocation = centerBlockPosition.func_177982_a((int)x, (int)y, (int)z);
                            Vec3d location = centerPosition.func_72441_c((double)x, (double)y, (double)z);
                            double distance = centerPosition.func_72438_d(location);
                            if (distance < radius + threshhold && distance > radius - threshhold) {
                                IBlockState iBlockState = world.func_180495_p(blockLocation);
                                Intrinsics.checkExpressionValueIsNotNull(iBlockState, "world.getBlockState(blockLocation)");
                                if (iBlockState.func_177230_c() instanceof BlockAir) {
                                    World world2 = (World)world;
                                    BlockPos blockPos = blockLocation;
                                    Intrinsics.checkExpressionValueIsNotNull(blockPos, "blockLocation");
                                    Block block = Blocks.field_150432_aD;
                                    Intrinsics.checkExpressionValueIsNotNull(block, "Blocks.ICE");
                                    IBlockState iBlockState2 = block.func_176223_P();
                                    Intrinsics.checkExpressionValueIsNotNull(iBlockState2, "Blocks.ICE.defaultState");
                                    WorldGenFast.INSTANCE.setBlockStateFast(world2, blockPos, iBlockState2, 18);
                                    Vec3d vec3d = location;
                                    Intrinsics.checkExpressionValueIsNotNull(vec3d, "location");
                                    WorldProvider worldProvider = state.getWorld().field_73011_w;
                                    Intrinsics.checkExpressionValueIsNotNull(worldProvider, "state.world.provider");
                                    AOTDSpellEffect.Companion.createParticlesAt(1, 3, vec3d, worldProvider.getDimension());
                                }
                            }
                            ++z;
                        }
                        ++y;
                    }
                    ++x;
                }
                return true;
            }
        });
    }

    private SpellEffectOverrideRegister() {
    }

    static {
        SpellEffectOverrideRegister spellEffectOverrideRegister;
        INSTANCE = spellEffectOverrideRegister = new SpellEffectOverrideRegister();
    }
}

