/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.capabilities.world;

import com.davidm1a2.afraidofthedark.AfraidOfTheDark;
import com.davidm1a2.afraidofthedark.common.capabilities.world.IStructurePlan;
import com.davidm1a2.afraidofthedark.common.capabilities.world.PlacedStructure;
import com.davidm1a2.afraidofthedark.common.worldGeneration.structure.base.Structure;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001c2\u00020\u00012\u00020\u0002:\u0001\u001cB\u0011\b\u0007\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\bH\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0013H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\bH\u0016J\u0018\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013H\u0016R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/davidm1a2/afraidofthedark/common/capabilities/world/StructurePlan;", "Lnet/minecraft/world/storage/WorldSavedData;", "Lcom/davidm1a2/afraidofthedark/common/capabilities/world/IStructurePlan;", "identifier", "", "(Ljava/lang/String;)V", "chunkToStructure", "", "Lnet/minecraft/util/math/ChunkPos;", "Lcom/davidm1a2/afraidofthedark/common/capabilities/world/PlacedStructure;", "getPlacedStructureAt", "chunkPos", "getPlacedStructures", "", "placeStructure", "", "structure", "Lcom/davidm1a2/afraidofthedark/common/worldGeneration/structure/base/Structure;", "data", "Lnet/minecraft/nbt/NBTTagCompound;", "readFromNBT", "nbt", "structureExistsAt", "", "structureFitsAt", "blockPos", "Lnet/minecraft/util/math/BlockPos;", "writeToNBT", "Companion", "afraidofthedark"})
public final class StructurePlan
extends WorldSavedData
implements IStructurePlan {
    private final Map<ChunkPos, PlacedStructure> chunkToStructure;
    private static final String IDENTIFIER = "afraidofthedark_structure_plan";
    private static final String NBT_CHUNK_MAP = "chunk_map";
    private static final String NBT_STRUCTURE_DATA = "structure_data";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public NBTTagCompound func_189551_b(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkParameterIsNotNull(nbt, "nbt");
        NBTTagCompound chunkMap = new NBTTagCompound();
        Map<ChunkPos, PlacedStructure> $this$forEach$iv = this.chunkToStructure;
        boolean $i$f$forEach = false;
        Map<ChunkPos, PlacedStructure> map2 = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<ChunkPos, PlacedStructure>> iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<ChunkPos, PlacedStructure> element$iv;
            Map.Entry<ChunkPos, PlacedStructure> $dstr$position$structure = element$iv = iterator2.next();
            boolean bl2 = false;
            Map.Entry<ChunkPos, PlacedStructure> entry = $dstr$position$structure;
            boolean bl3 = false;
            ChunkPos position = entry.getKey();
            entry = $dstr$position$structure;
            bl3 = false;
            PlacedStructure structure = entry.getValue();
            chunkMap.func_74782_a("" + position.field_77276_a + ' ' + position.field_77275_b, (NBTBase)new NBTTagString(structure.getUuid().toString()));
        }
        NBTTagList structureData = new NBTTagList();
        Iterable $this$forEach$iv2 = CollectionsKt.distinct((Iterable)this.chunkToStructure.values());
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            PlacedStructure it = (PlacedStructure)element$iv;
            boolean bl4 = false;
            structureData.func_74742_a((NBTBase)it.serializeNBT());
        }
        nbt.func_74782_a(NBT_CHUNK_MAP, (NBTBase)chunkMap);
        nbt.func_74782_a(NBT_STRUCTURE_DATA, (NBTBase)structureData);
        return nbt;
    }

    /*
     * WARNING - void declaration
     */
    public void func_76184_a(@NotNull NBTTagCompound nbt) {
        NBTTagCompound chunkMap;
        Intrinsics.checkParameterIsNotNull(nbt, "nbt");
        NBTTagList structureData = nbt.func_150295_c(NBT_STRUCTURE_DATA, 10);
        int n = 0;
        Map uuidToStructure = new LinkedHashMap();
        n = 0;
        int n2 = structureData.func_74745_c();
        while (n < n2) {
            void i;
            NBTTagCompound nBTTagCompound = structureData.func_150305_b((int)i);
            Intrinsics.checkExpressionValueIsNotNull(nBTTagCompound, "structureData.getCompoundTagAt(i)");
            PlacedStructure placedStructure = new PlacedStructure(nBTTagCompound);
            String string = placedStructure.getUuid().toString();
            Intrinsics.checkExpressionValueIsNotNull(string, "placedStructure.uuid.toString()");
            uuidToStructure.put(string, placedStructure);
            ++i;
        }
        NBTTagCompound nBTTagCompound = chunkMap = nbt.func_74775_l(NBT_CHUNK_MAP);
        Intrinsics.checkExpressionValueIsNotNull(nBTTagCompound, "chunkMap");
        Iterator iterator2 = nBTTagCompound.func_150296_c().iterator();
        while (iterator2.hasNext()) {
            int z;
            String positionKey;
            String string = positionKey = (String)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull(string, "positionKey");
            Integer n3 = StringsKt.toIntOrNull(StringsKt.substringBefore$default(string, " ", null, 2, null));
            int x = n3 != null ? n3 : Integer.MAX_VALUE;
            Integer n4 = StringsKt.toIntOrNull(StringsKt.substringAfter$default(positionKey, " ", null, 2, null));
            int n5 = z = n4 != null ? n4 : Integer.MAX_VALUE;
            if (x != Integer.MAX_VALUE && z != Integer.MAX_VALUE) {
                String structureUUID = chunkMap.func_74779_i(positionKey);
                ChunkPos chunkPos = new ChunkPos(x, z);
                Object v = uuidToStructure.get(structureUUID);
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                this.chunkToStructure.put(chunkPos, (PlacedStructure)v);
                continue;
            }
            AfraidOfTheDark.Companion.getINSTANCE().getLogger().error("Found an invalid key in the world saved data NBT: " + positionKey);
        }
    }

    @Override
    @Nullable
    public PlacedStructure getPlacedStructureAt(@NotNull ChunkPos chunkPos) {
        Intrinsics.checkParameterIsNotNull(chunkPos, "chunkPos");
        Map<ChunkPos, PlacedStructure> map2 = this.chunkToStructure;
        Object v = null;
        boolean bl = false;
        Map<ChunkPos, PlacedStructure> map3 = map2;
        if (map3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, V>");
        }
        return map3.getOrDefault(chunkPos, (PlacedStructure)v);
    }

    @Override
    @NotNull
    public List<PlacedStructure> getPlacedStructures() {
        return CollectionsKt.toList(CollectionsKt.distinct((Iterable)this.chunkToStructure.values()));
    }

    @Override
    public boolean structureExistsAt(@NotNull ChunkPos chunkPos) {
        Intrinsics.checkParameterIsNotNull(chunkPos, "chunkPos");
        return this.chunkToStructure.containsKey(chunkPos);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean structureFitsAt(@NotNull Structure structure, @NotNull BlockPos blockPos) {
        Intrinsics.checkParameterIsNotNull((Object)structure, "structure");
        Intrinsics.checkParameterIsNotNull(blockPos, "blockPos");
        ChunkPos bottomLeftCorner = new ChunkPos(blockPos);
        ChunkPos topRightCorner = new ChunkPos(blockPos.func_177982_a(structure.getXWidth(), 0, structure.getZLength()));
        int n = bottomLeftCorner.field_77276_a;
        int n2 = topRightCorner.field_77276_a;
        if (n <= n2) {
            while (true) {
                void chunkX;
                int n3;
                int n4;
                if ((n4 = bottomLeftCorner.field_77275_b) <= (n3 = topRightCorner.field_77275_b)) {
                    while (true) {
                        void chunkZ;
                        if (this.chunkToStructure.containsKey(new ChunkPos((int)chunkX, (int)chunkZ))) {
                            return false;
                        }
                        if (chunkZ == n3) break;
                        ++chunkZ;
                    }
                }
                if (chunkX == n2) break;
                ++chunkX;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void placeStructure(@NotNull Structure structure, @NotNull NBTTagCompound data) {
        Intrinsics.checkParameterIsNotNull((Object)structure, "structure");
        Intrinsics.checkParameterIsNotNull(data, "data");
        BlockPos blockPos = structure.getPosition(data);
        ChunkPos bottomLeftCorner = new ChunkPos(blockPos);
        ChunkPos topRightCorner = new ChunkPos(blockPos.func_177982_a(structure.getXWidth(), 0, structure.getZLength()));
        PlacedStructure placedStructure = new PlacedStructure(structure, data);
        int n = bottomLeftCorner.field_77276_a;
        int n2 = topRightCorner.field_77276_a;
        if (n <= n2) {
            while (true) {
                void chunkX;
                int n3;
                int n4;
                if ((n4 = bottomLeftCorner.field_77275_b) <= (n3 = topRightCorner.field_77275_b)) {
                    while (true) {
                        void chunkZ;
                        this.chunkToStructure.put(new ChunkPos((int)chunkX, (int)chunkZ), placedStructure);
                        if (chunkZ == n3) break;
                        ++chunkZ;
                    }
                }
                if (chunkX == n2) break;
                ++chunkX;
            }
        }
        this.func_76185_a();
    }

    @JvmOverloads
    public StructurePlan(@NotNull String identifier) {
        Map map2;
        Intrinsics.checkParameterIsNotNull(identifier, "identifier");
        super(identifier);
        StructurePlan structurePlan = this;
        boolean bl = false;
        structurePlan.chunkToStructure = map2 = (Map)new LinkedHashMap();
    }

    public /* synthetic */ StructurePlan(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = IDENTIFIER;
        }
        this(string);
    }

    @JvmOverloads
    public StructurePlan() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/davidm1a2/afraidofthedark/common/capabilities/world/StructurePlan$Companion;", "", "()V", "IDENTIFIER", "", "NBT_CHUNK_MAP", "NBT_STRUCTURE_DATA", "get", "Lcom/davidm1a2/afraidofthedark/common/capabilities/world/IStructurePlan;", "world", "Lnet/minecraft/world/World;", "afraidofthedark"})
    public static final class Companion {
        @Nullable
        public final IStructurePlan get(@NotNull World world) {
            Intrinsics.checkParameterIsNotNull(world, "world");
            if (world.field_72995_K) {
                return null;
            }
            MapStorage storage = world.getPerWorldStorage();
            StructurePlan structurePlan = (StructurePlan)storage.func_75742_a(StructurePlan.class, StructurePlan.IDENTIFIER);
            if (structurePlan == null) {
                structurePlan = new StructurePlan(null, 1, null);
                storage.func_75745_a(StructurePlan.IDENTIFIER, (WorldSavedData)structurePlan);
                structurePlan.func_76185_a();
            }
            return structurePlan;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

