/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.capabilities.world;

import com.davidm1a2.afraidofthedark.AfraidOfTheDark;
import com.davidm1a2.afraidofthedark.common.capabilities.world.IHeightmap;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00182\u00020\u00012\u00020\u0002:\u0001\u0018B\u0011\b\u0007\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\bH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\bH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\bH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0014\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\nH\u0016J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R&\u0010\u0006\u001a\u001a\u0012\u0004\u0012\u00020\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/davidm1a2/afraidofthedark/common/capabilities/world/OverworldHeightmap;", "Lnet/minecraft/world/storage/WorldSavedData;", "Lcom/davidm1a2/afraidofthedark/common/capabilities/world/IHeightmap;", "identifier", "", "(Ljava/lang/String;)V", "posToHeight", "", "Lnet/minecraft/util/math/ChunkPos;", "Lkotlin/Pair;", "", "getHighestHeight", "chunkPos", "getLowestHeight", "heightKnown", "", "readFromNBT", "", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "setHeight", "low", "high", "writeToNBT", "Companion", "afraidofthedark"})
public final class OverworldHeightmap
extends WorldSavedData
implements IHeightmap {
    private final Map<ChunkPos, Pair<Integer, Integer>> posToHeight;
    private static final String IDENTIFIER = "afraidofthedark_overworld_heightmap";
    private static final Pair<Integer, Integer> INVALID;
    public static final Companion Companion;

    public void func_76184_a(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkParameterIsNotNull(nbt, "nbt");
        Iterator iterator2 = nbt.func_150296_c().iterator();
        while (iterator2.hasNext()) {
            String[] positionXZ;
            String positionKey;
            String string = positionKey = (String)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull(string, "positionKey");
            Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)string, new String[]{" "}, false, 0, 6, null);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            if (thisCollection$iv.toArray(new String[0]) == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            if (positionXZ.length == 2) {
                int x = NumberUtils.toInt((String)positionXZ[0], (int)Integer.MAX_VALUE);
                int z = NumberUtils.toInt((String)positionXZ[1], (int)Integer.MAX_VALUE);
                if (x == Integer.MAX_VALUE || z == Integer.MAX_VALUE) continue;
                int[] lowAndHigh = nbt.func_74759_k(positionKey);
                this.posToHeight.put(new ChunkPos(x, z), TuplesKt.to(lowAndHigh[0], lowAndHigh[1]));
                continue;
            }
            AfraidOfTheDark.Companion.getINSTANCE().getLogger().error("Found an invalid key in the world saved data NBT: " + positionKey);
        }
    }

    @NotNull
    public NBTTagCompound func_189551_b(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkParameterIsNotNull(nbt, "nbt");
        Map<ChunkPos, Pair<Integer, Integer>> $this$forEach$iv = this.posToHeight;
        boolean $i$f$forEach = false;
        Map<ChunkPos, Pair<Integer, Integer>> map2 = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<ChunkPos, Pair<Integer, Integer>>> iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<ChunkPos, Pair<Integer, Integer>> element$iv;
            Map.Entry<ChunkPos, Pair<Integer, Integer>> $dstr$position$height = element$iv = iterator2.next();
            boolean bl2 = false;
            Map.Entry<ChunkPos, Pair<Integer, Integer>> entry = $dstr$position$height;
            boolean bl3 = false;
            ChunkPos position = entry.getKey();
            entry = $dstr$position$height;
            bl3 = false;
            Pair<Integer, Integer> height = entry.getValue();
            nbt.func_74783_a("" + position.field_77276_a + ' ' + position.field_77275_b, new int[]{((Number)height.getFirst()).intValue(), ((Number)height.getSecond()).intValue()});
        }
        return nbt;
    }

    @Override
    public boolean heightKnown(@NotNull ChunkPos chunkPos) {
        Intrinsics.checkParameterIsNotNull(chunkPos, "chunkPos");
        return this.posToHeight.containsKey(chunkPos);
    }

    @Override
    public void setHeight(@NotNull ChunkPos chunkPos, int low, int high) {
        Intrinsics.checkParameterIsNotNull(chunkPos, "chunkPos");
        this.posToHeight.put(chunkPos, TuplesKt.to(low, high));
        this.func_76185_a();
    }

    @Override
    public int getLowestHeight(@NotNull ChunkPos chunkPos) {
        Intrinsics.checkParameterIsNotNull(chunkPos, "chunkPos");
        return ((Number)this.posToHeight.getOrDefault(chunkPos, INVALID).getFirst()).intValue();
    }

    @Override
    public int getHighestHeight(@NotNull ChunkPos chunkPos) {
        Intrinsics.checkParameterIsNotNull(chunkPos, "chunkPos");
        return ((Number)this.posToHeight.getOrDefault(chunkPos, INVALID).getSecond()).intValue();
    }

    @JvmOverloads
    public OverworldHeightmap(@NotNull String identifier) {
        Map map2;
        Intrinsics.checkParameterIsNotNull(identifier, "identifier");
        super(identifier);
        OverworldHeightmap overworldHeightmap = this;
        boolean bl = false;
        overworldHeightmap.posToHeight = map2 = (Map)new LinkedHashMap();
    }

    public /* synthetic */ OverworldHeightmap(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = IDENTIFIER;
        }
        this(string);
    }

    @JvmOverloads
    public OverworldHeightmap() {
        this(null, 1, null);
    }

    static {
        Companion = new Companion(null);
        INVALID = TuplesKt.to(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/davidm1a2/afraidofthedark/common/capabilities/world/OverworldHeightmap$Companion;", "", "()V", "IDENTIFIER", "", "INVALID", "Lkotlin/Pair;", "", "get", "Lcom/davidm1a2/afraidofthedark/common/capabilities/world/IHeightmap;", "world", "Lnet/minecraft/world/World;", "afraidofthedark"})
    public static final class Companion {
        @NotNull
        public final IHeightmap get(@NotNull World world) {
            block5: {
                block4: {
                    Intrinsics.checkParameterIsNotNull(world, "world");
                    if (world.field_72995_K) break block4;
                    WorldProvider worldProvider = world.field_73011_w;
                    Intrinsics.checkExpressionValueIsNotNull(worldProvider, "world.provider");
                    if (worldProvider.getDimension() == 0) break block5;
                }
                throw (Throwable)new UnsupportedOperationException("Attempted to get the heightmap client side or for a non-overworld world!");
            }
            MapStorage storage = world.getPerWorldStorage();
            OverworldHeightmap heightmap = (OverworldHeightmap)storage.func_75742_a(OverworldHeightmap.class, OverworldHeightmap.IDENTIFIER);
            if (heightmap == null) {
                heightmap = new OverworldHeightmap(null, 1, null);
                storage.func_75745_a(OverworldHeightmap.IDENTIFIER, (WorldSavedData)heightmap);
                heightmap.func_76185_a();
            }
            return heightmap;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

