/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.network;

import com.yyon.grapplinghook.grapplemod;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class GrappleEndMessage
implements IMessage {
    public int entityid;
    public HashSet<Integer> arrowIds;

    public GrappleEndMessage() {
    }

    public GrappleEndMessage(int entityid, HashSet<Integer> arrowIds) {
        this.entityid = entityid;
        this.arrowIds = arrowIds;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityid = buf.readInt();
        int size = buf.readInt();
        this.arrowIds = new HashSet();
        for (int i = 0; i < size; ++i) {
            this.arrowIds.add(buf.readInt());
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityid);
        buf.writeInt(this.arrowIds.size());
        for (int id : this.arrowIds) {
            buf.writeInt(id);
        }
    }

    public static class Handler
    implements IMessageHandler<GrappleEndMessage, IMessage> {
        public IMessage onMessage(GrappleEndMessage message, MessageContext ctx) {
            WorldServer mainThread = (WorldServer)ctx.getServerHandler().field_147369_b.field_70170_p;
            mainThread.func_152344_a((Runnable)new runner(message, ctx));
            return null;
        }

        public class runner
        implements Runnable {
            GrappleEndMessage message;
            MessageContext ctx;

            public runner(GrappleEndMessage message, MessageContext ctx) {
                this.message = message;
                this.ctx = ctx;
            }

            @Override
            public void run() {
                int id = this.message.entityid;
                World w = this.ctx.getServerHandler().field_147369_b.field_70170_p;
                grapplemod.receiveGrappleEnd(id, w, this.message.arrowIds);
            }
        }
    }
}

