/*
 * Decompiled with CFR 0.152.
 */
package austeretony.rebind.common.util;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class ReBindUtils {
    public static JsonElement getInternalJsonData(String path) throws IOException {
        JsonElement rawData = null;
        try (InputStream inputStream = ReBindUtils.class.getClassLoader().getResourceAsStream(path);){
            rawData = new JsonParser().parse((Reader)new InputStreamReader(inputStream, "UTF-8"));
        }
        return rawData;
    }

    public static JsonElement getExternalJsonData(String path) throws IOException {
        JsonElement rawData = null;
        try (FileInputStream inputStream = new FileInputStream(new File(path));){
            rawData = new JsonParser().parse((Reader)new InputStreamReader((InputStream)inputStream, "UTF-8"));
        }
        return rawData;
    }

    public static void createExternalJsonFile(String path, JsonElement data) throws IOException {
        try (FileWriter writer = new FileWriter(path);){
            new GsonBuilder().setPrettyPrinting().create().toJson(data, (Appendable)writer);
        }
    }

    public static void createAbsoluteJsonCopy(String path, InputStream source) throws IOException {
        List fileData;
        try (InputStream inputStream = source;){
            fileData = IOUtils.readLines((Reader)new InputStreamReader(inputStream, "UTF-8"));
        }
        if (fileData != null) {
            var4_3 = null;
            try (PrintStream printStream = new PrintStream(new File(path));){
                for (String line : fileData) {
                    printStream.println(line);
                }
            }
            catch (Throwable throwable) {
                var4_3 = throwable;
                throw throwable;
            }
        }
    }
}

