/*
 * Decompiled with CFR 0.152.
 */
package austeretony.rebind.common.main;

import austeretony.rebind.common.main.EnumChatMessages;
import austeretony.rebind.common.main.ReBindMain;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class UpdateChecker
implements Runnable {
    private static String availableVersion = "2.7.5:release:0";
    private static boolean notified;

    @SubscribeEvent
    public void onPlayerJoinedWorld(EntityJoinWorldEvent event) {
        if (event.getEntity().field_70170_p.field_72995_K && event.getEntity() instanceof EntityPlayer) {
            if (!notified) {
                notified = true;
                if (UpdateChecker.isOutdated("2.7.5:release:0", availableVersion)) {
                    EnumChatMessages.UPDATE_MESSAGE.showMessage(availableVersion);
                }
            } else {
                MinecraftForge.EVENT_BUS.unregister((Object)this);
            }
        }
    }

    @Override
    public void run() {
        JsonObject data;
        JsonObject remoteData;
        URL versionsURL;
        ReBindMain.LOGGER.info("Update check started...");
        try {
            versionsURL = new URL("https://raw.githubusercontent.com/AustereTony-MCMods/ReBind/info/mod_versions_custom.json");
        }
        catch (MalformedURLException exception) {
            exception.printStackTrace();
            return;
        }
        try (InputStream inputStream = versionsURL.openStream();){
            remoteData = (JsonObject)new JsonParser().parse((Reader)new InputStreamReader(inputStream, "UTF-8"));
        }
        catch (IOException exception) {
            ReBindMain.LOGGER.error("Update check failed!");
            return;
        }
        try {
            data = remoteData.get("1.12.2").getAsJsonObject();
        }
        catch (NullPointerException exception) {
            ReBindMain.LOGGER.error("Update check failed, data is undefined for 1.12.2 version.");
            return;
        }
        availableVersion = data.get("available").getAsString();
        ReBindMain.LOGGER.info("Update check ended. Current/available: 2.7.5:release:0/" + availableVersion);
    }

    public static boolean isOutdated(String currentVersion, String availableVersion) {
        try {
            String[] cSplitted = currentVersion.split("[:]");
            String[] aSplitted = availableVersion.split("[:]");
            String cVer = cSplitted[0];
            String cType = cSplitted[1];
            String cRev = cSplitted[2];
            String aVer = aSplitted[0];
            String aType = aSplitted[1];
            String aRev = aSplitted[2];
            String[] cVerSplitted = cVer.split("[.]");
            String[] aVerSplitted = aVer.split("[.]");
            for (int i = 0; i < 3; ++i) {
                int verDiff = Integer.parseInt(aVerSplitted[i]) - Integer.parseInt(cVerSplitted[i]);
                if (verDiff > 0) {
                    return true;
                }
                if (verDiff >= 0) continue;
                return false;
            }
            if (aType.equals("release") && (cType.equals("beta") || cType.equals("alpha"))) {
                return true;
            }
            if (aType.equals("beta") && cType.equals("alpha")) {
                return true;
            }
            int revDiff = Integer.parseInt(aRev) - Integer.parseInt(cRev);
            if (revDiff > 0) {
                return true;
            }
            if (revDiff < 0) {
                return false;
            }
            return false;
        }
        catch (Exception exception) {
            ReBindMain.LOGGER.error("Versions comparison failed!");
            exception.printStackTrace();
            return false;
        }
    }
}

