/*
 * Decompiled with CFR 0.152.
 */
package austeretony.rebind.common.main;

import austeretony.rebind.client.keybinding.KeyBindingWrapper;
import austeretony.rebind.client.reference.ClientReference;
import austeretony.rebind.common.command.EnumCommandReBindArgs;
import com.google.common.collect.LinkedHashMultimap;
import java.util.TreeSet;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;

public enum EnumChatMessages {
    UPDATE_MESSAGE,
    COMMAND_REBIND_HELP,
    COMMAND_REBIND_LIST,
    COMMAND_REBIND_UPDATE,
    COMMAND_REBIND_ERR_NO_UNKNOWN_KEY_BINDINGS,
    COMMAND_REBIND_ERR_EXTERNAL_CONFIG_DISABLED;

    public static final ITextComponent PREFIX;

    private static ITextComponent prefix() {
        return PREFIX.func_150259_f();
    }

    private String formatVersion(String input) {
        try {
            String[] splitted = input.split("[:]");
            return splitted[0] + " " + splitted[1] + " r-" + splitted[2];
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return input;
        }
    }

    public void showMessage(String ... args) {
        switch (this) {
            case UPDATE_MESSAGE: {
                TextComponentTranslation msg1 = new TextComponentTranslation("rebind.update.newVersion", new Object[0]);
                TextComponentString msg2 = new TextComponentString(" " + this.formatVersion("2.7.5:release:0") + " / " + this.formatVersion(args[0]));
                ClientReference.showChatMessageClient(EnumChatMessages.prefix().func_150257_a((ITextComponent)msg1).func_150257_a((ITextComponent)msg2));
                msg1 = new TextComponentTranslation("rebind.update.projectPage", new Object[0]);
                msg2 = new TextComponentString(": ");
                TextComponentString msg3 = new TextComponentString("minecraft.curseforge.com");
                msg1.func_150256_b().func_150238_a(TextFormatting.AQUA);
                msg3.func_150256_b().func_150238_a(TextFormatting.WHITE);
                msg3.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://minecraft.curseforge.com/projects/rebind"));
                ClientReference.showChatMessageClient(msg1.func_150257_a((ITextComponent)msg2).func_150257_a((ITextComponent)msg3));
                break;
            }
            case COMMAND_REBIND_HELP: {
                ClientReference.showChatMessageClient(EnumChatMessages.prefix().func_150257_a((ITextComponent)new TextComponentTranslation("rebind.command.help.title", new Object[0])));
                for (EnumCommandReBindArgs arg : EnumCommandReBindArgs.values()) {
                    if (arg == EnumCommandReBindArgs.HELP) continue;
                    TextComponentString msg1 = new TextComponentString("/rebind " + (Object)((Object)arg));
                    TextComponentString msg2 = new TextComponentString(" - ");
                    msg1.func_150256_b().func_150238_a(TextFormatting.GREEN);
                    msg2.func_150256_b().func_150238_a(TextFormatting.WHITE);
                    ClientReference.showChatMessageClient(msg1.func_150257_a(msg2.func_150257_a((ITextComponent)new TextComponentTranslation("rebind.command.help." + (Object)((Object)arg), new Object[0]))));
                }
                break;
            }
            case COMMAND_REBIND_LIST: {
                LinkedHashMultimap propsByModnames = LinkedHashMultimap.create();
                TreeSet<String> sortedModNames = new TreeSet<String>();
                for (KeyBindingWrapper property : KeyBindingWrapper.UNKNOWN) {
                    propsByModnames.put((Object)property.getModName(), (Object)property);
                    sortedModNames.add(property.getModName());
                }
                ClientReference.showChatMessageClient(EnumChatMessages.prefix().func_150257_a((ITextComponent)new TextComponentTranslation("rebind.command.list", new Object[0])));
                for (String modNameStr : sortedModNames) {
                    for (KeyBindingWrapper property : propsByModnames.get((Object)modNameStr)) {
                        TextComponentString modNameLog = new TextComponentString("M: ");
                        modNameLog.func_150256_b().func_150238_a(TextFormatting.AQUA);
                        TextComponentString modName = new TextComponentString(property.getModName());
                        modName.func_150256_b().func_150238_a(TextFormatting.WHITE);
                        TextComponentString nameLog = new TextComponentString(", N: ");
                        nameLog.func_150256_b().func_150238_a(TextFormatting.AQUA);
                        TextComponentString name = new TextComponentString(I18n.func_135052_a((String)property.getKeyBinding().func_151464_g(), (Object[])new Object[0]));
                        name.func_150256_b().func_150238_a(TextFormatting.WHITE);
                        TextComponentString codeLog = new TextComponentString(", K: ");
                        TextComponentString code = new TextComponentString(GameSettings.func_74298_c((int)property.getKeyBinding().func_151463_i()));
                        code.func_150256_b().func_150238_a(TextFormatting.WHITE);
                        ClientReference.showChatMessageClient(modNameLog.func_150257_a((ITextComponent)modName).func_150257_a((ITextComponent)nameLog).func_150257_a((ITextComponent)name).func_150257_a((ITextComponent)codeLog).func_150257_a((ITextComponent)code));
                    }
                    ClientReference.showChatMessageClient((ITextComponent)new TextComponentString(""));
                }
                break;
            }
            case COMMAND_REBIND_UPDATE: {
                TextComponentTranslation msg1 = new TextComponentTranslation("rebind.command.update", new Object[0]);
                msg1.func_150256_b().func_150238_a(TextFormatting.GREEN);
                ClientReference.showChatMessageClient(EnumChatMessages.prefix().func_150257_a((ITextComponent)msg1));
                break;
            }
            case COMMAND_REBIND_ERR_NO_UNKNOWN_KEY_BINDINGS: {
                TextComponentTranslation msg1 = new TextComponentTranslation("rebind.command.err.noUnknownKeys", new Object[0]);
                msg1.func_150256_b().func_150238_a(TextFormatting.RED);
                ClientReference.showChatMessageClient(EnumChatMessages.prefix().func_150257_a((ITextComponent)msg1));
                break;
            }
            case COMMAND_REBIND_ERR_EXTERNAL_CONFIG_DISABLED: {
                TextComponentTranslation msg1 = new TextComponentTranslation("rebind.command.err.externalConfigDisabled", new Object[0]);
                msg1.func_150256_b().func_150238_a(TextFormatting.RED);
                ClientReference.showChatMessageClient(EnumChatMessages.prefix().func_150257_a((ITextComponent)msg1));
            }
        }
    }

    static {
        PREFIX = new TextComponentString("[ReBind] ");
        PREFIX.func_150256_b().func_150238_a(TextFormatting.AQUA);
    }
}

