/*
 * Decompiled with CFR 0.152.
 */
package austeretony.rebind.common.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public enum EnumConfigSettings {
    EXTERNAL_CONFIG(0, "main", "external_config", true),
    REWRITE_CONTROLS(0, "main", "rewrite_controls", new boolean[0]),
    DEBUG_MODE(0, "main", "debug_mode", new boolean[0]),
    CHECK_UPDATES(0, "main", "custom_update_checker", new boolean[0]),
    CUSTOM_LOCALIZATION(0, "main", "enable_custom_localization", new boolean[0]),
    FIX_MM_KEYBINDING(0, "main", "fix_minemenu_keybinding", new boolean[0]),
    AUTO_JUMP(0, "game", "auto_jump", new boolean[0]),
    PLAYER_SPRINT(0, "controls", "player_sprint", new boolean[0]),
    DOUBLE_TAP_FORWARD_SPRINT(0, "controls", "double_tap_forward_sprint", new boolean[0]),
    MOUNT_SPRINT(0, "controls", "mount_sprint", new boolean[0]),
    HOTBAR_SCROLLING(0, "controls", "hotbar_scrolling", new boolean[0]);

    public final int type;
    public final String configSection;
    public final String configKey;
    public final boolean exclude;
    private boolean enabled;

    private EnumConfigSettings(int type, String configSection, String configKey, boolean ... exclude) {
        this.type = type;
        this.configSection = configSection;
        this.configKey = configKey;
        this.exclude = exclude.length > 0 ? exclude[0] : false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private JsonElement getValue(JsonObject jsonObject) {
        return jsonObject.get(this.configSection).getAsJsonObject().get(this.configKey);
    }

    public void initByType(JsonObject jsonObject) {
        switch (this.type) {
            case 0: {
                this.enabled = this.getValue(jsonObject).getAsBoolean();
            }
        }
    }

    public static void initAll(JsonObject config) {
        for (EnumConfigSettings enumSetting : EnumConfigSettings.values()) {
            if (enumSetting.exclude) continue;
            enumSetting.initByType(config);
        }
    }
}

