/*
 * Decompiled with CFR 0.152.
 */
package austeretony.rebind.common.config;

import austeretony.rebind.client.keybinding.KeyBindingWrapper;
import austeretony.rebind.common.config.EnumConfigSettings;
import austeretony.rebind.common.config.KeyBindingDeserializer;
import austeretony.rebind.common.config.KeyBindingObject;
import austeretony.rebind.common.config.KeyBindingsDeserializer;
import austeretony.rebind.common.config.KeyBindingsObject;
import austeretony.rebind.common.core.ReBindClassTransformer;
import austeretony.rebind.common.main.ReBindMain;
import austeretony.rebind.common.main.UpdateChecker;
import austeretony.rebind.common.reference.CommonReference;
import austeretony.rebind.common.util.ReBindUtils;
import com.google.common.collect.LinkedHashMultimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class ConfigLoader {
    public static final String EXT_CONFIGURATION_FILE = CommonReference.getGameFolder() + "/config/rebind/rebind.json";
    public static final String EXT_DATA_FILE = CommonReference.getGameFolder() + "/config/rebind/keybindings.json";
    public static final String EXT_LOCALIZATION_FILE = CommonReference.getGameFolder() + "/config/rebind/localization.json";

    public static void load() {
        try {
            JsonObject internalConfig = ReBindUtils.getInternalJsonData("assets/rebind/rebind.json").getAsJsonObject();
            JsonObject internalSettings = ReBindUtils.getInternalJsonData("assets/rebind/keybindings.json").getAsJsonObject();
            EnumConfigSettings.EXTERNAL_CONFIG.initByType(internalConfig);
            if (EnumConfigSettings.EXTERNAL_CONFIG.isEnabled()) {
                ConfigLoader.loadExternalConfig(internalConfig, internalSettings);
            } else {
                ConfigLoader.loadData(internalConfig, internalSettings);
            }
        }
        catch (IOException exception) {
            ReBindMain.LOGGER.error("Internal configuration files damaged!");
            exception.printStackTrace();
        }
    }

    private static void loadExternalConfig(JsonObject internalConfig, JsonObject internalSettings) {
        Path configPath = Paths.get(EXT_CONFIGURATION_FILE, new String[0]);
        Path settingsPath = Paths.get(EXT_DATA_FILE, new String[0]);
        if (Files.exists(configPath, new LinkOption[0]) && Files.exists(settingsPath, new LinkOption[0])) {
            try {
                ConfigLoader.loadData(ConfigLoader.updateConfig(internalConfig), ReBindUtils.getExternalJsonData(EXT_DATA_FILE).getAsJsonObject());
            }
            catch (IOException exception) {
                ReBindMain.LOGGER.error("External configuration file damaged!");
                exception.printStackTrace();
            }
        } else {
            try {
                Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
                Files.createDirectories(settingsPath.getParent(), new FileAttribute[0]);
                ConfigLoader.createExternalCopyAndLoad(internalConfig, internalSettings);
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }
    }

    private static JsonObject updateConfig(JsonObject internalConfig) throws IOException {
        try {
            JsonObject externalConfigOld = (JsonObject)ReBindUtils.getExternalJsonData(EXT_CONFIGURATION_FILE);
            JsonElement versionElement = externalConfigOld.get("version");
            if (versionElement == null || UpdateChecker.isOutdated(versionElement.getAsString(), "2.7.5:release:0")) {
                ReBindClassTransformer.CORE_LOGGER.info("Updating external config file...");
                JsonObject externalConfigNew = new JsonObject();
                externalConfigNew.add("version", (JsonElement)new JsonPrimitive("2.7.5:release:0"));
                LinkedHashMap internalData = new LinkedHashMap();
                HashMap externlDataOld = new HashMap();
                for (Map.Entry entry : internalConfig.entrySet()) {
                    internalData.put(entry.getKey(), entry.getValue());
                }
                for (Map.Entry entry : externalConfigOld.entrySet()) {
                    externlDataOld.put(entry.getKey(), entry.getValue());
                }
                for (String key : internalData.keySet()) {
                    LinkedHashMap internalGroup = new LinkedHashMap();
                    HashMap externlGroupOld = new HashMap();
                    JsonObject externalGroupNew = new JsonObject();
                    for (Map.Entry entry : ((JsonElement)internalData.get(key)).getAsJsonObject().entrySet()) {
                        internalGroup.put(entry.getKey(), entry.getValue());
                    }
                    if (externlDataOld.containsKey(key)) {
                        for (Map.Entry entry : ((JsonElement)externlDataOld.get(key)).getAsJsonObject().entrySet()) {
                            externlGroupOld.put(entry.getKey(), entry.getValue());
                        }
                        for (String k : internalGroup.keySet()) {
                            if (externlGroupOld.containsKey(k)) {
                                externalGroupNew.add(k, (JsonElement)externlGroupOld.get(k));
                                continue;
                            }
                            externalGroupNew.add(k, (JsonElement)internalGroup.get(k));
                        }
                    } else {
                        for (String k : internalGroup.keySet()) {
                            externalGroupNew.add(k, (JsonElement)internalGroup.get(k));
                        }
                    }
                    externalConfigNew.add(key, (JsonElement)externalGroupNew);
                    ReBindUtils.createExternalJsonFile(EXT_CONFIGURATION_FILE, (JsonElement)externalConfigNew);
                }
                return externalConfigNew;
            }
            ReBindClassTransformer.CORE_LOGGER.info("External config up-to-date!");
            return externalConfigOld;
        }
        catch (IOException exception) {
            ReBindClassTransformer.CORE_LOGGER.info("External configuration file damaged!");
            exception.printStackTrace();
            return null;
        }
    }

    private static void createExternalCopyAndLoad(JsonObject internalConfig, JsonObject internalSettings) {
        try {
            ReBindUtils.createExternalJsonFile(EXT_CONFIGURATION_FILE, (JsonElement)internalConfig);
            ReBindUtils.createAbsoluteJsonCopy(EXT_DATA_FILE, ReBindUtils.class.getClassLoader().getResourceAsStream("assets/rebind/keybindings.json"));
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        ConfigLoader.loadData(internalConfig, internalSettings);
    }

    private static void loadData(JsonObject configFile, JsonObject settingsFile) {
        EnumConfigSettings.initAll(configFile);
        Gson gson = new GsonBuilder().registerTypeAdapter(KeyBindingsObject.class, (Object)new KeyBindingsDeserializer()).registerTypeAdapter(KeyBindingObject.class, (Object)new KeyBindingDeserializer()).create();
        KeyBindingsObject properties = (KeyBindingsObject)gson.fromJson((JsonElement)settingsFile, KeyBindingsObject.class);
        for (Map.Entry<String, KeyBindingObject> entry : properties.getMap().entrySet()) {
            new KeyBindingWrapper(entry.getKey(), entry.getValue().holder, entry.getValue().name, entry.getValue().category, entry.getValue().keyCode, entry.getValue().keyModifier, entry.getValue().isEnabled, true);
        }
    }

    public static void loadCustomLocalization(List<String> languageList, Map<String, String> properties) {
        if (EnumConfigSettings.CUSTOM_LOCALIZATION.isEnabled()) {
            Path localizationPath = Paths.get(EXT_LOCALIZATION_FILE, new String[0]);
            if (Files.exists(localizationPath, new LinkOption[0])) {
                try {
                    ConfigLoader.loadLocalization(ReBindUtils.getExternalJsonData(EXT_LOCALIZATION_FILE).getAsJsonObject(), languageList, properties);
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                }
            } else {
                try {
                    Files.createDirectories(localizationPath.getParent(), new FileAttribute[0]);
                    ReBindUtils.createAbsoluteJsonCopy(EXT_LOCALIZATION_FILE, ConfigLoader.class.getClassLoader().getResourceAsStream("assets/rebind/localization.json"));
                    ConfigLoader.loadLocalization(ReBindUtils.getInternalJsonData("assets/rebind/localization.json").getAsJsonObject(), languageList, properties);
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    private static void loadLocalization(JsonObject localizationFile, List<String> languageList, Map<String, String> properties) {
        ReBindMain.LOGGER.info("Searching for custom localization...");
        for (String lang : languageList) {
            JsonElement entriesElement = localizationFile.get(lang.toLowerCase());
            if (entriesElement != null) {
                ReBindMain.LOGGER.info("Loading custom <" + lang + "> localization...");
                JsonArray entries = entriesElement.getAsJsonArray();
                for (JsonElement entryElement : entries) {
                    JsonObject entryObject = entryElement.getAsJsonObject();
                    if (!entryObject.has("key") || !entryObject.has("value")) continue;
                    properties.put(entryObject.get("key").getAsString(), entryObject.get("value").getAsString());
                }
                continue;
            }
            ReBindMain.LOGGER.error("Custom localization for <" + lang + "> undefined!");
        }
    }

    public static void updateSettingsFile() {
        LinkedHashMultimap propsByModnames = LinkedHashMultimap.create();
        TreeSet<String> sortedModNames = new TreeSet<String>();
        for (KeyBindingWrapper keyBindingWrapper : KeyBindingWrapper.UNKNOWN) {
            propsByModnames.put((Object)keyBindingWrapper.getModName(), (Object)keyBindingWrapper);
            sortedModNames.add(keyBindingWrapper.getModName());
        }
        KeyBindingsObject properties = new KeyBindingsObject();
        for (String modName : sortedModNames) {
            for (KeyBindingWrapper property : propsByModnames.get((Object)modName)) {
                properties.getMap().put(property.getKeyBindingId(), new KeyBindingObject(property.getHolderId(), property.getName(), property.getCategory(), property.getKeyCode(), property.getKeyModifier(), property.isEnabled()));
            }
        }
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        String prevCategory = "";
        for (Map.Entry<String, KeyBindingObject> entry : properties.getMap().entrySet()) {
            String line = "*" + entry.getKey() + "*: { *holder*: *" + entry.getValue().holder + "*, *name*: *" + entry.getValue().name + "*, *category*: *" + entry.getValue().category + "*, *key*: " + entry.getValue().keyCode + ", *mod*: *" + entry.getValue().keyModifier + "*, *enabled*: " + entry.getValue().isEnabled + "}";
            linkedHashMap.put(line.replace('*', '\"'), entry.getValue().category);
        }
        int index = 0;
        try (PrintStream printStream = new PrintStream(new File(EXT_DATA_FILE));){
            printStream.println("{");
            for (Map.Entry entry : linkedHashMap.entrySet()) {
                if (++index != 1 && !((String)entry.getValue()).equals(prevCategory)) {
                    printStream.println("");
                }
                String l = (String)entry.getKey();
                if (index < linkedHashMap.size()) {
                    l = l + ",";
                }
                printStream.println(l);
                prevCategory = (String)entry.getValue();
            }
            printStream.println("}");
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }
}

