/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.totemexpansion.item;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import party.lemons.totemexpansion.config.ModConfig;
import party.lemons.totemexpansion.handler.PlayerData;
import party.lemons.totemexpansion.handler.action.ActionState;
import party.lemons.totemexpansion.handler.action.Actions;
import party.lemons.totemexpansion.handler.action.impl.ActionRecall;
import party.lemons.totemexpansion.item.ItemTotemBase;
import party.lemons.totemexpansion.item.TotemType;

public class ItemTotemRecall
extends ItemTotemBase {
    public ItemTotemRecall() {
        super("totem_recalling", TotemType.ACTIVATE);
    }

    @Override
    public boolean onActivate(EntityPlayer living, ItemStack stack, DamageSource source) {
        super.onActivate(living, stack, source);
        PlayerData data = (PlayerData)living.getCapability(PlayerData.CAPABILITY, null);
        if (!(data.getActionState().getAction() instanceof ActionRecall)) {
            data.setActionState(living, new ActionState(Actions.RECALL_UP));
        }
        return true;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        int dim = worldIn.field_73011_w.getDimension();
        boolean allowed = false;
        for (int i = 0; i < ModConfig.ALLOWED_RECALL_DIMENSIONS.length; ++i) {
            if (ModConfig.ALLOWED_RECALL_DIMENSIONS[i] != dim) continue;
            allowed = true;
        }
        if (!allowed) {
            Style style = new Style().func_150217_b(Boolean.valueOf(true)).func_150238_a(TextFormatting.RED);
            playerIn.func_146105_b(new TextComponentTranslation("item.totemexpansion.totem_recalling.error", new Object[0]).func_150255_a(style), true);
            return new ActionResult(EnumActionResult.PASS, (Object)playerIn.func_184586_b(handIn));
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }
}

