/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.totemexpansion.item;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import baubles.api.render.IRenderBauble;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import party.lemons.totemexpansion.TotemExpansion;
import party.lemons.totemexpansion.config.ModConfig;
import party.lemons.totemexpansion.handler.TotemEventHandler;
import party.lemons.totemexpansion.item.ItemBase;
import party.lemons.totemexpansion.item.TotemType;
import party.lemons.totemexpansion.network.MessageItemEffect;

@Optional.InterfaceList(value={@Optional.Interface(iface="baubles.api.IBauble", modid="baubles"), @Optional.Interface(iface="baubles.api.render.IRenderBauble", modid="baubles")})
public class ItemTotemBase
extends ItemBase
implements IBauble,
IRenderBauble {
    private TotemType type;

    public ItemTotemBase(String name, TotemType type) {
        super(name);
        this.type = type;
        this.func_77625_d(1);
    }

    public boolean onActivate(EntityPlayer living, ItemStack stack, @Nullable DamageSource source) {
        if (!living.field_70170_p.field_72995_K && living instanceof EntityPlayerMP) {
            EntityPlayerMP entityplayermp = (EntityPlayerMP)living;
            entityplayermp.func_71029_a(StatList.func_188057_b((Item)this));
            CriteriaTriggers.field_193130_A.func_193187_a(entityplayermp, stack);
            TotemExpansion.NETWORK.sendTo((IMessage)new MessageItemEffect(stack, (Entity)living), (EntityPlayerMP)living);
            TotemExpansion.NETWORK.sendToAllTracking((IMessage)new MessageItemEffect(stack, (Entity)living), (Entity)living);
        }
        stack.func_190918_g(1);
        if (this.clearPotions()) {
            living.func_70674_bp();
        }
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (this.type == TotemType.ACTIVATE) {
            TotemEventHandler.activateTotem(playerIn, playerIn.func_184586_b(handIn), null);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
        }
        return new ActionResult(EnumActionResult.PASS, (Object)playerIn.func_184586_b(handIn));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(TextFormatting.DARK_PURPLE + I18n.func_135052_a((String)(this.func_77658_a() + ".desc"), (Object[])new Object[0]));
    }

    public boolean clearPotions() {
        return false;
    }

    public TotemType getType() {
        return this.type;
    }

    public BaubleType getBaubleType(ItemStack itemStack) {
        return BaubleType.CHARM;
    }

    @SideOnly(value=Side.CLIENT)
    public void onPlayerBaubleRender(ItemStack itemStack, EntityPlayer entityPlayer, IRenderBauble.RenderType renderType, float v) {
        if (!ModConfig.RENDER_BAUBLE || renderType != IRenderBauble.RenderType.BODY) {
            return;
        }
        double outAmount = !entityPlayer.func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b() ? (double)-0.2f : -0.14;
        IRenderBauble.Helper.rotateIfSneaking((EntityPlayer)entityPlayer);
        GlStateManager.func_179137_b((double)-0.15, (double)0.3, (double)outAmount);
        GlStateManager.func_179114_b((float)180.0f, (float)-0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179139_a((double)0.23, (double)0.23, (double)0.23);
        Minecraft.func_71410_x().func_175599_af().func_181564_a(itemStack, ItemCameraTransforms.TransformType.NONE);
    }
}

