/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.totemexpansion.handler;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import baubles.common.network.PacketHandler;
import baubles.common.network.PacketSync;
import java.util.Iterator;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import party.lemons.totemexpansion.config.ModConfig;
import party.lemons.totemexpansion.item.ItemTotemBase;
import party.lemons.totemexpansion.item.TotemType;
import party.lemons.totemexpansion.misc.TotemUtil;

@Mod.EventBusSubscriber(modid="totemexpansion")
public class TotemEventHandler {
    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ItemStack stack;
            if (event.player.field_70163_u < -5.0 && !(stack = TotemEventHandler.findTotem(event.player, TotemType.FALL_DEATH)).func_190926_b()) {
                TotemEventHandler.activateTotem(event.player, stack, null);
                return;
            }
            if (event.player.func_70093_af() && event.player.func_70660_b(MobEffects.field_188424_y) != null) {
                event.player.field_70143_R = 0.0f;
                event.player.field_70181_x = -0.1;
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerDamage(LivingDamageEvent event) {
        ItemStack stack;
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        TotemType totemType = null;
        if (event.getSource() == DamageSource.field_76371_c) {
            totemType = TotemType.DAMAGE_LAVA;
        } else if (event.getSource() == DamageSource.field_76369_e) {
            totemType = TotemType.DAMAGE_DROWN;
        }
        if (totemType != null && !(stack = TotemEventHandler.findTotem((EntityPlayer)event.getEntityLiving(), totemType)).func_190926_b()) {
            event.setCanceled(TotemEventHandler.activateTotem((EntityPlayer)event.getEntityLiving(), stack, event.getSource()));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onDeath(LivingDeathEvent event) {
        if (!event.isCanceled() && event.getEntityLiving() instanceof EntityPlayer) {
            ItemStack stack;
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            Object type = null;
            if (event.getSource() == DamageSource.field_76379_h && !(stack = TotemEventHandler.findTotem(player, TotemType.FALL_DEATH)).func_190926_b()) {
                event.setCanceled(TotemEventHandler.activateTotem(player, stack, event.getSource()));
                return;
            }
            stack = TotemEventHandler.findTotem(player, TotemType.DEATH);
            if (!stack.func_190926_b()) {
                event.setCanceled(TotemEventHandler.activateTotem(player, stack, event.getSource()));
                return;
            }
        }
    }

    @SubscribeEvent
    public static void onExplode(ExplosionEvent.Detonate event) {
        EntityPlayer p;
        ItemStack stack;
        Entity e;
        boolean flag = false;
        Iterator iterator = event.getAffectedEntities().iterator();
        while (iterator.hasNext() && (!((e = (Entity)iterator.next()) instanceof EntityPlayer) || (stack = TotemEventHandler.findTotem(p = (EntityPlayer)e, TotemType.EXPLODE)).func_190926_b() || !(flag = TotemEventHandler.activateTotem(p, stack, null)))) {
        }
        if (flag) {
            event.getAffectedEntities().clear();
            event.getAffectedBlocks().clear();
        }
    }

    @SubscribeEvent
    public static void onToolBreak(PlayerDestroyItemEvent event) {
        boolean flag;
        ItemStack stack;
        if (event.getHand() != null && event.getOriginal().func_77973_b() instanceof ItemTool && !(stack = TotemEventHandler.findTotem(event.getEntityPlayer(), TotemType.TOOL_BREAK)).func_190926_b() && (flag = TotemEventHandler.activateTotem(event.getEntityPlayer(), stack, null))) {
            ItemStack newStack = event.getOriginal().func_77946_l();
            newStack.func_77964_b(0);
            System.out.println(newStack);
            event.getEntityPlayer().field_71071_by.func_70441_a(newStack);
        }
    }

    @SubscribeEvent
    public static void onLivingKill(LivingDropsEvent event) {
        Random rand;
        int weaponChance;
        int chance;
        if (!event.getEntityLiving().field_70170_p.field_72995_K && event.getEntityLiving() instanceof IMob && event.getSource().func_76346_g() instanceof EntityPlayer && (chance = Math.max(0, weaponChance = (rand = event.getEntityLiving().func_70681_au()).nextInt(Math.max(1, ModConfig.HEAD_DROP_RATE - event.getLootingLevel() * ModConfig.HEAD_DROP_LOOTING_MODIFIER)))) == 0) {
            ItemStack stack = new ItemStack(TotemUtil.randomTotemHead(event.getEntityLiving().func_70681_au()));
            EntityItem eI = new EntityItem(event.getEntity().field_70170_p, event.getEntity().field_70165_t, event.getEntity().field_70163_u, event.getEntity().field_70161_v, stack);
            event.getDrops().add(eI);
        }
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("totemexpansion")) {
            ConfigManager.sync((String)"totemexpansion", (Config.Type)Config.Type.INSTANCE);
            TotemUtil.updateOreCache();
        }
    }

    public static boolean activateTotem(EntityPlayer living, ItemStack stack, @Nullable DamageSource source) {
        if (TotemUtil.isTotemBlacklisted(stack.func_77973_b())) {
            return false;
        }
        boolean result = ((ItemTotemBase)stack.func_77973_b()).onActivate(living, stack, source);
        if (Loader.isModLoaded((String)"baubles") && !living.field_70170_p.field_72995_K) {
            PacketHandler.INSTANCE.sendToAllTracking((IMessage)new PacketSync(living, BaubleType.CHARM.ordinal(), stack), (Entity)living);
            PacketHandler.INSTANCE.sendTo((IMessage)new PacketSync(living, BaubleType.CHARM.ordinal(), stack), (EntityPlayerMP)living);
        }
        return result;
    }

    public static ItemStack findTotem(EntityPlayer player, TotemType type) {
        if (Loader.isModLoaded((String)"baubles")) {
            IBaublesItemHandler baubles = BaublesApi.getBaublesHandler((EntityPlayer)player);
            for (int i = 0; i < baubles.getSlots(); ++i) {
                ItemTotemBase totem;
                ItemStack stack = baubles.getStackInSlot(i);
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemTotemBase) || (totem = (ItemTotemBase)stack.func_77973_b()).getType() != type) continue;
                return stack;
            }
        }
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            ItemTotemBase totem;
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemTotemBase) || (totem = (ItemTotemBase)stack.func_77973_b()).getType() != type) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }
}

