/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.registry.item;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.ModBase;
import org.orecruncher.dsurround.registry.IDataAccessor;
import org.orecruncher.dsurround.registry.RegistryManager;
import org.orecruncher.dsurround.registry.item.IItemData;
import org.orecruncher.dsurround.registry.item.ItemClass;
import org.orecruncher.dsurround.registry.item.SimpleItemData;

@SideOnly(value=Side.CLIENT)
public final class ItemUtils {
    @Nullable
    public static IItemData getItemData(@Nonnull Item item) {
        IDataAccessor accessor = (IDataAccessor)item;
        IItemData result = (IItemData)accessor.getData();
        if (result == null) {
            RegistryManager.ITEMS.reload();
            result = (IItemData)accessor.getData();
            if (result == null) {
                ModBase.log().warn("Unable to find IItemData for item [%s]", new Object[]{item.toString()});
                result = (IItemData)SimpleItemData.CACHE.get((Object)ItemClass.NONE);
                accessor.setData(result);
            }
        }
        return result;
    }

    public static void setItemData(@Nonnull Item item, @Nonnull IItemData data) {
        ((IDataAccessor)item).setData(data);
    }
}

