/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.registry.biome;

import com.google.common.primitives.Booleans;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.registry.biome.BiomeInfo;
import org.orecruncher.dsurround.registry.biome.BiomeUtil;
import org.orecruncher.dsurround.registry.config.BiomeConfig;
import org.orecruncher.lib.expression.BooleanValue;
import org.orecruncher.lib.expression.Expression;
import org.orecruncher.lib.expression.Function;
import org.orecruncher.lib.expression.IVariant;
import org.orecruncher.lib.expression.NumberValue;
import org.orecruncher.lib.expression.StringValue;
import org.orecruncher.lib.expression.Variant;

@SideOnly(value=Side.CLIENT)
public abstract class BiomeMatcher {
    public abstract boolean match(@Nonnull BiomeInfo var1);

    public static BiomeMatcher getMatcher(@Nonnull BiomeConfig cfg) {
        if (cfg.conditions == null) {
            cfg.conditions = "";
        }
        return new ConditionsImpl(cfg);
    }

    private static class ConditionsImpl
    extends BiomeMatcher {
        protected BiomeInfo current;
        protected final Expression exp;

        public ConditionsImpl(@Nonnull BiomeConfig config) {
            this.exp = new Expression(config.conditions);
            this.exp.addVariable(new Variant("biome.name"){

                public int compareTo(IVariant o) {
                    return this.asString().compareTo(o.asString());
                }

                public float asNumber() {
                    return 0.0f;
                }

                public String asString() {
                    return current.getBiomeName();
                }

                public boolean asBoolean() {
                    return false;
                }

                public IVariant add(IVariant term) {
                    return new StringValue(this.asString().concat(term.asString()));
                }
            });
            this.exp.addVariable(new Variant("biome.id"){

                public int compareTo(IVariant o) {
                    return this.asString().compareTo(o.asString());
                }

                public float asNumber() {
                    return 0.0f;
                }

                public String asString() {
                    return current.getKey().toString();
                }

                public boolean asBoolean() {
                    return false;
                }

                public IVariant add(IVariant term) {
                    return new StringValue(this.asString().concat(term.asString()));
                }
            });
            this.exp.addVariable(new Variant("biome.modid"){

                public int compareTo(IVariant o) {
                    return this.asString().compareTo(o.asString());
                }

                public float asNumber() {
                    return 0.0f;
                }

                public String asString() {
                    return current.getKey().func_110624_b();
                }

                public boolean asBoolean() {
                    return false;
                }

                public IVariant add(IVariant term) {
                    return new StringValue(this.asString().concat(term.asString()));
                }
            });
            this.exp.addVariable(new Variant("biome.rainfall"){

                public int compareTo(IVariant o) {
                    return Float.compare(this.asNumber(), o.asNumber());
                }

                public float asNumber() {
                    return current.getRainfall();
                }

                public String asString() {
                    return Float.toString(this.asNumber());
                }

                public boolean asBoolean() {
                    return this.asNumber() != 0.0f;
                }

                public IVariant add(IVariant term) {
                    return new NumberValue(this.asNumber() + term.asNumber());
                }
            });
            this.exp.addVariable(new Variant("biome.isFake"){

                public int compareTo(IVariant o) {
                    return this.asString().compareTo(o.asString());
                }

                public float asNumber() {
                    return this.asBoolean() ? 1.0f : 0.0f;
                }

                public String asString() {
                    return Boolean.toString(this.asBoolean());
                }

                public boolean asBoolean() {
                    return current.isFake();
                }

                public IVariant add(IVariant term) {
                    return new BooleanValue(this.asBoolean() || term.asBoolean());
                }
            });
            Set<BiomeDictionary.Type> stuff = BiomeUtil.getBiomeTypes();
            for (BiomeDictionary.Type t : stuff) {
                this.exp.addVariable((Variant)new BiomeTypeVariable(t));
            }
            for (ResourceLocation b : Biome.field_185377_q.func_148742_b()) {
                if (!"minecraft".equals(b.func_110624_b())) continue;
                this.exp.addVariable((Variant)new StringValue("biomeType." + b.func_110623_a(), b.toString()));
            }
            this.exp.addFunction(new Function("biome.isLike", 1){

                public IVariant eval(IVariant ... params) {
                    String biomeName = params[0].asString();
                    Biome biome = (Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation(biomeName));
                    return biome != null && current.areBiomesSameClass(biome) ? Expression.TRUE : Expression.FALSE;
                }
            });
            this.exp.getRPN();
        }

        @Override
        public boolean match(@Nonnull BiomeInfo info) {
            this.current = info;
            return this.exp.eval().asBoolean();
        }

        private class BiomeTypeVariable
        extends Variant {
            private final BiomeDictionary.Type type;

            public BiomeTypeVariable(BiomeDictionary.Type t) {
                super("biome.is" + t.getName());
                this.type = t;
            }

            public int compareTo(IVariant o) {
                return Booleans.compare((boolean)this.asBoolean(), (boolean)o.asBoolean());
            }

            public float asNumber() {
                return this.asBoolean() ? 1.0f : 0.0f;
            }

            public String asString() {
                return Boolean.toString(this.asBoolean());
            }

            public boolean asBoolean() {
                return ConditionsImpl.this.current.isBiomeType(this.type);
            }

            public Variant add(IVariant term) {
                return new BooleanValue(this.asBoolean() || term.asBoolean());
            }
        }
    }
}

