/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.scanner;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;
import org.orecruncher.dsurround.lib.scanner.ScanLocus;
import org.orecruncher.dsurround.lib.scanner.Scanner;
import org.orecruncher.lib.random.LCGRandom;

public abstract class RandomScanner
extends Scanner {
    private final LCGRandom lcg = new LCGRandom();
    private int playerX;
    private int playerY;
    private int playerZ;

    public RandomScanner(@Nonnull ScanLocus locus, @Nonnull String name, int range) {
        super(locus, name, range);
    }

    public RandomScanner(@Nonnull ScanLocus locus, @Nonnull String name, int range, int blocksPerTick) {
        super(locus, name, range, blocksPerTick);
    }

    private int randomRange(int range) {
        return this.lcg.nextInt(range) - this.lcg.nextInt(range);
    }

    @Override
    public void preScan() {
        BlockPos pos = this.locus.getCenter();
        this.playerX = pos.func_177958_n();
        this.playerY = pos.func_177956_o();
        this.playerZ = pos.func_177952_p();
    }

    @Override
    @Nonnull
    protected BlockPos nextPos(@Nonnull BlockPos.MutableBlockPos workingPos, @Nonnull Random rand) {
        return workingPos.func_181079_c(this.playerX + this.randomRange(this.xRange), this.playerY + this.randomRange(this.yRange), this.playerZ + this.randomRange(this.zRange));
    }
}

