/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.expression;

import net.minecraft.world.World;
import org.orecruncher.dsurround.capabilities.CapabilitySeasonInfo;
import org.orecruncher.dsurround.capabilities.season.ISeasonInfo;
import org.orecruncher.dsurround.client.handlers.EnvironStateHandler;
import org.orecruncher.dsurround.client.weather.Weather;
import org.orecruncher.lib.expression.Dynamic;
import org.orecruncher.lib.expression.DynamicVariantList;
import org.orecruncher.lib.expression.IDynamicVariant;

public class WeatherVariables
extends DynamicVariantList {
    public WeatherVariables() {
        this.add((IDynamicVariant)new Dynamic.DynamicBoolean("weather.isRaining", () -> Weather.isRaining()));
        this.add((IDynamicVariant)new Dynamic.DynamicBoolean("weather.isThundering", () -> Weather.isThundering()));
        this.add((IDynamicVariant)new Dynamic.DynamicString("weather.temperature", () -> EnvironStateHandler.EnvironState.getBiomeTemperature().getValue()));
        this.add((IDynamicVariant)new Dynamic.DynamicBoolean("weather.isNotRaining", () -> !Weather.isRaining()));
        this.add((IDynamicVariant)new Dynamic.DynamicBoolean("weather.isNotThundering", () -> !Weather.isThundering()));
        this.add((IDynamicVariant)new Dynamic.DynamicNumber("weather.rainfall", () -> Float.valueOf(Weather.getIntensityLevel())));
        this.add((IDynamicVariant)new Dynamic.DynamicNumber("weather.temperatureValue", () -> {
            World world = EnvironStateHandler.EnvironState.getWorld();
            ISeasonInfo season = CapabilitySeasonInfo.getCapability(world);
            return Float.valueOf(season.getTemperature(EnvironStateHandler.EnvironState.getPlayerPosition()));
        }));
        this.add((IDynamicVariant)new Dynamic.DynamicBoolean("weather.canWaterFreeze", () -> {
            World world = EnvironStateHandler.EnvironState.getWorld();
            ISeasonInfo season = CapabilitySeasonInfo.getCapability(world);
            return season.canWaterFreeze(EnvironStateHandler.EnvironState.getPlayerPosition());
        }));
    }
}

