/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.handlers.fog;

import javax.annotation.Nonnull;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.ModBase;
import org.orecruncher.dsurround.client.handlers.fog.FogResult;
import org.orecruncher.dsurround.client.handlers.fog.IFogRangeCalculator;
import org.orecruncher.lib.collections.ObjectArray;

@SideOnly(value=Side.CLIENT)
public class HolisticFogRangeCalculator
implements IFogRangeCalculator {
    protected final ObjectArray<IFogRangeCalculator> calculators = new ObjectArray(8);
    protected final FogResult cached = new FogResult();

    public void add(@Nonnull IFogRangeCalculator calc2) {
        this.calculators.add((Object)calc2);
    }

    @Override
    @Nonnull
    public String getName() {
        return "HolisticFogRangeCalculator";
    }

    @Override
    @Nonnull
    public FogResult calculate(@Nonnull EntityViewRenderEvent.RenderFogEvent event) {
        if (event.getFarPlaneDistance() < 0.0f) {
            ModBase.log().warn("Far plane distance in RenderFogEvent is negative: %d", new Object[]{Float.valueOf(event.getFarPlaneDistance())});
        }
        this.cached.set(event);
        float start = this.cached.getStart();
        float end = this.cached.getEnd();
        for (int i = 0; i < this.calculators.size(); ++i) {
            IFogRangeCalculator calc2 = (IFogRangeCalculator)this.calculators.get(i);
            FogResult result = calc2.calculate(event);
            if (result.getStart() >= result.getEnd() || result.getStart() < 0.0f || result.getEnd() < 0.0f) {
                ModBase.log().warn("Fog calculator '%s' has invalid results (start %f, end %f); ignoring", new Object[]{calc2.getName(), Float.valueOf(result.getStart()), Float.valueOf(result.getEnd())});
                continue;
            }
            start = Math.min(start, result.getStart());
            end = Math.min(end, result.getEnd());
        }
        this.cached.set(start, end);
        return this.cached;
    }

    @Override
    public void tick() {
        this.calculators.forEach(IFogRangeCalculator::tick);
    }

    @Nonnull
    public String toString() {
        return this.cached.toString();
    }
}

