/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.handlers;

import com.google.common.base.MoreObjects;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.client.handlers.DiagnosticHandler;
import org.orecruncher.dsurround.client.handlers.EffectManager;
import org.orecruncher.lib.math.TimerEMA;
import org.orecruncher.lib.random.XorShiftRandom;

@SideOnly(value=Side.CLIENT)
public abstract class EffectHandlerBase {
    protected final Random RANDOM = XorShiftRandom.current();
    private final TimerEMA timer;
    private final String handlerName;

    EffectHandlerBase(@Nonnull String name) {
        this.handlerName = name;
        this.timer = new TimerEMA(name);
    }

    public final String getHandlerName() {
        return this.handlerName;
    }

    public boolean doTick(int tick) {
        return true;
    }

    public void process(@Nonnull EntityPlayer player2) {
    }

    public void onConnect() {
    }

    public void onDisconnect() {
    }

    protected static EntityPlayer getPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    protected static World getWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    final void updateTimer(long nanos) {
        this.timer.update((double)nanos);
    }

    final void connect0() {
        ((DiagnosticHandler)EffectManager.instance().lookupService(DiagnosticHandler.class)).addTimer(this.timer);
        this.onConnect();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    final void disconnect0() {
        MinecraftForge.EVENT_BUS.unregister((Object)this);
        this.onDisconnect();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.getHandlerName()).toString();
    }
}

