/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.fx.particle.mote;

import javax.annotation.Nonnull;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.client.fx.particle.mote.MoteMotionBase;

@SideOnly(value=Side.CLIENT)
public abstract class MoteAnimatedBase
extends MoteMotionBase {
    protected int textureIdx;
    protected final int numAgingFrames;
    protected float baseAirFriction = 0.91f;
    protected float fadeTargetRed;
    protected float fadeTargetGreen;
    protected float fadeTargetBlue;
    protected boolean fadingColor;
    protected double xAcceleration;
    protected double yAcceleration;
    protected double zAcceleration;
    protected boolean doRender;
    protected int particleTextureIndexX;
    protected int particleTextureIndexY;
    protected float texU1;
    protected float texU2;
    protected float texV1;
    protected float texV2;
    protected float particleScale;

    public MoteAnimatedBase(int textureIdx, int numFrames, @Nonnull World world, double x, double y, double z, double dX, double dY, double dZ) {
        super(world, x, y, z, dX, dY, dZ);
        this.textureIdx = textureIdx;
        this.numAgingFrames = numFrames;
        this.particleScale = (RANDOM.nextFloat() * 0.5f + 0.5f) * 2.0f;
    }

    public void setColor(int rgb) {
        this.red = (rgb & 0xFF0000) >> 16;
        this.green = (rgb & 0xFF00) >> 8;
        this.blue = (rgb & 0xFF) >> 0;
        this.alpha = 255;
    }

    public void setColorFade(int rgb) {
        this.fadeTargetRed = (float)((rgb & 0xFF0000) >> 16) / 255.0f;
        this.fadeTargetGreen = (float)((rgb & 0xFF00) >> 8) / 255.0f;
        this.fadeTargetBlue = (float)((rgb & 0xFF) >> 0) / 255.0f;
        this.fadingColor = true;
    }

    @Override
    public void handleCollision() {
        this.motionX *= (double)0.7f;
        this.motionZ *= (double)0.7f;
    }

    @Override
    public void update() {
        this.motionY += this.yAcceleration;
        this.motionX += this.xAcceleration;
        this.motionZ += this.zAcceleration;
        this.motionX *= (double)this.baseAirFriction;
        this.motionY *= (double)this.baseAirFriction;
        this.motionZ *= (double)this.baseAirFriction;
        super.update();
        if (this.isAlive()) {
            if (this.age > this.maxAge / 2) {
                this.alpha = (int)((1.0f - ((float)this.age - (float)(this.maxAge / 2)) / (float)this.maxAge) * 255.0f);
                if (this.fadingColor) {
                    this.red = (int)((float)this.red + (this.fadeTargetRed - (float)this.red) * 0.2f);
                    this.green = (int)((float)this.green + (this.fadeTargetGreen - (float)this.green) * 0.2f);
                    this.blue = (int)((float)this.blue + (this.fadeTargetBlue - (float)this.blue) * 0.2f);
                }
            }
            this.setParticleTextureIndex(this.textureIdx + (this.numAgingFrames - 1 - this.age * this.numAgingFrames / this.maxAge));
        }
    }

    @Override
    public int getBrightnessForRender(float partialTick) {
        return 0xF000F0;
    }

    @Override
    public void renderParticle(BufferBuilder buffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        double x = this.renderX(partialTicks);
        double y = this.renderY(partialTicks);
        double z = this.renderZ(partialTicks);
        this.drawVertex(buffer, x + (double)(-rotationX * this.particleScale - rotationXY * this.particleScale), y + (double)(-rotationZ * this.particleScale), z + (double)(-rotationYZ * this.particleScale - rotationXZ * this.particleScale), this.texU2, this.texV2);
        this.drawVertex(buffer, x + (double)(-rotationX * this.particleScale + rotationXY * this.particleScale), y + (double)(rotationZ * this.particleScale), z + (double)(-rotationYZ * this.particleScale + rotationXZ * this.particleScale), this.texU2, this.texV1);
        this.drawVertex(buffer, x + (double)(rotationX * this.particleScale + rotationXY * this.particleScale), y + (double)(rotationZ * this.particleScale), z + (double)(rotationYZ * this.particleScale + rotationXZ * this.particleScale), this.texU1, this.texV1);
        this.drawVertex(buffer, x + (double)(rotationX * this.particleScale - rotationXY * this.particleScale), y + (double)(-rotationZ * this.particleScale), z + (double)(rotationYZ * this.particleScale - rotationXZ * this.particleScale), this.texU1, this.texV2);
    }

    public void setParticleTextureIndex(int particleTextureIndex) {
        this.particleTextureIndexX = particleTextureIndex % 16;
        this.particleTextureIndexY = particleTextureIndex / 16;
        this.texU1 = (float)this.particleTextureIndexX / 16.0f;
        this.texU2 = this.texU1 + 0.0624375f;
        this.texV1 = (float)this.particleTextureIndexY / 16.0f;
        this.texV2 = this.texV1 + 0.0624375f;
    }
}

