/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.fx;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.client.fx.BlockEffectType;
import org.orecruncher.dsurround.client.fx.JetEffect;
import org.orecruncher.dsurround.client.fx.particle.system.ParticleFireJet;
import org.orecruncher.lib.chunk.IBlockAccessEx;

@SideOnly(value=Side.CLIENT)
public class FireJetEffect
extends JetEffect {
    public FireJetEffect(int chance) {
        super(chance);
    }

    @Override
    @Nonnull
    public BlockEffectType getEffectType() {
        return BlockEffectType.FIRE_JET;
    }

    @Override
    public boolean canTrigger(@Nonnull IBlockAccessEx provider, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull Random random) {
        if (state.func_185904_a().func_76220_a() || state.func_185904_a().func_76224_d()) {
            return provider.func_175623_d(pos.func_177984_a()) && super.canTrigger(provider, state, pos, random);
        }
        return false;
    }

    @Override
    public void doEffect(@Nonnull IBlockAccessEx provider, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull Random random) {
        float spawnHeight;
        int blockCount;
        Material blockMaterial = state.func_185904_a();
        if (blockMaterial.func_76220_a()) {
            blockCount = 2;
            spawnHeight = (float)pos.func_177956_o() + 1.1f;
        } else if (blockMaterial.func_76224_d()) {
            blockCount = FireJetEffect.countBlocks(provider, pos, s -> s.func_185904_a() == blockMaterial, -1);
            spawnHeight = BlockLiquid.func_190972_g((IBlockState)state, (IBlockAccess)provider, (BlockPos)pos);
        } else {
            return;
        }
        if (blockCount > 0) {
            ParticleFireJet effect = new ParticleFireJet(blockCount, provider.getWorld(), (double)pos.func_177958_n() + 0.5, spawnHeight, (double)pos.func_177952_p() + 0.5);
            this.addEffect(effect);
        }
    }
}

