/*
 * Decompiled with CFR 0.152.
 */
package net.crazysnailboy.mods.villagertrades.nbt;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Stack;
import java.util.regex.Pattern;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JsonToNBT {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Pattern INT_ARRAY_MATCHER = Pattern.compile("\\[[-+\\d|,\\s]+\\]");

    public static NBTTagCompound getTagFromJson(String jsonString) throws NBTException {
        if (!(jsonString = jsonString.trim()).startsWith("{")) {
            throw new NBTException("Invalid tag encountered, expected '{' as first char.");
        }
        if (JsonToNBT.topTagsCount(jsonString) != 1) {
            throw new NBTException("Encountered multiple top tags, only one expected");
        }
        return (NBTTagCompound)JsonToNBT.nameValueToNBT("tag", jsonString).parse();
    }

    static int topTagsCount(String str) throws NBTException {
        int i = 0;
        boolean flag = false;
        Stack<Character> stack = new Stack<Character>();
        for (int j = 0; j < str.length(); ++j) {
            char c0 = str.charAt(j);
            if (c0 == '\"') {
                if (JsonToNBT.isCharEscaped(str, j)) {
                    if (flag) continue;
                    throw new NBTException("Illegal use of \\\": " + str);
                }
                flag = !flag;
                continue;
            }
            if (flag) continue;
            if (c0 != '{' && c0 != '[') {
                if (c0 == '}' && (stack.isEmpty() || ((Character)stack.pop()).charValue() != '{')) {
                    throw new NBTException("Unbalanced curly brackets {}: " + str);
                }
                if (c0 != ']' || !stack.isEmpty() && ((Character)stack.pop()).charValue() == '[') continue;
                throw new NBTException("Unbalanced square brackets []: " + str);
            }
            if (stack.isEmpty()) {
                ++i;
            }
            stack.push(Character.valueOf(c0));
        }
        if (flag) {
            throw new NBTException("Unbalanced quotation: " + str);
        }
        if (!stack.isEmpty()) {
            throw new NBTException("Unbalanced brackets: " + str);
        }
        if (i == 0 && !str.isEmpty()) {
            i = 1;
        }
        return i;
    }

    static Any joinStrToNBT(String ... args) throws NBTException {
        return JsonToNBT.nameValueToNBT(args[0], args[1]);
    }

    static Any nameValueToNBT(String key, String value) throws NBTException {
        value = value.trim();
        if (key.startsWith("\"") && key.endsWith("\"")) {
            key = key.substring(1, key.length() - 1);
        }
        if (value.startsWith("{")) {
            value = value.substring(1, value.length() - 1);
            Compound jsontonbt$compound = new Compound(key);
            while (value.length() > 0) {
                String s1 = JsonToNBT.nextNameValuePair(value, true);
                if (s1.length() > 0) {
                    boolean flag1 = false;
                    jsontonbt$compound.tagList.add(JsonToNBT.getTagFromNameValue(s1, false));
                }
                if (value.length() < s1.length() + 1) break;
                char c1 = value.charAt(s1.length());
                if (c1 != ',' && c1 != '{' && c1 != '}' && c1 != '[' && c1 != ']') {
                    throw new NBTException("Unexpected token '" + c1 + "' at: " + value.substring(s1.length()));
                }
                value = value.substring(s1.length() + 1);
            }
            return jsontonbt$compound;
        }
        if (value.startsWith("[") && !INT_ARRAY_MATCHER.matcher(value).matches()) {
            value = value.substring(1, value.length() - 1);
            List jsontonbt$list = new List(key);
            while (value.length() > 0) {
                String s = JsonToNBT.nextNameValuePair(value, false);
                if (s.length() > 0) {
                    boolean flag = true;
                    jsontonbt$list.tagList.add(JsonToNBT.getTagFromNameValue(s, true));
                }
                if (value.length() < s.length() + 1) break;
                char c0 = value.charAt(s.length());
                if (c0 != ',' && c0 != '{' && c0 != '}' && c0 != '[' && c0 != ']') {
                    throw new NBTException("Unexpected token '" + c0 + "' at: " + value.substring(s.length()));
                }
                value = value.substring(s.length() + 1);
            }
            return jsontonbt$list;
        }
        return new Primitive(key, value);
    }

    private static Any getTagFromNameValue(String str, boolean isArray) throws NBTException {
        String s = JsonToNBT.locateName(str, isArray);
        String s1 = JsonToNBT.locateValue(str, isArray);
        return JsonToNBT.joinStrToNBT(s, s1);
    }

    private static String nextNameValuePair(String str, boolean isCompound) throws NBTException {
        int i = JsonToNBT.getNextCharIndex(str, ':');
        int j = JsonToNBT.getNextCharIndex(str, ',');
        if (isCompound) {
            if (i == -1) {
                throw new NBTException("Unable to locate name/value separator for string: " + str);
            }
            if (j != -1 && j < i) {
                throw new NBTException("Name error at: " + str);
            }
        } else if (i == -1 || i > j) {
            i = -1;
        }
        return JsonToNBT.locateValueAt(str, i);
    }

    private static String locateValueAt(String str, int index) throws NBTException {
        int i;
        Stack<Character> stack = new Stack<Character>();
        boolean flag = false;
        boolean flag1 = false;
        boolean flag2 = false;
        int j = 0;
        for (i = index + 1; i < str.length(); ++i) {
            char c0 = str.charAt(i);
            if (c0 == '\"') {
                if (JsonToNBT.isCharEscaped(str, i)) {
                    if (!flag) {
                        throw new NBTException("Illegal use of \\\": " + str);
                    }
                } else {
                    boolean bl = flag = !flag;
                    if (flag && !flag2) {
                        flag1 = true;
                    }
                    if (!flag) {
                        j = i;
                    }
                }
            } else if (!flag) {
                if (c0 != '{' && c0 != '[') {
                    if (c0 == '}' && (stack.isEmpty() || ((Character)stack.pop()).charValue() != '{')) {
                        throw new NBTException("Unbalanced curly brackets {}: " + str);
                    }
                    if (c0 == ']' && (stack.isEmpty() || ((Character)stack.pop()).charValue() != '[')) {
                        throw new NBTException("Unbalanced square brackets []: " + str);
                    }
                    if (c0 == ',' && stack.isEmpty()) {
                        return str.substring(0, i);
                    }
                } else {
                    stack.push(Character.valueOf(c0));
                }
            }
            if (Character.isWhitespace(c0)) continue;
            if (!flag && flag1 && j != i) {
                return str.substring(0, j + 1);
            }
            flag2 = true;
        }
        return str.substring(0, i);
    }

    private static String locateName(String str, boolean isArray) throws NBTException {
        if (isArray && ((str = str.trim()).startsWith("{") || str.startsWith("["))) {
            return "";
        }
        int i = JsonToNBT.getNextCharIndex(str, ':');
        if (i == -1) {
            if (isArray) {
                return "";
            }
            throw new NBTException("Unable to locate name/value separator for string: " + str);
        }
        return str.substring(0, i).trim();
    }

    private static String locateValue(String str, boolean isArray) throws NBTException {
        if (isArray && ((str = str.trim()).startsWith("{") || str.startsWith("["))) {
            return str;
        }
        int i = JsonToNBT.getNextCharIndex(str, ':');
        if (i == -1) {
            if (isArray) {
                return str;
            }
            throw new NBTException("Unable to locate name/value separator for string: " + str);
        }
        return str.substring(i + 1).trim();
    }

    private static int getNextCharIndex(String str, char targetChar) {
        boolean flag = true;
        for (int i = 0; i < str.length(); ++i) {
            char c0 = str.charAt(i);
            if (c0 == '\"') {
                if (JsonToNBT.isCharEscaped(str, i)) continue;
                flag = !flag;
                continue;
            }
            if (!flag) continue;
            if (c0 == targetChar) {
                return i;
            }
            if (c0 != '{' && c0 != '[') continue;
            return -1;
        }
        return -1;
    }

    private static boolean isCharEscaped(String str, int index) {
        return index > 0 && str.charAt(index - 1) == '\\' && !JsonToNBT.isCharEscaped(str, index - 1);
    }

    private static class NBTException
    extends net.minecraft.nbt.NBTException {
        private NBTException(String message) {
            super(message, "", -1);
        }
    }

    static class Primitive
    extends Any {
        private static final Pattern DOUBLE = Pattern.compile("[-+]?[0-9]*\\.?[0-9]+[d|D]");
        private static final Pattern FLOAT = Pattern.compile("[-+]?[0-9]*\\.?[0-9]+[f|F]");
        private static final Pattern BYTE = Pattern.compile("[-+]?[0-9]+[b|B]");
        private static final Pattern LONG = Pattern.compile("[-+]?[0-9]+[l|L]");
        private static final Pattern SHORT = Pattern.compile("[-+]?[0-9]+[s|S]");
        private static final Pattern INTEGER = Pattern.compile("[-+]?[0-9]+");
        private static final Pattern DOUBLE_UNTYPED = Pattern.compile("[-+]?[0-9]*\\.?[0-9]+");
        private static final Splitter SPLITTER = Splitter.on((char)',').omitEmptyStrings();
        protected String jsonValue;

        public Primitive(String jsonIn, String valueIn) {
            this.json = jsonIn;
            this.jsonValue = valueIn;
        }

        @Override
        public NBTBase parse() throws NBTException {
            try {
                if (DOUBLE.matcher(this.jsonValue).matches()) {
                    return new NBTTagDouble(Double.parseDouble(this.jsonValue.substring(0, this.jsonValue.length() - 1)));
                }
                if (FLOAT.matcher(this.jsonValue).matches()) {
                    return new NBTTagFloat(Float.parseFloat(this.jsonValue.substring(0, this.jsonValue.length() - 1)));
                }
                if (BYTE.matcher(this.jsonValue).matches()) {
                    return new NBTTagByte(Byte.parseByte(this.jsonValue.substring(0, this.jsonValue.length() - 1)));
                }
                if (LONG.matcher(this.jsonValue).matches()) {
                    return new NBTTagLong(Long.parseLong(this.jsonValue.substring(0, this.jsonValue.length() - 1)));
                }
                if (SHORT.matcher(this.jsonValue).matches()) {
                    return new NBTTagShort(Short.parseShort(this.jsonValue.substring(0, this.jsonValue.length() - 1)));
                }
                if (INTEGER.matcher(this.jsonValue).matches()) {
                    return new NBTTagInt(Integer.parseInt(this.jsonValue));
                }
                if (DOUBLE_UNTYPED.matcher(this.jsonValue).matches()) {
                    return new NBTTagDouble(Double.parseDouble(this.jsonValue));
                }
                if ("true".equalsIgnoreCase(this.jsonValue) || "false".equalsIgnoreCase(this.jsonValue)) {
                    return new NBTTagByte((byte)(Boolean.parseBoolean(this.jsonValue) ? 1 : 0));
                }
            }
            catch (NumberFormatException var6) {
                this.jsonValue = this.jsonValue.replaceAll("\\\\\"", "\"");
                return new NBTTagString(this.jsonValue);
            }
            if (this.jsonValue.startsWith("[") && this.jsonValue.endsWith("]")) {
                String s = this.jsonValue.substring(1, this.jsonValue.length() - 1);
                String[] astring = (String[])Iterables.toArray((Iterable)SPLITTER.split((CharSequence)s), String.class);
                try {
                    int[] aint = new int[astring.length];
                    for (int j = 0; j < astring.length; ++j) {
                        aint[j] = Integer.parseInt(astring[j].trim());
                    }
                    return new NBTTagIntArray(aint);
                }
                catch (NumberFormatException var5) {
                    return new NBTTagString(this.jsonValue);
                }
            }
            if (this.jsonValue.startsWith("\"") && this.jsonValue.endsWith("\"")) {
                this.jsonValue = this.jsonValue.substring(1, this.jsonValue.length() - 1);
            }
            this.jsonValue = this.jsonValue.replaceAll("\\\\\"", "\"");
            StringBuilder stringbuilder = new StringBuilder();
            for (int i = 0; i < this.jsonValue.length(); ++i) {
                if (i < this.jsonValue.length() - 1 && this.jsonValue.charAt(i) == '\\' && this.jsonValue.charAt(i + 1) == '\\') {
                    stringbuilder.append('\\');
                    ++i;
                    continue;
                }
                stringbuilder.append(this.jsonValue.charAt(i));
            }
            return new NBTTagString(stringbuilder.toString());
        }
    }

    static class List
    extends Any {
        protected java.util.List<Any> tagList = Lists.newArrayList();

        public List(String json) {
            this.json = json;
        }

        @Override
        public NBTBase parse() throws NBTException {
            NBTTagList nbttaglist = new NBTTagList();
            for (Any jsontonbt$any : this.tagList) {
                nbttaglist.func_74742_a(jsontonbt$any.parse());
            }
            return nbttaglist;
        }
    }

    static class Compound
    extends Any {
        protected java.util.List<Any> tagList = Lists.newArrayList();

        public Compound(String jsonIn) {
            this.json = jsonIn;
        }

        @Override
        public NBTBase parse() throws NBTException {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            for (Any jsontonbt$any : this.tagList) {
                nbttagcompound.func_74782_a(jsontonbt$any.json, jsontonbt$any.parse());
            }
            return nbttagcompound;
        }
    }

    static abstract class Any {
        protected String json;

        Any() {
        }

        public abstract NBTBase parse() throws NBTException;
    }
}

