/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.extendeddays.event;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.silentchaos512.extendeddays.ExtendedDays;
import net.silentchaos512.extendeddays.config.Config;
import net.silentchaos512.extendeddays.event.ClientEvents;
import net.silentchaos512.extendeddays.network.MessageSetTime;
import net.silentchaos512.extendeddays.network.MessageSyncTime;
import net.silentchaos512.extendeddays.world.ExtendedDaysSavedData;
import net.silentchaos512.lib.util.LogHelper;
import net.silentchaos512.lib.util.TimeHelper;

public class TimeEvents {
    public static final TimeEvents INSTANCE = new TimeEvents();
    public static Map<Integer, Float> extendedPeriods = new HashMap<Integer, Float>();
    private int extendedTime = 0;

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase != TickEvent.Phase.START || event.world.field_73011_w.getDimension() != 0 || !event.world.func_82736_K().func_82766_b("doDaylightCycle")) {
            return;
        }
        LogHelper log = ExtendedDays.logHelper;
        long worldTime = event.world.func_72820_D();
        int dayTime = (int)(worldTime % 24000L);
        ExtendedDaysSavedData data = ExtendedDaysSavedData.get(event.world);
        if (data == null) {
            return;
        }
        if (data.extendedTime > 0) {
            this.startExtendedPeriod(event.world, data.extendedTime);
            if (worldTime > data.worldTime && worldTime < data.worldTime + 600L && extendedPeriods.containsKey((int)(data.worldTime % 24000L)) && this.extendedTime > 0 && data.worldTime > 0L) {
                worldTime = data.worldTime;
                this.setWorldTime(event.world, worldTime);
            }
        }
        if (this.extendedTime > 0) {
            --this.extendedTime;
            if (this.extendedTime <= 0) {
                this.endExtendedPeriod(event.world);
            }
            if (worldTime != data.worldTime) {
                this.endExtendedPeriod(event.world);
            }
        } else {
            for (Map.Entry<Integer, Float> entry : extendedPeriods.entrySet()) {
                if (dayTime != entry.getKey()) continue;
                int ticks = TimeHelper.ticksFromMinutes((float)entry.getValue().floatValue());
                if (ticks > 0) {
                    this.startExtendedPeriod(event.world, ticks);
                    continue;
                }
                this.setWorldTime(event.world, worldTime);
            }
        }
        if (event.world.func_82737_E() % (long)Config.packetDelay == 0L) {
            long time = event.world.func_72820_D();
            ExtendedDays.network.wrapper.sendToAll((IMessage)new MessageSyncTime(time, this.extendedTime));
        }
        data.extendedTime = this.extendedTime;
        data.worldTime = worldTime;
        data.func_76185_a();
    }

    @SubscribeEvent
    public void onPlayerWakeUp(PlayerWakeUpEvent event) {
        World world = event.getEntityPlayer().field_70170_p;
        if (this.isInExtendedPeriod(world)) {
            this.endExtendedPeriod(world);
        }
    }

    public void startExtendedPeriod(World world, int timeInTicks) {
        this.setExtendedTime(timeInTicks);
        ExtendedDaysSavedData data = ExtendedDaysSavedData.get(world);
        if (data != null) {
            data.extendedTime = timeInTicks;
            data.func_76185_a();
        }
        ExtendedDays.network.wrapper.sendToAll((IMessage)new MessageSyncTime(world.func_72820_D(), this.extendedTime));
    }

    public void endExtendedPeriod(World world) {
        ExtendedDays.logHelper.debug("endExtendedPeriod", new Object[0]);
        this.setExtendedTime(0);
        ExtendedDaysSavedData data = ExtendedDaysSavedData.get(world);
        if (data != null) {
            data.extendedTime = 0;
            data.func_76185_a();
        }
    }

    public boolean isInExtendedPeriod(World world) {
        return this.extendedTime > 0;
    }

    public int getExtendedTime() {
        return this.extendedTime;
    }

    protected void setExtendedTime(int value) {
        this.extendedTime = value;
    }

    public int getCurrentTime(World world) {
        int result = (int)(world.func_72820_D() % 24000L);
        if (!TimeEvents.isOverworld(world)) {
            return result;
        }
        int worldTime = result;
        for (Map.Entry<Integer, Float> entry : extendedPeriods.entrySet()) {
            int ticksFromMinutes = TimeHelper.ticksFromMinutes((float)entry.getValue().floatValue());
            int k = 10;
            if (worldTime / k > entry.getKey() / k) {
                result += ticksFromMinutes;
            }
            if (worldTime / k != entry.getKey() / k) continue;
            result += ticksFromMinutes - this.extendedTime;
        }
        return result;
    }

    public int getTotalDayLength(World world) {
        int result = 24000;
        if (!TimeEvents.isOverworld(world)) {
            return result;
        }
        for (float minutes : extendedPeriods.values()) {
            result += TimeHelper.ticksFromMinutes((float)minutes);
        }
        return result;
    }

    public int getDaytimeLength(World world) {
        int result = 12000;
        if (!TimeEvents.isOverworld(world)) {
            return result;
        }
        for (Map.Entry<Integer, Float> entry : extendedPeriods.entrySet()) {
            if (entry.getKey() >= 12000) continue;
            result += TimeHelper.ticksFromMinutes((float)entry.getValue().floatValue());
        }
        return result;
    }

    public int getNighttimeLength(World world) {
        int result = 12000;
        if (!TimeEvents.isOverworld(world)) {
            return result;
        }
        for (Map.Entry<Integer, Float> entry : extendedPeriods.entrySet()) {
            if (entry.getKey() < 12000) continue;
            result += TimeHelper.ticksFromMinutes((float)entry.getValue().floatValue());
        }
        return result;
    }

    public void setActualTime(World world, long time) {
    }

    public void setTimeFromPacket(MessageSetTime msg) {
        if (msg.worldTime <= 0L || msg.extendedTime <= 0) {
            return;
        }
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server == null) {
            return;
        }
        WorldServer world = server.field_71305_c[0];
        if (world == null) {
            return;
        }
        this.setTime((World)world, msg.worldTime, msg.extendedTime);
    }

    public void setTime(World world, long worldTime, int extendedTime) {
        this.extendedTime = extendedTime;
        this.setWorldTime(world, worldTime);
        ExtendedDaysSavedData data = ExtendedDaysSavedData.get(world);
        if (data != null) {
            data.worldTime = worldTime;
            data.extendedTime = extendedTime;
        }
        ExtendedDays.network.wrapper.sendToAll((IMessage)new MessageSyncTime(worldTime, extendedTime));
    }

    void setWorldTime(World world, long worldTime) {
        if (world.func_72820_D() == worldTime || !TimeEvents.isOverworld(world)) {
            return;
        }
        if (worldTime < 1L) {
            return;
        }
        world.func_72877_b(worldTime);
    }

    @SideOnly(value=Side.CLIENT)
    public void syncTimeFromPacket(MessageSyncTime msg) {
        World world;
        if (msg.worldTime <= 0L || msg.extendedTime <= 0) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        World world2 = world = player == null ? null : player.field_70170_p;
        if (world != null) {
            this.setWorldTime(world, msg.worldTime);
        }
        this.extendedTime = msg.extendedTime;
        ClientEvents.worldTime = msg.worldTime;
    }

    public double getAdjustedWorldTime(World world) {
        return 24000.0 * (double)this.getCurrentTime(world) / (double)this.getTotalDayLength(world);
    }

    public double getCelestialAdjustedTime(World world) {
        int currentTime = this.getCurrentTime(world);
        if (currentTime >= this.getDaytimeLength(world)) {
            int nighttime = currentTime - this.getDaytimeLength(world);
            return 12000.0 * (double)nighttime / (double)this.getNighttimeLength(world) + 12000.0;
        }
        return 12000.0 * (double)currentTime / (double)this.getDaytimeLength(world);
    }

    public static boolean isOverworld(World world) {
        if (world == null || world.field_73011_w == null) {
            return false;
        }
        return world.field_73011_w.getDimension() == 0;
    }
}

