/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.extendeddays.client.render;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.IRenderHandler;
import net.silentchaos512.extendeddays.compat.BloodmoonCompat;
import net.silentchaos512.extendeddays.event.TimeEvents;
import net.silentchaos512.lib.util.GameUtil;

public class SkyRenderer
extends IRenderHandler {
    private static final boolean DISABLE_IN_DEV = true;
    private static final ResourceLocation MOON_PHASES_TEXTURES = new ResourceLocation("textures/environment/moon_phases.png");
    private static final ResourceLocation SUN_TEXTURES = new ResourceLocation("textures/environment/sun.png");

    public void render(float partialTicks, WorldClient world, Minecraft mc) {
        if (GameUtil.isDeobfuscated()) {
            return;
        }
        float celestialAngle = this.getCelestialAngle((World)world, partialTicks);
        GlStateManager.func_179090_x();
        Vec3d vec3d = world.func_72833_a(mc.func_175606_aa(), partialTicks);
        BloodmoonCompat.INSTANCE.skyColorHook(vec3d);
        float skyRed = (float)vec3d.field_72450_a;
        float skyGreen = (float)vec3d.field_72448_b;
        float skyBlue = (float)vec3d.field_72449_c;
        GlStateManager.func_179124_c((float)skyRed, (float)skyGreen, (float)skyBlue);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179127_m();
        GlStateManager.func_179124_c((float)skyRed, (float)skyGreen, (float)skyBlue);
        if (mc.field_71438_f.field_175005_X) {
            mc.field_71438_f.field_175012_t.func_177359_a();
            GlStateManager.func_187410_q((int)32884);
            GlStateManager.func_187420_d((int)3, (int)5126, (int)12, (int)0);
            mc.field_71438_f.field_175012_t.func_177358_a(7);
            mc.field_71438_f.field_175012_t.func_177361_b();
            GlStateManager.func_187429_p((int)32884);
        } else {
            GlStateManager.func_179148_o((int)mc.field_71438_f.field_72771_w);
        }
        GlStateManager.func_179106_n();
        GlStateManager.func_179118_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderHelper.func_74518_a();
        float[] afloat = world.field_73011_w.func_76560_a(celestialAngle, partialTicks);
        if (afloat != null) {
            GlStateManager.func_179090_x();
            GlStateManager.func_179103_j((int)7425);
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(MathHelper.func_76126_a((float)this.getCelestialAngleRadians((World)world, partialTicks)) < 0.0f ? 180.0f : 0.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            float red = afloat[0];
            float green = afloat[1];
            float blue = afloat[2];
            float alpha = afloat[3];
            bufferbuilder.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            bufferbuilder.func_181662_b(0.0, 100.0, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
            int j = 16;
            for (int l = 0; l <= 16; ++l) {
                float f21 = (float)l * ((float)Math.PI * 2) / 16.0f;
                float f12 = MathHelper.func_76126_a((float)f21);
                float f13 = MathHelper.func_76134_b((float)f21);
                bufferbuilder.func_181662_b((double)(f12 * 120.0f), (double)(f13 * 120.0f), (double)(-f13 * 40.0f * alpha)).func_181666_a(afloat[0], afloat[1], afloat[2], 0.0f).func_181675_d();
            }
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
            GlStateManager.func_179103_j((int)7424);
        }
        GlStateManager.func_179098_w();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179094_E();
        float weatherClearness = 1.0f - world.func_72867_j(partialTicks);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)weatherClearness);
        GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(celestialAngle * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        float f17 = 30.0f;
        mc.field_71446_o.func_110577_a(SUN_TEXTURES);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)(-f17), 100.0, (double)(-f17)).func_187315_a(0.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)f17, 100.0, (double)(-f17)).func_187315_a(1.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)f17, 100.0, (double)f17).func_187315_a(1.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b((double)(-f17), 100.0, (double)f17).func_187315_a(0.0, 1.0).func_181675_d();
        tessellator.func_78381_a();
        f17 = 20.0f;
        mc.field_71446_o.func_110577_a(MOON_PHASES_TEXTURES);
        Vec3d moonColor = this.getMoonColor((World)world, partialTicks);
        float moonRed = (float)moonColor.field_72450_a;
        float moonGreen = (float)moonColor.field_72448_b;
        float moonBlue = (float)moonColor.field_72449_c;
        GlStateManager.func_179124_c((float)moonRed, (float)moonGreen, (float)moonBlue);
        int moonPhase = world.func_72853_d();
        int k = moonPhase % 4;
        int i1 = moonPhase / 4 % 2;
        float f22 = (float)(k + 0) / 4.0f;
        float f23 = (float)(i1 + 0) / 2.0f;
        float f24 = (float)(k + 1) / 4.0f;
        float f14 = (float)(i1 + 1) / 2.0f;
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)(-f17), -100.0, (double)f17).func_187315_a((double)f24, (double)f14).func_181675_d();
        bufferbuilder.func_181662_b((double)f17, -100.0, (double)f17).func_187315_a((double)f22, (double)f14).func_181675_d();
        bufferbuilder.func_181662_b((double)f17, -100.0, (double)(-f17)).func_187315_a((double)f22, (double)f23).func_181675_d();
        bufferbuilder.func_181662_b((double)(-f17), -100.0, (double)(-f17)).func_187315_a((double)f24, (double)f23).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179090_x();
        float starBrightness = world.func_72880_h(partialTicks) * weatherClearness;
        if (starBrightness > 0.0f) {
            GlStateManager.func_179131_c((float)starBrightness, (float)starBrightness, (float)starBrightness, (float)starBrightness);
            if (mc.field_71438_f.field_175005_X) {
                mc.field_71438_f.field_175013_s.func_177359_a();
                GlStateManager.func_187410_q((int)32884);
                GlStateManager.func_187420_d((int)3, (int)5126, (int)12, (int)0);
                mc.field_71438_f.field_175013_s.func_177358_a(7);
                mc.field_71438_f.field_175013_s.func_177361_b();
                GlStateManager.func_187429_p((int)32884);
            } else {
                GlStateManager.func_179148_o((int)mc.field_71438_f.field_72772_v);
            }
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179127_m();
        GlStateManager.func_179121_F();
        GlStateManager.func_179090_x();
        GlStateManager.func_179124_c((float)0.0f, (float)0.0f, (float)0.0f);
        double d0 = mc.field_71439_g.func_174824_e((float)partialTicks).field_72448_b - world.func_72919_O();
        if (d0 < 0.0) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)12.0f, (float)0.0f);
            if (mc.field_71438_f.field_175005_X) {
                mc.field_71438_f.field_175011_u.func_177359_a();
                GlStateManager.func_187410_q((int)32884);
                GlStateManager.func_187420_d((int)3, (int)5126, (int)12, (int)0);
                mc.field_71438_f.field_175011_u.func_177358_a(7);
                mc.field_71438_f.field_175011_u.func_177361_b();
                GlStateManager.func_187429_p((int)32884);
            } else {
                GlStateManager.func_179148_o((int)mc.field_71438_f.field_72781_x);
            }
            GlStateManager.func_179121_F();
            float f18 = 1.0f;
            float f19 = -((float)(d0 + 65.0));
            float f20 = -1.0f;
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            bufferbuilder.func_181662_b(-1.0, (double)f19, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(1.0, (double)f19, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(1.0, -1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(-1.0, -1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(-1.0, -1.0, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(1.0, -1.0, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(1.0, (double)f19, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(-1.0, (double)f19, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(1.0, -1.0, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(1.0, -1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(1.0, (double)f19, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(1.0, (double)f19, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(-1.0, (double)f19, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(-1.0, (double)f19, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(-1.0, -1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(-1.0, -1.0, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(-1.0, -1.0, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(-1.0, -1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(1.0, -1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(1.0, -1.0, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            tessellator.func_78381_a();
        }
        if (world.field_73011_w.func_76561_g()) {
            GlStateManager.func_179124_c((float)(skyRed * 0.2f + 0.04f), (float)(skyGreen * 0.2f + 0.04f), (float)(skyBlue * 0.6f + 0.1f));
        } else {
            GlStateManager.func_179124_c((float)skyRed, (float)skyGreen, (float)skyBlue);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)(-((float)(d0 - 16.0))), (float)0.0f);
        GlStateManager.func_179148_o((int)mc.field_71438_f.field_72781_x);
        GlStateManager.func_179121_F();
        GlStateManager.func_179098_w();
        GlStateManager.func_179132_a((boolean)true);
    }

    private float getCelestialAngleRadians(World world, float partialTicks) {
        return this.getCelestialAngle(world, partialTicks) * ((float)Math.PI * 2);
    }

    private float getCelestialAngle(World world, float partialTicks) {
        double adjustedTime = TimeEvents.INSTANCE.getCelestialAdjustedTime(world);
        return world.field_73011_w.func_76563_a((long)adjustedTime, partialTicks);
    }

    private Vec3d getMoonColor(World world, float partialTicks) {
        Vec3d moonColor = new Vec3d(1.0, 1.0, 1.0);
        moonColor = BloodmoonCompat.INSTANCE.moonColorHook(moonColor);
        return moonColor;
    }
}

