/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.extendeddays.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.silentchaos512.extendeddays.compat.BloodmoonCompat;
import net.silentchaos512.extendeddays.config.Config;
import net.silentchaos512.extendeddays.event.ClientEvents;
import net.silentchaos512.extendeddays.event.TimeEvents;

public class ClockHud
extends Gui {
    public static final ClockHud INSTANCE = new ClockHud();
    private static final ResourceLocation TEXTURE = new ResourceLocation("extendeddays", "textures/gui/hud.png");
    private static final int CLOCK_BAR_WIDTH = 82;
    private static final int CLOCK_BAR_HEIGHT = 12;
    private static final int TIME_COLOR_NORMAL = 0xDDFFDD;
    private static final int TIME_COLOR_EXTENDED = 0xFFDDDD;

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Post event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!Config.clockEnabled || event.getType() != RenderGameOverlayEvent.ElementType.TEXT || mc.field_71474_y.field_74330_P) {
            return;
        }
        EntityPlayerSP player = mc.field_71439_g;
        World world = player.field_70170_p;
        int width = event.getResolution().func_78326_a();
        int height = event.getResolution().func_78328_b();
        if (ClientEvents.playerHasPocketWatch) {
            this.renderClock(mc, world, width, height, true);
        }
        if (Config.clockShowAlways || ClientEvents.playerHasVanillaClock || ClientEvents.playerCanSeeSky) {
            this.renderClock(mc, world, width, height, false);
        }
    }

    private void renderClock(Minecraft mc, World world, int screenWidth, int screenHeight, boolean hasPocketWatch) {
        long worldTime;
        int posY;
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        mc.field_71446_o.func_110577_a(TEXTURE);
        int posX = Config.clockPosX;
        if (posX < 0) {
            posX = posX + screenWidth - 82;
        }
        if ((posY = Config.clockPosY) < 0) {
            posY = posY + screenHeight - 12;
        }
        boolean isNight = (worldTime = world.func_72820_D() % 24000L) > 12000L;
        int texX = 0;
        int texY = 12 * (BloodmoonCompat.INSTANCE.isBloodmoonActive() ? 2 : (isNight ? 1 : 0));
        this.drawTexturedModalRect(posX, posY, texX, texY, 82, 12, -1426063361);
        texX = 87;
        int dayLength = isNight ? TimeEvents.INSTANCE.getNighttimeLength(world) : TimeEvents.INSTANCE.getDaytimeLength(world);
        int currentTime = TimeEvents.INSTANCE.getCurrentTime(world);
        if (isNight) {
            currentTime -= TimeEvents.INSTANCE.getDaytimeLength(world);
        }
        int x = 2 + (int)((float)posX + 78.0f * (float)currentTime / (float)dayLength) - 6;
        this.drawTexturedModalRect(x, posY, texX, texY, 12, 12, -570425345);
        if (hasPocketWatch && Config.watchShowTime) {
            currentTime = (int)TimeEvents.INSTANCE.getCelestialAdjustedTime(world);
            int adjustedTime = currentTime;
            int hour = adjustedTime / 1000 + 6;
            if (hour >= 24) {
                hour -= 24;
            }
            int minute = (int)(60.0f * ((float)(adjustedTime % 1000) / 1000.0f));
            String suffix = "";
            if (Config.watchUse12Hour) {
                suffix = " AM";
                if (hour > 12) {
                    hour -= 12;
                    suffix = " PM";
                }
                if (hour == 0) {
                    hour = 12;
                }
            }
            String str = String.format("%d:%02d%s", hour, minute, suffix);
            int strWidth = mc.field_71466_p.func_78256_a(str);
            int clockX = ClockHud.getTimeTextPosX(mc, posX, strWidth);
            int clockY = ClockHud.getTimeTextPosY(mc, posY, strWidth);
            int color = TimeEvents.INSTANCE.isInExtendedPeriod(world) ? 0xFFDDDD : 0xDDFFDD;
            mc.field_71466_p.func_175063_a(str, (float)clockX, (float)clockY, color);
        }
        GlStateManager.func_179121_F();
    }

    private static int getTimeTextPosX(Minecraft mc, int baseX, int strWidth) {
        switch (Config.clockTextPosition) {
            case AUTO: {
                return baseX + (Config.clockPosX < 0 ? -(strWidth + 5) : 87);
            }
            case LEFT: {
                return baseX + -(strWidth + 5);
            }
            case RIGHT: {
                return baseX + 82 + 5;
            }
            case TOP: 
            case BOTTOM: {
                return baseX + 41 - strWidth / 2;
            }
        }
        throw new IllegalStateException("Unknown clock text position: " + (Object)((Object)Config.clockTextPosition));
    }

    private static int getTimeTextPosY(Minecraft mc, int baseY, int strWidth) {
        switch (Config.clockTextPosition) {
            case AUTO: 
            case LEFT: 
            case RIGHT: {
                return baseY + mc.field_71466_p.field_78288_b / 2 - 2;
            }
            case TOP: {
                return baseY - 10;
            }
            case BOTTOM: {
                return baseY + 13;
            }
        }
        throw new IllegalStateException("Unknown clock text position: " + (Object)((Object)Config.clockTextPosition));
    }

    private void drawTexturedModalRect(int x, int y, int textureX, int textureY, int width, int height, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
        this.func_73729_b(x, y, textureX, textureY, width, height);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static enum TextPosition {
        AUTO,
        LEFT,
        RIGHT,
        TOP,
        BOTTOM;

    }
}

