/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic_view.ViewDistHandler;

import com.dynamic_view.DynView;
import com.dynamic_view.ViewDistHandler.IDynamicViewDistanceManager;
import com.dynamic_view.config.Configuration;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.server.FMLServerHandler;

public class ServerDynamicViewDistanceManager
implements IDynamicViewDistanceManager {
    private static final int UPDATE_LEEWAY = 2;
    private static ServerDynamicViewDistanceManager instance;
    private final int minChunkViewDist;
    private final int maxChunkViewDist;
    private final double meanTickToStayBelow;
    private int currentChunkViewDist = 0;

    private ServerDynamicViewDistanceManager() {
        this.minChunkViewDist = Configuration.dynamicChunk.minChunkViewDist;
        this.maxChunkViewDist = Configuration.dynamicChunk.maxChunkViewDist;
        this.meanTickToStayBelow = Configuration.dynamicChunk.meanAvgTickTime;
        this.currentChunkViewDist = this.minChunkViewDist;
    }

    public static IDynamicViewDistanceManager getInstance() {
        if (instance == null) {
            instance = new ServerDynamicViewDistanceManager();
        }
        return instance;
    }

    @Override
    public void initViewDist() {
        FMLServerHandler.instance().getServer().func_184103_al().func_152611_a(this.currentChunkViewDist);
    }

    @Override
    public void updateViewDistForMeanTick() {
        MinecraftServer server = FMLServerHandler.instance().getServer();
        if (server.func_184103_al().func_181057_v().isEmpty()) {
            return;
        }
        double meanTickTime = (double)ServerDynamicViewDistanceManager.average(server.field_71311_j) * 1.0E-6;
        if (meanTickTime - 2.0 > this.meanTickToStayBelow && this.currentChunkViewDist > this.minChunkViewDist) {
            --this.currentChunkViewDist;
            if (Configuration.dynamicChunk.logMessages) {
                DynView.LOGGER.info("Mean tick: " + Math.round(meanTickTime * 100.0) / 100L + "ms decreasing chunk view distance to: " + this.currentChunkViewDist);
            }
            server.func_184103_al().func_152611_a(this.currentChunkViewDist);
        }
        if (meanTickTime + 2.0 < this.meanTickToStayBelow && this.currentChunkViewDist < this.maxChunkViewDist) {
            ++this.currentChunkViewDist;
            if (Configuration.dynamicChunk.logMessages) {
                DynView.LOGGER.info("Mean tick: " + Math.round(meanTickTime * 100.0) / 100L + "ms increasing chunk view distance to: " + this.currentChunkViewDist);
            }
            server.func_184103_al().func_152611_a(this.currentChunkViewDist);
        }
    }

    private static long average(long[] values) {
        if (values == null || values.length == 0) {
            return 0L;
        }
        long sum = 0L;
        for (long v : values) {
            sum += v;
        }
        return sum / (long)values.length;
    }
}

