/*
 * Decompiled with CFR 0.152.
 */
package cursedflames.bountifulbaubles.wormhole;

import cursedflames.bountifulbaubles.capability.CapabilityWormholePins;
import cursedflames.bountifulbaubles.network.NBTPacket;
import cursedflames.bountifulbaubles.network.PacketHandler;
import cursedflames.bountifulbaubles.wormhole.IWormholeTarget;
import cursedflames.bountifulbaubles.wormhole.PlayerTarget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ContainerWormhole
extends Container {
    EntityPlayer player;
    List<IWormholeTarget> targets = new ArrayList<IWormholeTarget>();
    List<IWormholeTarget> pinned;
    int pinCount = 0;
    boolean dirty = false;
    boolean guiDirty = false;

    public ContainerWormhole(EntityPlayer player) {
        IWormholeTarget target;
        int i;
        this.player = player;
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        List<IWormholeTarget> pinned = new ArrayList<IWormholeTarget>();
        CapabilityWormholePins.IWormholePins cap = (CapabilityWormholePins.IWormholePins)player.getCapability(CapabilityWormholePins.PIN_CAP, null);
        if (cap != null) {
            pinned = cap.getPinList();
        }
        this.pinned = pinned;
        HashMap<Integer, IWormholeTarget> pinnedFound = new HashMap<Integer, IWormholeTarget>();
        ArrayList players = new ArrayList(player.field_70170_p.field_73010_i);
        players.remove(player);
        boolean survivalOnly = !player.func_184812_l_() && !player.func_175149_v();
        for (EntityPlayer entity : players) {
            if (entity.func_175149_v() || survivalOnly && entity.func_184812_l_()) continue;
            this.targets.add(new PlayerTarget(entity));
        }
        block1: for (i = 0; i < this.targets.size(); ++i) {
            target = this.targets.get(i);
            for (int j = 0; j < pinned.size(); ++j) {
                IWormholeTarget other = pinned.get(j);
                if (!target.isEqual(other)) continue;
                pinnedFound.put(j, target);
                this.targets.remove(i);
                --i;
                continue block1;
            }
        }
        for (i = pinned.size() - 1; i >= 0; --i) {
            if (pinnedFound.containsKey(i)) {
                target = (IWormholeTarget)pinnedFound.get(i);
            } else {
                target = pinned.get(i);
                target.setEnabled(false);
            }
            this.targets.add(0, target);
        }
        this.pinCount = pinned.size();
        this.dirty = true;
    }

    public boolean func_75145_c(EntityPlayer player) {
        return player == this.player;
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.player.field_70170_p.field_72995_K || !this.dirty) {
            return;
        }
        NBTTagCompound changes = new NBTTagCompound();
        NBTTagCompound targetsNBT = new NBTTagCompound();
        int i = 0;
        for (IWormholeTarget target : this.targets) {
            NBTTagCompound targetNBT = target.toNBT();
            if (targetNBT == null) continue;
            targetNBT.func_74757_a("enabled", target.isEnabled());
            targetsNBT.func_74782_a(String.valueOf(i++), (NBTBase)targetNBT);
        }
        changes.func_74782_a("targets", (NBTBase)targetsNBT);
        changes.func_74768_a("pinCount", this.pinCount);
        for (int j = 0; j < this.field_75149_d.size(); ++j) {
            if (!(this.field_75149_d.get(j) instanceof EntityPlayerMP)) continue;
            PacketHandler.INSTANCE.sendTo((IMessage)new NBTPacket(changes, PacketHandler.HandlerIds.WORMHOLE_UPDATE_GUI.id), (EntityPlayerMP)this.field_75149_d.get(j));
        }
        this.dirty = false;
    }

    public void readChanges(NBTTagCompound tag) {
        NBTTagCompound targetsNBT = tag.func_74775_l("targets");
        if (targetsNBT.func_186856_d() > 0) {
            this.targets.clear();
            CapabilityWormholePins.targetListFromNBT(this.targets, targetsNBT);
            this.guiDirty = true;
        }
        if (tag.func_74764_b("pinCount")) {
            this.pinCount = tag.func_74762_e("pinCount");
        }
    }

    public void pin(int index) {
        if (index < 0 || index > this.targets.size() - 1) {
            return;
        }
        IWormholeTarget target = this.targets.get(index);
        if (index < this.pinCount) {
            --this.pinCount;
            this.targets.add(this.pinCount + 1, target);
            this.targets.remove(index);
            this.pinned.remove(index);
        } else {
            ++this.pinCount;
            this.targets.remove(index);
            this.targets.add(this.pinCount - 1, target);
            this.pinned.add(target);
        }
        this.dirty = true;
    }
}

