/*
 * Decompiled with CFR 0.152.
 */
package cursedflames.bountifulbaubles.item;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import baubles.api.render.IRenderBauble;
import com.google.common.collect.Multimap;
import cursedflames.bountifulbaubles.BountifulBaubles;
import cursedflames.bountifulbaubles.baubleeffect.BaubleAttributeModifierHandler;
import cursedflames.bountifulbaubles.item.base.IItemAttributeModifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.item.IPhantomInkable;

public class ItemShieldCobalt
extends ItemShield
implements IBauble,
IRenderBauble,
IItemAttributeModifier {
    public static final UUID KNOCKBACK_RESISTANCE_UUID = UUID.fromString("418ed1da-15ae-4c7b-ac5e-4807ca52ffe3");
    public static final UUID KNOCKBACK_RESISTANCE_BAUBLE_UUID = UUID.fromString("9016ba1d-70dd-46c4-b0b4-fc4ea39886c1");
    private static final Map<IAttribute, AttributeModifier> modMap = new HashMap<IAttribute, AttributeModifier>();

    public ItemShieldCobalt(String name) {
        this.setRegistryName(name);
        this.func_77655_b("bountifulbaubles." + name);
        this.func_77637_a(BountifulBaubles.TAB);
        this.func_77656_e(1008);
        BountifulBaubles.registryHelper.addItemModel((Item)this);
    }

    public static boolean isUsable(ItemStack stack) {
        return stack.func_77952_i() < stack.func_77958_k();
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (ItemShieldCobalt.isUsable(itemstack)) {
            playerIn.func_184598_c(handIn);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return repair.func_77973_b() == Items.field_151042_j;
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        if (player.func_184607_cu() == null) {
            return;
        }
        ItemStack stack = player.func_184607_cu();
        float damage = event.getAmount();
        if (damage > 5.0f && stack != null && stack.func_77973_b() instanceof ItemShieldCobalt) {
            int i = Math.min(1 + (int)damage, stack.func_77958_k() - stack.func_77952_i());
            stack.func_77972_a(i, (EntityLivingBase)player);
            if (stack.func_190926_b() || stack.func_77952_i() >= stack.func_77958_k()) {
                if (stack.func_190926_b()) {
                    EnumHand enumhand = player.func_184600_cs();
                    ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)stack, (EnumHand)enumhand);
                    if (enumhand == EnumHand.MAIN_HAND) {
                        player.func_184201_a(EntityEquipmentSlot.MAINHAND, (ItemStack)null);
                    } else {
                        player.func_184201_a(EntityEquipmentSlot.OFFHAND, (ItemStack)null);
                    }
                    stack = null;
                }
                player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187769_eM, SoundCategory.PLAYERS, 0.9f, 0.8f + player.field_70170_p.field_73012_v.nextFloat() * 0.4f);
            }
        }
    }

    @SubscribeEvent
    public static void onAnvilUpdate(AnvilUpdateEvent event) {
        ItemShieldCobalt.resetRepairValue(event.getLeft());
        ItemShieldCobalt.resetRepairValue(event.getRight());
    }

    @SubscribeEvent
    public static void onAnvilUpdate(AnvilRepairEvent event) {
        ItemShieldCobalt.resetRepairValue(event.getItemResult());
    }

    private static void resetRepairValue(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemShieldCobalt && stack.func_77942_o()) {
            stack.func_77978_p().func_82580_o("RepairCost");
        }
    }

    public String func_77653_i(ItemStack stack) {
        return BountifulBaubles.proxy.translate(this.func_77658_a() + ".name");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!stack.func_77978_p().func_74764_b("HideFlags")) {
            stack.func_77978_p().func_74768_a("HideFlags", 2);
        }
        if (stack.func_77952_i() >= stack.func_77958_k()) {
            tooltip.add(I18n.func_74838_a((String)"bountifulbaubles.broken"));
        }
        tooltip.add(I18n.func_74838_a((String)(this.func_77658_a() + ".tooltip.0")));
        if (GuiScreen.func_146272_n()) {
            tooltip.add(I18n.func_74838_a((String)(this.func_77658_a() + ".tooltip.1")));
            tooltip.add(I18n.func_74838_a((String)(this.func_77658_a() + ".tooltip.2")));
            if (stack.func_77973_b() instanceof IPhantomInkable && ((IPhantomInkable)stack.func_77973_b()).hasPhantomInk(stack)) {
                tooltip.add(BountifulBaubles.proxy.translate("bountifulbaubles.misc.hasPhantomInk"));
            }
        } else {
            tooltip.add(I18n.func_74838_a((String)"bountifulbaubles.moreinfo"));
        }
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap mods = super.getAttributeModifiers(slot, stack);
        if (slot == EntityEquipmentSlot.MAINHAND || slot == EntityEquipmentSlot.OFFHAND) {
            String knockback = SharedMonsterAttributes.field_111266_c.func_111108_a();
            mods.put((Object)knockback, (Object)new AttributeModifier(KNOCKBACK_RESISTANCE_UUID, "Cobalt Shield knockback resistance", 10.0, 0));
        }
        return mods;
    }

    public BaubleType getBaubleType(ItemStack arg0) {
        return BaubleType.TRINKET;
    }

    public void onEquipped(ItemStack stack, EntityLivingBase player) {
        BaubleAttributeModifierHandler.baubleModified(stack, player, true);
    }

    public void onUnequipped(ItemStack stack, EntityLivingBase player) {
        BaubleAttributeModifierHandler.baubleModified(stack, player, false);
    }

    @Override
    public Map<IAttribute, AttributeModifier> getModifiers(ItemStack stack, EntityPlayer player) {
        return modMap;
    }

    public void onPlayerBaubleRender(ItemStack stack, EntityPlayer player, IRenderBauble.RenderType type, float partialTicks) {
        if (type == IRenderBauble.RenderType.BODY) {
            IRenderBauble.Helper.rotateIfSneaking((EntityPlayer)player);
            boolean armor = !player.func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b();
            GlStateManager.func_179139_a((double)0.6, (double)0.6, (double)0.6);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179137_b((double)0.5, (double)-0.25, (double)(armor ? 0.75 : 0.7));
            Minecraft.func_71410_x().func_175599_af().func_181564_a(stack, ItemCameraTransforms.TransformType.NONE);
        }
    }

    static {
        modMap.put(SharedMonsterAttributes.field_111266_c, new AttributeModifier(KNOCKBACK_RESISTANCE_BAUBLE_UUID, "Cobalt Shield (bauble slot) knockback resistance", 10.0, 0));
    }
}

