/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.particle;

import epicsquid.mysticallib.MysticalLib;
import epicsquid.mysticallib.particle.ParticleBase;
import epicsquid.mysticallib.proxy.ClientProxy;
import epicsquid.mysticallib.util.Util;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class ParticleRegistry {
    public static EnumParticleTypes RAIN = null;
    public static Map<Class<? extends ParticleBase>, List<ResourceLocation>> particleMultiTextures = new HashMap<Class<? extends ParticleBase>, List<ResourceLocation>>();
    private static Map<Class<? extends ParticleBase>, Constructor<? extends ParticleBase>> particles = new HashMap<Class<? extends ParticleBase>, Constructor<? extends ParticleBase>>();
    private static Random rand = new Random();

    public static ResourceLocation getTexture(Class<? extends ParticleBase> clazz) {
        List<ResourceLocation> textures = particleMultiTextures.get(clazz);
        return textures.get(rand.nextInt(textures.size()));
    }

    public static Class<? extends ParticleBase> registerParticle(@Nonnull String modid, @Nonnull Class<? extends ParticleBase> particleClass, ResourceLocation ... textures) {
        if (MysticalLib.proxy instanceof ClientProxy) {
            try {
                if (particles.containsKey(particleClass) || particleMultiTextures.containsKey(particleClass)) {
                    System.out.println("WARNING: PARTICLE ALREADY REGISTERED WITH NAME \"" + Util.getLowercaseClassName(particleClass) + "\"!");
                } else {
                    particles.put(particleClass, particleClass.getConstructor(World.class, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, double[].class));
                    particleMultiTextures.put(particleClass, Arrays.asList(textures));
                }
            }
            catch (NoSuchMethodException | SecurityException e) {
                e.printStackTrace();
            }
        }
        return particleClass;
    }

    public static Map<Class<? extends ParticleBase>, Constructor<? extends ParticleBase>> getParticles() {
        return particles;
    }
}

